/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.Addr64Factory;
import org.eclipse.cdt.utils.ERandomAccessFile;
import org.eclipse.cdt.utils.debug.dwarf.DwarfReader;

public class Elf {
    public static final int ELF32_ADDR_SIZE = 4;
    public static final int ELF32_OFF_SIZE = 4;
    public static final int ELF64_ADDR_SIZE = 8;
    public static final int ELF64_OFF_SIZE = 8;
    protected ERandomAccessFile efile;
    protected ELFhdr ehdr;
    protected Section[] sections;
    protected String file;
    protected byte[] section_strtab;
    private int syms = 0;
    private Symbol[] symbols;
    private Symbol[] symtab_symbols;
    private Section symtab_sym;
    private Symbol[] dynsym_symbols;
    private Section dynsym_sym;
    private boolean sections_mapped;
    protected String EMPTY_STRING = "";

    protected String string_from_elf_section(Section section, int index) throws IOException {
        int len;
        if ((long)index > section.sh_size) {
            return this.EMPTY_STRING;
        }
        StringBuffer str = new StringBuffer();
        byte[] tmp = new byte[50];
        this.efile.seek(section.sh_offset + (long)index);
        block0: do {
            len = this.efile.read(tmp);
            int i = 0;
            while (i < len) {
                if (tmp[i] == 0) {
                    len = 0;
                    continue block0;
                }
                str.append((char)tmp[i]);
                ++i;
            }
        } while (len > 0);
        return str.toString();
    }

    public PHdr[] getPHdrs() throws IOException {
        if (this.ehdr.e_phnum == 0) {
            return new PHdr[0];
        }
        this.efile.seek(this.ehdr.e_phoff);
        int length = this.ehdr.e_phnum & 0xFFFF;
        PHdr[] phdrs = new PHdr[length];
        int i = 0;
        while (i < length) {
            phdrs[i] = new PHdr();
            switch (this.ehdr.e_ident[4]) {
                case 1: {
                    byte[] addrArray = new byte[4];
                    phdrs[i].p_type = this.efile.readIntE();
                    phdrs[i].p_offset = this.efile.readIntE();
                    this.efile.readFullyE(addrArray);
                    phdrs[i].p_vaddr = new Addr32(addrArray);
                    this.efile.readFullyE(addrArray);
                    phdrs[i].p_paddr = new Addr32(addrArray);
                    phdrs[i].p_filesz = this.efile.readIntE();
                    phdrs[i].p_memsz = this.efile.readIntE();
                    phdrs[i].p_flags = this.efile.readIntE();
                    phdrs[i].p_align = this.efile.readIntE();
                    break;
                }
                case 2: {
                    byte[] addrArray = new byte[8];
                    phdrs[i].p_type = this.efile.readIntE();
                    phdrs[i].p_flags = this.efile.readIntE();
                    phdrs[i].p_offset = this.readUnsignedLong(this.efile);
                    this.efile.readFullyE(addrArray);
                    phdrs[i].p_vaddr = new Addr64(addrArray);
                    this.efile.readFullyE(addrArray);
                    phdrs[i].p_paddr = new Addr64(addrArray);
                    phdrs[i].p_filesz = this.readUnsignedLong(this.efile);
                    phdrs[i].p_memsz = this.readUnsignedLong(this.efile);
                    phdrs[i].p_align = this.readUnsignedLong(this.efile);
                    break;
                }
                default: {
                    throw new IOException("Unknown ELF class " + this.ehdr.e_ident[4]);
                }
            }
            ++i;
        }
        return phdrs;
    }

    public Dynamic[] getDynamicSections(Section section) throws IOException {
        if (section.sh_type != 6L) {
            return new Dynamic[0];
        }
        ArrayList<Dynamic> dynList = new ArrayList<Dynamic>();
        this.efile.seek(section.sh_offset);
        int off = 0;
        while ((long)off < section.sh_size) {
            Dynamic dynEnt = new Dynamic(section);
            switch (this.ehdr.e_ident[4]) {
                case 1: {
                    dynEnt.d_tag = this.efile.readIntE();
                    dynEnt.d_val = this.efile.readIntE();
                    off += 8;
                    break;
                }
                case 2: {
                    dynEnt.d_tag = this.efile.readLongE();
                    dynEnt.d_val = this.efile.readLongE();
                    off += 16;
                    break;
                }
                default: {
                    throw new IOException("Unknown ELF class " + this.ehdr.e_ident[4]);
                }
            }
            if (dynEnt.d_tag == 0L) continue;
            dynList.add(dynEnt);
        }
        return dynList.toArray(new Dynamic[0]);
    }

    private void commonSetup(String file, long offset) throws IOException {
        try {
            this.efile = new ERandomAccessFile(file, "r");
            this.efile.setFileOffset(offset);
            this.ehdr = new ELFhdr();
            this.file = file;
        }
        finally {
            if (this.ehdr == null) {
                this.dispose();
            }
        }
    }

    protected Elf() {
    }

    public Elf(String file, long offset) throws IOException {
        this.commonSetup(file, offset);
    }

    public Elf(String file) throws IOException {
        this.commonSetup(file, 0L);
    }

    public ELFhdr getELFhdr() throws IOException {
        return this.ehdr;
    }

    public Attribute getAttributes() throws IOException {
        Attribute attrib = new Attribute();
        switch (this.ehdr.e_type) {
            case 4: {
                attrib.type = 4;
                break;
            }
            case 2: {
                attrib.type = 1;
                break;
            }
            case 1: {
                attrib.type = 3;
                break;
            }
            case 3: {
                attrib.type = 2;
            }
        }
        switch (this.ehdr.e_machine & 0xFFFF) {
            case 3: 
            case 6: {
                attrib.cpu = "x86";
                break;
            }
            case 4: {
                attrib.cpu = "m68k";
                break;
            }
            case 11: 
            case 20: 
            case 36901: {
                attrib.cpu = "ppc";
                break;
            }
            case 21: {
                attrib.cpu = "ppc64";
                break;
            }
            case 42: {
                attrib.cpu = "sh";
                break;
            }
            case 40: {
                attrib.cpu = "arm";
                break;
            }
            case 8: 
            case 10: {
                attrib.cpu = "mips";
                break;
            }
            case 2: 
            case 18: 
            case 43: {
                attrib.cpu = "sparc";
                break;
            }
            case 46: 
            case 47: {
                attrib.cpu = "h8300";
                break;
            }
            case 87: 
            case 36992: {
                attrib.cpu = "v850";
                break;
            }
            case 89: 
            case 48879: {
                attrib.cpu = "mn10300";
                break;
            }
            case 90: 
            case 57005: {
                attrib.cpu = "mn10200";
                break;
            }
            case 88: {
                attrib.cpu = "m32r";
                break;
            }
            case 84: 
            case 13104: {
                attrib.cpu = "fr30";
                break;
            }
            case 44357: {
                attrib.cpu = "xstormy16";
                break;
            }
            case 21569: {
                attrib.cpu = "frv";
                break;
            }
            case 65210: {
                attrib.cpu = "iq2000";
                break;
            }
            case 111: {
                attrib.cpu = "excess";
                break;
            }
            case 113: {
                attrib.cpu = "alteranios2";
                break;
            }
            case 65211: {
                attrib.cpu = "alteranios";
                break;
            }
            case 50: {
                attrib.cpu = "ia64";
                break;
            }
            case 52: {
                attrib.cpu = "coldfire";
                break;
            }
            case 83: {
                attrib.cpu = "avr";
                break;
            }
            case 105: {
                attrib.cpu = "msp430";
                break;
            }
            case 94: {
                attrib.cpu = "xtensa";
                break;
            }
            case 60: {
                attrib.cpu = "st100";
                break;
            }
            case 62: {
                attrib.cpu = "x86_64";
                break;
            }
            case 47787: {
                attrib.cpu = "microblaze";
                break;
            }
            case 116: {
                attrib.cpu = "c166";
                break;
            }
            case 44: {
                attrib.cpu = "TriCore";
                break;
            }
            case 117: {
                attrib.cpu = "M16C";
                break;
            }
            case 58: {
                attrib.cpu = "StarCore";
                break;
            }
            case 106: {
                attrib.cpu = "bfin";
                break;
            }
            case 51966: {
                attrib.cpu = "sdma";
                break;
            }
            case 19797: {
                attrib.cpu = "cradle";
                break;
            }
            case 160: {
                attrib.cpu = "mmdsp";
                break;
            }
            default: {
                attrib.cpu = "none";
            }
        }
        switch (this.ehdr.e_ident[5]) {
            case 1: {
                attrib.isle = true;
                break;
            }
            case 2: {
                attrib.isle = false;
            }
        }
        switch (this.ehdr.e_ident[4]) {
            case 1: {
                attrib.addressFactory = new Addr32Factory();
                break;
            }
            case 2: {
                attrib.addressFactory = new Addr64Factory();
                break;
            }
            default: {
                attrib.addressFactory = null;
            }
        }
        Section[] sec = this.getSections();
        if (sec != null) {
            int i = 0;
            while (i < sec.length) {
                String s = sec[i].toString();
                if (s.startsWith(".debug")) {
                    attrib.debugType = 2;
                    break;
                }
                if (s.equals(".stab")) {
                    attrib.debugType = 1;
                    break;
                }
                ++i;
            }
        }
        return attrib;
    }

    public static Attribute getAttributes(String file) throws IOException {
        Elf elf = new Elf(file);
        Attribute attrib = elf.getAttributes();
        elf.dispose();
        return attrib;
    }

    public static Attribute getAttributes(byte[] array) throws IOException {
        Elf emptyElf;
        Elf elf = emptyElf = new Elf();
        elf.getClass();
        emptyElf.ehdr = elf.new ELFhdr(array);
        emptyElf.sections = new Section[0];
        Attribute attrib = emptyElf.getAttributes();
        emptyElf.dispose();
        return attrib;
    }

    public static boolean isElfHeader(byte[] e_ident) {
        return e_ident.length >= 4 && e_ident[0] == 127 && e_ident[1] == 69 && e_ident[2] == 76 && e_ident[3] == 70;
    }

    public void dispose() {
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
                if (this.sections_mapped) {
                    System.gc();
                }
            }
        }
        catch (IOException iOException) {}
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public Section getSectionByName(String name) throws IOException {
        if (this.sections == null) {
            this.getSections();
        }
        int i = 0;
        while (i < this.sections.length) {
            if (this.sections[i].toString().equals(name)) {
                return this.sections[i];
            }
            ++i;
        }
        return null;
    }

    public Section[] getSections(int type) throws IOException {
        if (this.sections == null) {
            this.getSections();
        }
        ArrayList<Section> slist = new ArrayList<Section>();
        int i = 0;
        while (i < this.sections.length) {
            if (this.sections[i].sh_type == (long)type) {
                slist.add(this.sections[i]);
            }
            ++i;
        }
        return slist.toArray(new Section[0]);
    }

    public Section[] getSections() throws IOException {
        if (this.sections == null) {
            if (this.ehdr.e_shoff == 0L) {
                this.sections = new Section[0];
                return this.sections;
            }
            int length = this.ehdr.e_shnum & 0xFFFF;
            this.sections = new Section[length];
            int i = 0;
            while (i < length) {
                this.efile.seek(this.ehdr.e_shoff + (long)(i * (this.ehdr.e_shentsize & 0xFFFF)));
                this.sections[i] = new Section();
                this.sections[i].sh_name = this.efile.readIntE();
                this.sections[i].sh_type = this.efile.readIntE();
                switch (this.ehdr.e_ident[4]) {
                    case 1: {
                        byte[] addrArray = new byte[4];
                        this.sections[i].sh_flags = this.efile.readIntE();
                        this.efile.readFullyE(addrArray);
                        this.sections[i].sh_addr = new Addr32(addrArray);
                        this.sections[i].sh_offset = this.efile.readIntE();
                        this.sections[i].sh_size = this.efile.readIntE();
                        break;
                    }
                    case 2: {
                        byte[] addrArray = new byte[8];
                        this.sections[i].sh_flags = this.efile.readLongE();
                        this.efile.readFullyE(addrArray);
                        this.sections[i].sh_addr = new Addr64(addrArray);
                        this.sections[i].sh_offset = this.readUnsignedLong(this.efile);
                        this.sections[i].sh_size = this.readUnsignedLong(this.efile);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown ELF class " + this.ehdr.e_ident[4]);
                    }
                }
                this.sections[i].sh_link = this.efile.readIntE();
                this.sections[i].sh_info = this.efile.readIntE();
                switch (this.ehdr.e_ident[4]) {
                    case 1: {
                        this.sections[i].sh_addralign = this.efile.readIntE();
                        this.sections[i].sh_entsize = this.efile.readIntE();
                        break;
                    }
                    case 2: {
                        this.sections[i].sh_addralign = this.efile.readLongE();
                        this.sections[i].sh_entsize = this.readUnsignedLong(this.efile);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown ELF class " + this.ehdr.e_ident[4]);
                    }
                }
                if (this.sections[i].sh_type == 2L) {
                    this.syms = i;
                }
                if (this.syms == 0 && this.sections[i].sh_type == 11L) {
                    this.syms = i;
                }
                ++i;
            }
        }
        return this.sections;
    }

    private Symbol[] loadSymbolsBySection(Section section) throws IOException {
        int numSyms = 1;
        if (section.sh_entsize != 0L) {
            numSyms = (int)section.sh_size / (int)section.sh_entsize;
        }
        ArrayList<Symbol> symList = new ArrayList<Symbol>(numSyms);
        long offset = section.sh_offset;
        int c = 0;
        while (c < numSyms) {
            this.efile.seek(offset);
            Symbol symbol = new Symbol(section);
            switch (this.ehdr.e_ident[4]) {
                case 1: {
                    byte[] addrArray = new byte[4];
                    symbol.st_name = this.efile.readIntE();
                    this.efile.readFullyE(addrArray);
                    symbol.st_value = new Addr32(addrArray);
                    symbol.st_size = this.efile.readIntE();
                    symbol.st_info = this.efile.readByte();
                    symbol.st_other = this.efile.readByte();
                    symbol.st_shndx = this.efile.readShortE();
                    break;
                }
                case 2: {
                    byte[] addrArray = new byte[8];
                    symbol.st_name = this.efile.readIntE();
                    symbol.st_info = this.efile.readByte();
                    symbol.st_other = this.efile.readByte();
                    symbol.st_shndx = this.efile.readShortE();
                    this.efile.readFullyE(addrArray);
                    symbol.st_value = new Addr64(addrArray);
                    symbol.st_size = this.readUnsignedLong(this.efile);
                    break;
                }
                default: {
                    throw new IOException("Unknown ELF class " + this.ehdr.e_ident[4]);
                }
            }
            if (symbol.st_info != 0) {
                symList.add(symbol);
            }
            offset += section.sh_entsize;
            ++c;
        }
        Object[] results = symList.toArray(new Symbol[0]);
        Arrays.sort(results);
        return results;
    }

    public void loadSymbols() throws IOException {
        if (this.symbols == null) {
            Section[] section = this.getSections(2);
            if (section.length > 0) {
                this.symtab_sym = section[0];
                this.symtab_symbols = this.loadSymbolsBySection(section[0]);
            } else {
                this.symtab_sym = null;
                this.symtab_symbols = new Symbol[0];
            }
            section = this.getSections(11);
            if (section.length > 0) {
                this.dynsym_sym = section[0];
                this.dynsym_symbols = this.loadSymbolsBySection(section[0]);
            } else {
                this.dynsym_sym = null;
                this.dynsym_symbols = new Symbol[0];
            }
            if (this.symtab_sym != null) {
                this.symbols = this.symtab_symbols;
            } else if (this.dynsym_sym != null) {
                this.symbols = this.dynsym_symbols;
            }
        }
    }

    public Symbol[] getSymbols() {
        return this.symbols;
    }

    public Symbol[] getDynamicSymbols() {
        return this.dynsym_symbols;
    }

    public Symbol[] getSymtabSymbols() {
        return this.symtab_symbols;
    }

    public Symbol getSymbol(IAddress vma) {
        if (this.symbols == null) {
            return null;
        }
        SymbolComparator symbol_comparator = new SymbolComparator();
        int ndx = Arrays.binarySearch(this.symbols, vma, symbol_comparator);
        if (ndx > 0) {
            return this.symbols[ndx];
        }
        if (ndx == -1) {
            return null;
        }
        ndx = -ndx - 1;
        return this.symbols[ndx - 1];
    }

    public String getFilename() {
        return this.file;
    }

    protected long readUnsignedLong(ERandomAccessFile file) throws IOException {
        long result = file.readLongE();
        if (result < 0L) {
            throw new IOException("Maximal file offset is " + Long.toHexString(Long.MAX_VALUE) + " given offset is " + Long.toHexString(result));
        }
        return result;
    }

    private ISymbolReader createDwarfReader() {
        DwarfReader reader = null;
        try {
            reader = new DwarfReader(this);
        }
        catch (IOException iOException) {}
        return reader;
    }

    public ISymbolReader getSymbolReader() {
        ISymbolReader reader = null;
        reader = this.createDwarfReader();
        return reader;
    }

    public class Attribute {
        public static final int ELF_TYPE_EXE = 1;
        public static final int ELF_TYPE_SHLIB = 2;
        public static final int ELF_TYPE_OBJ = 3;
        public static final int ELF_TYPE_CORE = 4;
        public static final int DEBUG_TYPE_NONE = 0;
        public static final int DEBUG_TYPE_STABS = 1;
        public static final int DEBUG_TYPE_DWARF = 2;
        String cpu;
        int type;
        int debugType;
        boolean bDebug;
        boolean isle;
        IAddressFactory addressFactory;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.debugType != 0;
        }

        public int getDebugType() {
            return this.debugType;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }

        public IAddressFactory getAddressFactory() {
            return this.addressFactory;
        }
    }

    public class Dynamic {
        public static final int DYN_ENT_SIZE_32 = 8;
        public static final int DYN_ENT_SIZE_64 = 16;
        public static final int DT_NULL = 0;
        public static final int DT_NEEDED = 1;
        public static final int DT_PLTRELSZ = 2;
        public static final int DT_PLTGOT = 3;
        public static final int DT_HASH = 4;
        public static final int DT_STRTAB = 5;
        public static final int DT_SYMTAB = 6;
        public static final int DT_RELA = 7;
        public static final int DT_RELASZ = 8;
        public static final int DT_RELAENT = 9;
        public static final int DT_STRSZ = 10;
        public static final int DT_SYMENT = 11;
        public static final int DT_INIT = 12;
        public static final int DT_FINI = 13;
        public static final int DT_SONAME = 14;
        public static final int DT_RPATH = 15;
        public long d_tag;
        public long d_val;
        private final Section section;
        private String name;

        protected Dynamic(Section section) {
            this.section = section;
        }

        public String toString() {
            if (this.name == null) {
                switch ((int)this.d_tag) {
                    case 1: 
                    case 14: 
                    case 15: {
                        try {
                            Section symstr = Elf.this.sections[(int)this.section.sh_link];
                            this.name = Elf.this.string_from_elf_section(symstr, (int)this.d_val);
                        }
                        catch (IOException iOException) {
                            this.name = Elf.this.EMPTY_STRING;
                        }
                        break;
                    }
                    default: {
                        this.name = Elf.this.EMPTY_STRING;
                    }
                }
            }
            return this.name;
        }
    }

    public class ELFhdr {
        public static final int EI_MAG0 = 0;
        public static final int EI_MAG1 = 1;
        public static final int EI_MAG2 = 2;
        public static final int EI_MAG3 = 3;
        public static final int EI_CLASS = 4;
        public static final int EI_DATA = 5;
        public static final int EI_VERSION = 6;
        public static final int EI_PAD = 7;
        public static final int EI_NDENT = 16;
        public static final int ELFCLASSNONE = 0;
        public static final int ELFCLASS32 = 1;
        public static final int ELFCLASS64 = 2;
        public static final int ELFDATANONE = 0;
        public static final int ELFDATA2LSB = 1;
        public static final int ELFDATA2MSB = 2;
        public static final int ET_NONE = 0;
        public static final int ET_REL = 1;
        public static final int ET_EXEC = 2;
        public static final int ET_DYN = 3;
        public static final int ET_CORE = 4;
        public static final int ET_LOPROC = 65280;
        public static final int ET_HIPROC = 65535;
        public static final int EM_NONE = 0;
        public static final int EM_M32 = 1;
        public static final int EM_SPARC = 2;
        public static final int EM_386 = 3;
        public static final int EM_68K = 4;
        public static final int EM_88K = 5;
        public static final int EM_486 = 6;
        public static final int EM_860 = 7;
        public static final int EM_MIPS = 8;
        public static final int EM_MIPS_RS3_LE = 10;
        public static final int EM_RS6000 = 11;
        public static final int EM_PARISC = 15;
        public static final int EM_nCUBE = 16;
        public static final int EM_VPP550 = 17;
        public static final int EM_SPARC32PLUS = 18;
        public static final int EM_PPC = 20;
        public static final int EM_PPC64 = 21;
        public static final int EM_ARM = 40;
        public static final int EM_SH = 42;
        public static final int EM_SPARCV9 = 43;
        public static final int EM_TRICORE = 44;
        public static final int EM_H8_300 = 46;
        public static final int EM_H8_300H = 47;
        public static final int EM_IA_64 = 50;
        public static final int EM_COLDFIRE = 52;
        public static final int EM_STARCORE = 58;
        public static final int EM_X86_64 = 62;
        public static final int EM_ST100 = 60;
        public static final int EM_AVR = 83;
        public static final int EM_FR30 = 84;
        public static final int EM_V850 = 87;
        public static final int EM_M32R = 88;
        public static final int EM_MN10300 = 89;
        public static final int EM_MN10200 = 90;
        public static final int EM_XTENSA = 94;
        public static final int EM_MSP430 = 105;
        public static final int EM_BLACKFIN = 106;
        public static final int EM_EXCESS = 111;
        public static final int EM_NIOSII = 113;
        public static final int EM_C166 = 116;
        public static final int EM_M16C = 117;
        public static final int EM_MMDSP = 160;
        public static final int EM_NIOS = 65211;
        public static final int EM_CYGNUS_POWERPC = 36901;
        public static final int EM_CYGNUS_M32R = 36929;
        public static final int EM_CYGNUS_V850 = 36992;
        public static final int EM_CYGNUS_MN10200 = 57005;
        public static final int EM_CYGNUS_MN10300 = 48879;
        public static final int EM_CYGNUS_FR30 = 13104;
        public static final int EM_XSTORMY16 = 44357;
        public static final int EM_CYGNUS_FRV = 21569;
        public static final int EM_IQ2000 = 65210;
        public static final int EM_XILINX_MICROBLAZE = 47787;
        public static final int EM_SDMA = 51966;
        public static final int EM_CRADLE = 19797;
        public byte[] e_ident = new byte[16];
        public int e_type;
        public int e_machine;
        public long e_version;
        public IAddress e_entry;
        public long e_phoff;
        public long e_shoff;
        public long e_flags;
        public short e_ehsize;
        public short e_phentsize;
        public short e_phnum;
        public short e_shentsize;
        public short e_shnum;
        public short e_shstrndx;

        protected ELFhdr() throws IOException {
            Elf.this.efile.seek(0L);
            Elf.this.efile.readFully(this.e_ident);
            if (this.e_ident[0] != 127 || this.e_ident[1] != 69 || this.e_ident[2] != 76 || this.e_ident[3] != 70) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notELF"));
            }
            Elf.this.efile.setEndian(this.e_ident[5] == 1);
            this.e_type = Elf.this.efile.readShortE();
            this.e_machine = Elf.this.efile.readShortE();
            this.e_version = Elf.this.efile.readIntE();
            switch (this.e_ident[4]) {
                case 1: {
                    byte[] addrArray = new byte[4];
                    Elf.this.efile.readFullyE(addrArray);
                    this.e_entry = new Addr32(addrArray);
                    this.e_phoff = Elf.this.efile.readIntE();
                    this.e_shoff = Elf.this.efile.readIntE();
                    break;
                }
                case 2: {
                    byte[] addrArray = new byte[8];
                    Elf.this.efile.readFullyE(addrArray);
                    this.e_entry = new Addr64(addrArray);
                    this.e_phoff = Elf.this.readUnsignedLong(Elf.this.efile);
                    this.e_shoff = Elf.this.readUnsignedLong(Elf.this.efile);
                    break;
                }
                default: {
                    throw new IOException("Unknown ELF class " + this.e_ident[4]);
                }
            }
            this.e_flags = Elf.this.efile.readIntE();
            this.e_ehsize = Elf.this.efile.readShortE();
            this.e_phentsize = Elf.this.efile.readShortE();
            this.e_phnum = Elf.this.efile.readShortE();
            this.e_shentsize = Elf.this.efile.readShortE();
            this.e_shnum = Elf.this.efile.readShortE();
            this.e_shstrndx = Elf.this.efile.readShortE();
        }

        protected ELFhdr(byte[] bytes) throws IOException {
            if (bytes.length <= this.e_ident.length) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.notELF"));
            }
            System.arraycopy(bytes, 0, this.e_ident, 0, this.e_ident.length);
            if (this.e_ident[0] != 127 || this.e_ident[1] != 69 || this.e_ident[2] != 76 || this.e_ident[3] != 70) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notELF"));
            }
            boolean isle = this.e_ident[5] == 1;
            int offset = this.e_ident.length;
            this.e_type = this.makeShort(bytes, offset, isle);
            this.e_machine = this.makeShort(bytes, offset += 2, isle);
            this.e_version = this.makeInt(bytes, offset += 2, isle);
            offset += 4;
            switch (this.e_ident[4]) {
                case 1: {
                    byte[] addrArray = new byte[4];
                    System.arraycopy(bytes, offset, addrArray, 0, 4);
                    this.e_entry = new Addr32(addrArray);
                    this.e_phoff = this.makeInt(bytes, offset += 4, isle);
                    this.e_shoff = this.makeInt(bytes, offset += 4, isle);
                    offset += 4;
                    break;
                }
                case 2: {
                    byte[] addrArray = new byte[8];
                    System.arraycopy(bytes, offset, addrArray, 0, 8);
                    this.e_entry = new Addr64(addrArray);
                    this.e_phoff = this.makeUnsignedLong(bytes, offset += 8, isle);
                    this.e_shoff = this.makeUnsignedLong(bytes, offset += 8, isle);
                    offset += 8;
                    break;
                }
                default: {
                    throw new IOException("Unknown ELF class " + this.e_ident[4]);
                }
            }
            this.e_flags = this.makeInt(bytes, offset, isle);
            this.e_ehsize = this.makeShort(bytes, offset += 4, isle);
            this.e_phentsize = this.makeShort(bytes, offset += 2, isle);
            this.e_phnum = this.makeShort(bytes, offset += 2, isle);
            this.e_shentsize = this.makeShort(bytes, offset += 2, isle);
            this.e_shnum = this.makeShort(bytes, offset += 2, isle);
            this.e_shstrndx = this.makeShort(bytes, offset += 2, isle);
            offset += 2;
        }

        private final short makeShort(byte[] val, int offset, boolean isle) throws IOException {
            if (val.length < offset + 2) {
                throw new IOException();
            }
            if (isle) {
                return (short)((val[offset + 1] << 8) + val[offset + 0]);
            }
            return (short)((val[offset + 0] << 8) + val[offset + 1]);
        }

        private final long makeInt(byte[] val, int offset, boolean isle) throws IOException {
            if (val.length < offset + 4) {
                throw new IOException();
            }
            if (isle) {
                return (val[offset + 3] << 24) + (val[offset + 2] << 16) + (val[offset + 1] << 8) + val[offset + 0];
            }
            return (val[offset + 0] << 24) + (val[offset + 1] << 16) + (val[offset + 2] << 8) + val[offset + 3];
        }

        private final long makeLong(byte[] val, int offset, boolean isle) throws IOException {
            long result = 0L;
            int shift = 0;
            if (isle) {
                int i = 7;
                while (i >= 0) {
                    shift = i * 8;
                    result += (long)val[offset + i] << shift & 255L << shift;
                    --i;
                }
            } else {
                int i = 0;
                while (i <= 7) {
                    shift = (7 - i) * 8;
                    result += (long)val[offset + i] << shift & 255L << shift;
                    ++i;
                }
            }
            return result;
        }

        private final long makeUnsignedLong(byte[] val, int offset, boolean isle) throws IOException {
            long result = this.makeLong(val, offset, isle);
            if (result < 0L) {
                throw new IOException("Maximal file offset is " + Long.toHexString(Long.MAX_VALUE) + " given offset is " + Long.toHexString(result));
            }
            return result;
        }
    }

    public class PHdr {
        public static final int PT_NULL = 0;
        public static final int PT_LOAD = 1;
        public static final int PT_DYNAMIC = 2;
        public static final int PT_INTERP = 3;
        public static final int PT_NOTE = 4;
        public static final int PT_SHLIB = 5;
        public static final int PT_PHDR = 6;
        public static final int PF_X = 1;
        public static final int PF_W = 2;
        public static final int PF_R = 4;
        public long p_type;
        public long p_offset;
        public IAddress p_vaddr;
        public IAddress p_paddr;
        public long p_filesz;
        public long p_memsz;
        public long p_flags;
        public long p_align;
    }

    public class Section {
        public static final int SHT_NULL = 0;
        public static final int SHT_PROGBITS = 1;
        public static final int SHT_SYMTAB = 2;
        public static final int SHT_STRTAB = 3;
        public static final int SHT_RELA = 4;
        public static final int SHT_HASH = 5;
        public static final int SHT_DYNAMIC = 6;
        public static final int SHT_NOTE = 7;
        public static final int SHT_NOBITS = 8;
        public static final int SHT_REL = 9;
        public static final int SHT_SHLIB = 10;
        public static final int SHT_DYNSYM = 11;
        public static final int SHT_LOPROC = 0x70000000;
        public static final int SHF_WRITE = 1;
        public static final int SHF_ALLOC = 2;
        public static final int SHF_EXECINTR = 4;
        public long sh_name;
        public long sh_type;
        public long sh_flags;
        public IAddress sh_addr;
        public long sh_offset;
        public long sh_size;
        public long sh_link;
        public long sh_info;
        public long sh_addralign;
        public long sh_entsize;

        public ByteBuffer mapSectionData() throws IOException {
            Elf.this.sections_mapped = true;
            return Elf.this.efile.getChannel().map(FileChannel.MapMode.READ_ONLY, this.sh_offset, this.sh_size).load().asReadOnlyBuffer();
        }

        public byte[] loadSectionData() throws IOException {
            byte[] data = new byte[(int)this.sh_size];
            Elf.this.efile.seek(this.sh_offset);
            Elf.this.efile.read(data);
            return data;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            try {
                if (Elf.this.section_strtab == null) {
                    int shstrndx = Elf.this.ehdr.e_shstrndx & 0xFFFF;
                    if (shstrndx > Elf.this.sections.length || shstrndx < 0) {
                        return Elf.this.EMPTY_STRING;
                    }
                    int size = (int)Elf.this.sections[shstrndx].sh_size;
                    if (size <= 0 || (long)size > Elf.this.efile.length()) {
                        return Elf.this.EMPTY_STRING;
                    }
                    Elf.this.section_strtab = new byte[size];
                    Elf.this.efile.seek(Elf.this.sections[shstrndx].sh_offset);
                    Elf.this.efile.read(Elf.this.section_strtab);
                }
                int str_size = 0;
                if (this.sh_name > (long)Elf.this.section_strtab.length) {
                    return Elf.this.EMPTY_STRING;
                }
                while (true) {
                    if (Elf.this.section_strtab[(int)this.sh_name + str_size] == 0) {
                        return new String(Elf.this.section_strtab, (int)this.sh_name, str_size);
                    }
                    ++str_size;
                }
            }
            catch (IOException iOException) {
                return Elf.this.EMPTY_STRING;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Symbol
    implements Comparable<Object> {
        public static final int STB_LOCAL = 0;
        public static final int STB_GLOBAL = 1;
        public static final int STB_WEAK = 2;
        public static final int STT_NOTYPE = 0;
        public static final int STT_OBJECT = 1;
        public static final int STT_FUNC = 2;
        public static final int STT_SECTION = 3;
        public static final int STT_FILE = 4;
        public static final int SHN_UNDEF = 0;
        public static final int SHN_LORESERVE = -256;
        public static final int SHN_LOPROC = -256;
        public static final int SHN_HIPROC = -225;
        public static final int SHN_LOOS = -224;
        public static final int SHN_HIOS = -193;
        public static final int SHN_ABS = -15;
        public static final int SHN_COMMON = -14;
        public static final int SHN_XINDEX = -1;
        public static final int SHN_HIRESERVE = -1;
        public long st_name;
        public IAddress st_value;
        public long st_size;
        public short st_info;
        public short st_other;
        public short st_shndx;
        private String name = null;
        private final Section sym_section;

        public Symbol(Section section) {
            this.sym_section = section;
        }

        public int st_type() {
            return this.st_info & 0xF;
        }

        public int st_bind() {
            return this.st_info >> 4 & 0xF;
        }

        @Override
        public int compareTo(Object obj) {
            return this.st_value.compareTo(((Symbol)obj).st_value);
        }

        public String toString() {
            if (this.name == null) {
                try {
                    Section[] sections = Elf.this.getSections();
                    Section symstr = sections[(int)this.sym_section.sh_link];
                    this.name = Elf.this.string_from_elf_section(symstr, (int)this.st_name);
                }
                catch (IOException iOException) {
                    return Elf.this.EMPTY_STRING;
                }
            }
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SymbolComparator
    implements Comparator<Object> {
        IAddress val1;
        IAddress val2;

        SymbolComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof IAddress) {
                this.val1 = (IAddress)o1;
            } else if (o1 instanceof Symbol) {
                this.val1 = ((Symbol)o1).st_value;
            } else {
                return -1;
            }
            if (o2 instanceof IAddress) {
                this.val2 = (IAddress)o2;
            } else if (o2 instanceof Symbol) {
                this.val2 = ((Symbol)o2).st_value;
            } else {
                return -1;
            }
            return this.val1.compareTo(this.val2);
        }
    }
}

