/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CSettingEntryFactory;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionPreferences;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class CProjectDescription
implements ICProjectDescription,
ICDataProxyContainer {
    private static final String ACTIVE_CFG = "activeConfiguration";
    private static final QualifiedName ACTIVE_CFG_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "activeConfiguration");
    private static final String SETTING_CFG = "settingConfiguration";
    private static final QualifiedName SETTING_CFG_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "settingConfiguration");
    private CfgIdPair fActiveCfgInfo;
    private CfgIdPair fSettingCfgInfo;
    private CProjectDescriptionPreferences fPrefs;
    private volatile IProject fProject;
    private final ICSettingsStorage fStorage;
    private final ICStorageElement fRootStorageElement;
    private final HashMap<String, ICConfigurationDescription> fCfgMap = new LinkedHashMap<String, ICConfigurationDescription>();
    private boolean fIsReadOnly;
    private boolean fIsModified;
    private HashMap<QualifiedName, Object> fPropertiesMap;
    private boolean fIsLoading;
    private boolean fIsApplying;
    private boolean fIsCreating;

    public CProjectDescription(IProject project, ICSettingsStorage storage, ICStorageElement element, boolean loading, boolean isCreating) throws CoreException {
        this.fProject = project;
        this.fStorage = storage;
        this.fRootStorageElement = element;
        this.fIsReadOnly = loading;
        this.fIsLoading = loading;
        this.fActiveCfgInfo = new CfgIdPair(ACTIVE_CFG_PROPERTY);
        this.fSettingCfgInfo = new CfgIdPair(SETTING_CFG_PROPERTY);
        this.fIsCreating = isCreating;
        ICStorageElement el = null;
        CProjectDescriptionManager mngr = CProjectDescriptionManager.getInstance();
        if (loading) {
            Map<String, ICStorageElement> cfgStorMap = mngr.createCfgStorages(this);
            for (ICStorageElement sel : cfgStorMap.values()) {
                CConfigurationDescriptionCache cache = new CConfigurationDescriptionCache(sel, this);
                this.configurationCreated(cache);
            }
            el = this.getStorage("org.eclipse.cdt.core.settings", false);
        }
        this.fPrefs = new CProjectDescriptionPreferences(el, (CProjectDescriptionPreferences)((Object)mngr.getProjectDescriptionWorkspacePreferences(false)), false);
        this.fPropertiesMap = new HashMap();
    }

    public void updateProject(IProject project) {
        this.fProject = project;
    }

    public void loadDatas() {
        if (!this.fIsReadOnly || !this.fIsLoading) {
            return;
        }
        CSettingEntryFactory factory = new CSettingEntryFactory();
        Iterator<ICConfigurationDescription> iter = this.fCfgMap.values().iterator();
        while (iter.hasNext()) {
            CConfigurationDescriptionCache cache = (CConfigurationDescriptionCache)iter.next();
            try {
                cache.loadData(factory);
                factory.clear();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                iter.remove();
            }
        }
    }

    public boolean applyDatas(SettingsContext context) {
        if (!this.fIsReadOnly || !this.fIsApplying) {
            return false;
        }
        CSettingEntryFactory factory = new CSettingEntryFactory();
        boolean modified = false;
        Iterator<ICConfigurationDescription> iter = this.fCfgMap.values().iterator();
        while (iter.hasNext()) {
            CConfigurationDescriptionCache cache = (CConfigurationDescriptionCache)iter.next();
            try {
                if (cache.applyData(factory, context)) {
                    modified = true;
                }
                factory.clear();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                e.printStackTrace();
                iter.remove();
            }
        }
        return modified;
    }

    public void doneApplying() {
        this.doneInitializing();
        this.fIsApplying = false;
        try {
            this.getStorageBase().setReadOnly(true, false);
        }
        catch (CoreException e1) {
            CCorePlugin.log(e1);
        }
        this.setModified(false);
    }

    public void doneLoading() {
        this.doneInitializing();
        this.fIsLoading = false;
    }

    public void setLoading(boolean loading) {
        this.fIsLoading = loading;
    }

    private void doneInitializing() {
        for (ICConfigurationDescription cfg : this.fCfgMap.values()) {
            CConfigurationDescriptionCache cache = (CConfigurationDescriptionCache)cfg;
            cache.doneInitialization();
        }
        if (this.fIsReadOnly) {
            this.fPrefs.setReadOnly(true);
        }
    }

    public boolean isLoading() {
        return this.fIsLoading;
    }

    public boolean isApplying() {
        return this.fIsApplying;
    }

    public CProjectDescription(CProjectDescription base, boolean saving, ICSettingsStorage storage, ICStorageElement el, boolean isCreating) {
        this.fActiveCfgInfo = new CfgIdPair(base.fActiveCfgInfo);
        this.fSettingCfgInfo = new CfgIdPair(base.fSettingCfgInfo);
        this.fProject = base.fProject;
        this.fStorage = storage;
        this.fRootStorageElement = el;
        this.fIsReadOnly = saving;
        this.fIsLoading = base.fIsLoading;
        this.fIsApplying = saving || base.fIsApplying;
        this.fIsCreating = isCreating;
        this.fPrefs = new CProjectDescriptionPreferences(base.fPrefs, (CProjectDescriptionPreferences)((Object)CProjectDescriptionManager.getInstance().getProjectDescriptionWorkspacePreferences(false)), false);
        Iterator<ICConfigurationDescription> iter = base.fCfgMap.values().iterator();
        while (iter.hasNext()) {
            try {
                CConfigurationData baseData;
                IInternalCCfgInfo cfgDes = (IInternalCCfgInfo)((Object)iter.next());
                if (this.fIsReadOnly) {
                    baseData = cfgDes.getConfigurationData(false);
                    CConfigurationDescriptionCache baseCache = null;
                    if (baseData instanceof CConfigurationDescriptionCache) {
                        baseCache = (CConfigurationDescriptionCache)baseData;
                        baseData = baseCache.getConfigurationData();
                    }
                    CConfigurationDescriptionCache cache = new CConfigurationDescriptionCache((ICConfigurationDescription)((Object)cfgDes), baseData, baseCache, cfgDes.getSpecSettings(), this, null);
                    this.configurationCreated(cache);
                    continue;
                }
                baseData = cfgDes.getConfigurationData(false);
                CConfigurationDescription cfg = new CConfigurationDescription(baseData, this);
                this.configurationCreated(cfg);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        this.fPropertiesMap = (HashMap)base.fPropertiesMap.clone();
    }

    void switchToCachedConfigurationDescriptions() throws CoreException {
        for (Map.Entry<String, ICConfigurationDescription> e : this.fCfgMap.entrySet()) {
            if (!(e.getValue() instanceof CConfigurationDescription)) continue;
            CConfigurationDescription cfgDes = (CConfigurationDescription)e.getValue();
            CConfigurationData baseData = cfgDes.getConfigurationData(false);
            CConfigurationDescriptionCache baseCache = null;
            if (baseData instanceof CConfigurationDescriptionCache) {
                baseCache = (CConfigurationDescriptionCache)baseData;
                baseData = baseCache.getConfigurationData();
            }
            CConfigurationDescriptionCache cache = new CConfigurationDescriptionCache(cfgDes, baseData, baseCache, cfgDes.getSpecSettings(), this, null);
            e.setValue(cache);
        }
    }

    void configurationCreated(ICConfigurationDescription des) {
        this.fCfgMap.put(des.getId(), des);
    }

    public ICConfigurationDescription createConfiguration(String id, String name, ICConfigurationDescription base) throws CoreException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        CConfigurationDescription cfg = new CConfigurationDescription(id, name, base, this);
        this.configurationCreated(cfg);
        return cfg;
    }

    public ICConfigurationDescription getActiveConfiguration() {
        return this.fActiveCfgInfo.getConfiguration();
    }

    private String getFirstCfgId() {
        if (!this.fCfgMap.isEmpty()) {
            return this.fCfgMap.keySet().iterator().next();
        }
        return null;
    }

    public ICConfigurationDescription getConfigurationById(String id) {
        return this.fCfgMap.get(id);
    }

    public ICConfigurationDescription getConfigurationByName(String name) {
        for (ICConfigurationDescription cfg : this.fCfgMap.values()) {
            if (!name.equals(cfg.getName())) continue;
            return cfg;
        }
        return null;
    }

    public ICConfigurationDescription[] getConfigurations() {
        return this.fCfgMap.values().toArray(new ICConfigurationDescription[this.fCfgMap.size()]);
    }

    public void removeConfiguration(String name) throws WriteAccessException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        CConfigurationDescription cfgDes = (CConfigurationDescription)this.getConfigurationByName(name);
        if (cfgDes != null) {
            cfgDes.removeConfiguration();
        }
    }

    void configurationRemoved(CConfigurationDescription des) {
        this.fCfgMap.remove(des.getId());
        this.fIsModified = true;
        this.fActiveCfgInfo.configurationRemoved(des);
        this.fSettingCfgInfo.configurationRemoved(des);
    }

    public void removeConfiguration(ICConfigurationDescription cfg) throws WriteAccessException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        ((CConfigurationDescription)cfg).removeConfiguration();
    }

    public void setActiveConfiguration(ICConfigurationDescription cfg) throws WriteAccessException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (cfg == null) {
            throw new NullPointerException();
        }
        this.fActiveCfgInfo.setConfiguration(cfg);
        if (this.getConfigurationRelations() == 2) {
            this.fSettingCfgInfo.setConfiguration(cfg);
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public ICStorageElement getStorage(String moduleId, boolean create) throws CoreException {
        return this.getStorageBase().getStorage(moduleId, create);
    }

    public ICStorageElement importStorage(String id, ICStorageElement el) throws UnsupportedOperationException, CoreException {
        return this.getStorageBase().importStorage(id, el);
    }

    public ICSettingObject[] getChildSettings() {
        return this.getConfigurations();
    }

    public ICConfigurationDescription getConfiguration() {
        return null;
    }

    public String getId() {
        return null;
    }

    public final int getType() {
        return 1;
    }

    public String getName() {
        return this.fProject.getName();
    }

    public ICSettingContainer getParent() {
        return null;
    }

    public boolean isValid() {
        return this.fCfgMap.size() > 0;
    }

    public void updateChild(CDataProxy child, boolean write) {
        if (write) {
            try {
                String oldId = child.getId();
                CConfigurationDescription cfgDes = (CConfigurationDescription)child;
                cfgDes.doWritable();
                this.updateMap(cfgDes, oldId);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
    }

    void updateMap(CConfigurationDescription des, String oldId) {
        if (!oldId.equals(des.getId())) {
            this.fCfgMap.remove(oldId);
            this.fCfgMap.put(des.getId(), des);
        }
    }

    public ICStorageElement getRootStorageElement() throws CoreException {
        if (this.fRootStorageElement == null) {
            throw ExceptionFactory.createCoreException("CProjectDescription ICStorageElement == null");
        }
        return this.fRootStorageElement;
    }

    ICSettingsStorage getStorageBase() throws CoreException {
        if (this.fStorage == null) {
            throw ExceptionFactory.createCoreException("CProjectDescription ICSettingsStorage == null");
        }
        return this.fStorage;
    }

    public ICConfigurationDescription createConfiguration(String buildSystemId, CConfigurationData data) throws CoreException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        CConfigurationDescription cfg = new CConfigurationDescription(data, buildSystemId, this);
        this.configurationCreated(cfg);
        return cfg;
    }

    public CConfigurationDescription createConvertedConfiguration(String id, String name, ICStorageElement el) throws CoreException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        CConfigurationDescription cfg = new CConfigurationDescription(id, name, el, this);
        this.configurationCreated(cfg);
        return cfg;
    }

    public boolean isModified() {
        if (this.fIsModified) {
            return true;
        }
        if (this.fActiveCfgInfo.fIsModified) {
            return true;
        }
        if (this.fSettingCfgInfo.fIsModified) {
            return true;
        }
        if (this.fPrefs.isModified()) {
            return true;
        }
        if (this.fStorage.isModified()) {
            return true;
        }
        for (ICConfigurationDescription cfgDes : this.fCfgMap.values()) {
            if (!cfgDes.isModified()) continue;
            return true;
        }
        return false;
    }

    private void setModified(boolean modified) {
        this.fIsModified = modified;
        if (!modified) {
            this.fActiveCfgInfo.fIsModified = false;
            this.fSettingCfgInfo.fIsModified = false;
            this.fPrefs.setModified(false);
        }
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly && !this.fIsLoading && !this.fIsApplying;
    }

    public void setReadOnly(boolean readOnly, boolean keepModify) {
        this.fIsReadOnly = readOnly;
        try {
            this.getStorageBase().setReadOnly(readOnly, keepModify);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public ICSettingObject getChildSettingById(String id) {
        return this.getConfigurationById(id);
    }

    public ICConfigurationDescription getDefaultSettingConfiguration() {
        if (this.getConfigurationRelations() == 2) {
            return this.getActiveConfiguration();
        }
        return this.fSettingCfgInfo.getConfiguration();
    }

    public void setDefaultSettingConfiguration(ICConfigurationDescription cfg) throws WriteAccessException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (cfg == null) {
            throw new NullPointerException();
        }
        this.fSettingCfgInfo.setConfiguration(cfg);
        if (this.getConfigurationRelations() == 2) {
            this.fActiveCfgInfo.setConfiguration(cfg);
        }
    }

    public Object getSessionProperty(QualifiedName name) {
        return this.fPropertiesMap.get(name);
    }

    public void setSessionProperty(QualifiedName name, Object value) {
        if (value != null) {
            this.fPropertiesMap.put(name, value);
        } else {
            this.fPropertiesMap.remove(name);
        }
        this.fIsModified = true;
    }

    public void removeStorage(String id) throws CoreException {
        this.getStorageBase().removeStorage(id);
    }

    void switchToCachedAppliedData(CProjectDescription appliedCache) {
        if (this.fIsReadOnly) {
            return;
        }
        ICConfigurationDescription[] cfgs = appliedCache.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            CConfigurationDescriptionCache cfgCache = (CConfigurationDescriptionCache)cfgs[i];
            CConfigurationDescription des = (CConfigurationDescription)this.getChildSettingById(cfgCache.getId());
            if (des != null) {
                des.setData(cfgCache);
            }
            ++i;
        }
    }

    boolean checkPersistActiveCfg(String oldId, boolean force) {
        return this.fActiveCfgInfo.store(oldId, force);
    }

    boolean checkPersistSettingCfg(String oldId, boolean force) {
        return this.fSettingCfgInfo.store(oldId, force);
    }

    boolean needsActiveCfgPersistence() {
        return this.fActiveCfgInfo.fIsModified;
    }

    boolean needsSettingCfgPersistence() {
        return this.fSettingCfgInfo.fIsModified;
    }

    CProjectDescriptionPreferences getPreferences() {
        return this.fPrefs;
    }

    public int getConfigurationRelations() {
        return this.fPrefs.getConfigurationRelations();
    }

    public boolean isDefaultConfigurationRelations() {
        return this.fPrefs.isDefaultConfigurationRelations();
    }

    public void setConfigurationRelations(int status) {
        this.fPrefs.setConfigurationRelations(status);
    }

    public void useDefaultConfigurationRelations() {
        this.fPrefs.useDefaultConfigurationRelations();
    }

    public boolean isCdtProjectCreating() {
        return this.fIsCreating;
    }

    public void setCdtProjectCreated() {
        if (!this.fIsCreating) {
            return;
        }
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsCreating = false;
        this.fIsModified = true;
    }

    public void touch() throws WriteAccessException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsModified = true;
    }

    private class CfgIdPair {
        private String fId;
        private ICConfigurationDescription fCfg;
        private QualifiedName fPersistanceName;
        private boolean fNeedsPersistance;
        private boolean fIsModified;

        CfgIdPair(CfgIdPair base) {
            this.fId = base.fId;
            this.fPersistanceName = base.fPersistanceName;
        }

        CfgIdPair(QualifiedName persistanceName) {
            this.fPersistanceName = persistanceName;
        }

        public String getId() {
            if (this.fId == null) {
                this.fId = this.load();
                if (this.fId == null) {
                    this.fId = CProjectDescription.this.getFirstCfgId();
                    if (this.fId != null) {
                        this.fNeedsPersistance = true;
                    }
                }
            }
            return this.fId;
        }

        public ICConfigurationDescription getConfiguration() {
            String id;
            if (this.fCfg == null && (id = this.getId()) != null) {
                this.fCfg = CProjectDescription.this.getConfigurationById(id);
                if (this.fCfg == null) {
                    this.fId = CProjectDescription.this.getFirstCfgId();
                    if (this.fId != null) {
                        this.fCfg = CProjectDescription.this.getConfigurationById(this.fId);
                        this.fNeedsPersistance = true;
                    }
                }
            }
            return this.fCfg;
        }

        public void setConfiguration(ICConfigurationDescription cfg) {
            if (cfg.getProjectDescription() != CProjectDescription.this) {
                throw new IllegalArgumentException();
            }
            if (cfg.getId().equals(this.getId())) {
                return;
            }
            this.fCfg = cfg;
            this.fId = cfg.getId();
            this.fIsModified = true;
            this.fNeedsPersistance = true;
        }

        public void configurationRemoved(ICConfigurationDescription cfg) {
            if (cfg.getProjectDescription() != CProjectDescription.this) {
                throw new IllegalArgumentException();
            }
            if (!cfg.getId().equals(this.getId())) {
                return;
            }
            this.fIsModified = true;
            this.fCfg = null;
            this.getConfiguration();
        }

        private String load() {
            try {
                return CProjectDescription.this.getProject().getPersistentProperty(this.fPersistanceName);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return null;
            }
        }

        private boolean store(String oldId, boolean force) {
            if (force || this.fIsModified || this.fNeedsPersistance || oldId == null || !oldId.equals(this.fId)) {
                try {
                    CProjectDescription.this.getProject().setPersistentProperty(this.fPersistanceName, this.fId);
                    this.fIsModified = false;
                    this.fNeedsPersistance = false;
                    return true;
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            return false;
        }
    }
}

