/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryContentsKey;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettinsDeltaCalculator;
import org.eclipse.core.runtime.CoreException;

public class CExternalSettingsDeltaProcessor {
    static boolean applyDelta(ICConfigurationDescription des, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas) {
        return CExternalSettingsDeltaProcessor.applyDelta(des, deltas, 255);
    }

    static boolean applyDelta(ICConfigurationDescription des, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas, int kindMask) {
        ICResourceDescription[] rcDess = des.getResourceDescriptions();
        boolean changed = false;
        int i = 0;
        while (i < rcDess.length) {
            ICResourceDescription rcDes = rcDess[i];
            if (CExternalSettingsDeltaProcessor.applyDelta(rcDes, deltas, kindMask)) {
                changed = true;
            }
            ++i;
        }
        if ((kindMask & 0x80) != 0 && CExternalSettingsDeltaProcessor.applySourceEntriesChange(des, deltas)) {
            changed = true;
        }
        if ((kindMask & 0x40) != 0 && CExternalSettingsDeltaProcessor.applyOutputEntriesChange(des, deltas)) {
            changed = true;
        }
        return changed;
    }

    static boolean applySourceEntriesChange(ICConfigurationDescription cfgDes, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas) {
        List newEntries;
        ICSourceEntry cur;
        ICSettingEntry[][] diff = CExternalSettinsDeltaCalculator.getAllEntries(deltas, 128);
        if (diff == null) {
            return false;
        }
        ICSettingEntry[] current = cfgDes.getSourceEntries();
        if (current.length == 1 && (cur = current[0]).getFullPath().segmentCount() == 1 && cur.getExclusionPatterns().length == 0) {
            current = new ICSourceEntry[]{};
        }
        if ((newEntries = CExternalSettingsDeltaProcessor.calculateUpdatedEntries(current, diff[0], diff[1])) != null) {
            try {
                cfgDes.setSourceEntries(newEntries.toArray(new ICSourceEntry[newEntries.size()]));
            }
            catch (WriteAccessException e) {
                CCorePlugin.log(e);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            return true;
        }
        return false;
    }

    static boolean applyOutputEntriesChange(ICConfigurationDescription cfgDes, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas) {
        List newEntries;
        ICOutputEntry cur;
        ICSettingEntry[][] diff = CExternalSettinsDeltaCalculator.getAllEntries(deltas, 64);
        if (diff == null) {
            return false;
        }
        ICBuildSetting bs = cfgDes.getBuildSetting();
        if (bs == null) {
            return false;
        }
        ICSettingEntry[] current = bs.getOutputDirectories();
        if (current.length == 1 && (cur = current[0]).getFullPath().segmentCount() == 1 && cur.getExclusionPatterns().length == 0) {
            current = new ICOutputEntry[]{};
        }
        if ((newEntries = CExternalSettingsDeltaProcessor.calculateUpdatedEntries(current, diff[0], diff[1])) != null) {
            try {
                bs.setOutputDirectories(newEntries.toArray(new ICOutputEntry[newEntries.size()]));
            }
            catch (WriteAccessException e) {
                CCorePlugin.log(e);
            }
            return true;
        }
        return false;
    }

    static boolean applyDelta(ICResourceDescription rcDes, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas, int kindMask) {
        if (rcDes.getType() == 4) {
            return CExternalSettingsDeltaProcessor.applyDelta((ICFolderDescription)rcDes, deltas, kindMask);
        }
        return CExternalSettingsDeltaProcessor.applyDelta((ICFileDescription)rcDes, deltas, kindMask);
    }

    static boolean applyDelta(ICFileDescription des, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas, int kindMask) {
        ICLanguageSetting setting = des.getLanguageSetting();
        if (setting == null) {
            return false;
        }
        boolean changed = false;
        int i = 0;
        while (i < deltas.length) {
            if (CExternalSettingsDeltaProcessor.isSettingCompatible(setting, deltas[i].fSetting) && CExternalSettingsDeltaProcessor.applyDelta(setting, deltas[i], kindMask)) {
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    static boolean applyDelta(ICFolderDescription des, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas, int kindMask) {
        ICLanguageSetting[] settings = des.getLanguageSettings();
        if (settings == null || settings.length == 0) {
            return false;
        }
        boolean changed = false;
        int k = 0;
        while (k < settings.length) {
            ICLanguageSetting setting = settings[k];
            if (CExternalSettingsDeltaProcessor.applyDelta(setting, deltas, kindMask)) {
                changed = true;
            }
            ++k;
        }
        return changed;
    }

    static boolean applyDelta(ICLanguageSetting setting, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas, int kindMask) {
        boolean changed = false;
        int i = 0;
        while (i < deltas.length) {
            if (CExternalSettingsDeltaProcessor.isSettingCompatible(setting, deltas[i].fSetting) && CExternalSettingsDeltaProcessor.applyDelta(setting, deltas[i], kindMask)) {
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    static boolean applyDelta(ICLanguageSetting setting, CExternalSettinsDeltaCalculator.ExtSettingsDelta delta, int kindMask) {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        boolean changed = false;
        int i = 0;
        while (i < kinds.length) {
            ICSettingEntry[] entries;
            List list;
            ICSettingEntry[][] diff;
            int kind = kinds[i];
            if ((kind & kindMask) != 0 && (diff = delta.getEntriesDelta(kind)) != null && (list = CExternalSettingsDeltaProcessor.calculateUpdatedEntries(entries = setting.getSettingEntries(kind), diff[0], diff[1])) != null) {
                setting.setSettingEntries(kind, list);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    private static List calculateUpdatedEntries(ICSettingEntry[] current, ICSettingEntry[] added, ICSettingEntry[] removed) {
        LinkedHashMap map = new LinkedHashMap();
        boolean changed = false;
        if (added != null) {
            CDataUtil.fillEntriesMapByContentsKey(map, added);
        }
        if (current != null) {
            CDataUtil.fillEntriesMapByContentsKey(map, current);
            if (current.length != map.size()) {
                changed = true;
            }
        } else if (map.size() != 0) {
            changed = true;
        }
        if (removed != null) {
            int i = 0;
            while (i < removed.length) {
                ICSettingEntry entry = removed[i];
                EntryContentsKey cKey = new EntryContentsKey(entry);
                ICSettingEntry cur = (ICSettingEntry)map.get(cKey);
                if (cur != null && !cur.isBuiltIn()) {
                    map.remove(cKey);
                    changed = true;
                }
                ++i;
            }
        }
        return changed ? new ArrayList(map.values()) : null;
    }

    private static boolean isSettingCompatible(ICLanguageSetting setting, CExternalSetting provider) {
        Object[] ids = provider.getCompatibleLanguageIds();
        if (ids != null && ids.length > 0) {
            String id = setting.getLanguageId();
            if (id != null) {
                return CExternalSettingsDeltaProcessor.contains(ids, id);
            }
            return false;
        }
        ids = provider.getCompatibleContentTypeIds();
        if (ids != null && ids.length > 0) {
            String[] cTypeIds = setting.getSourceContentTypeIds();
            if (cTypeIds.length != 0) {
                int i = 0;
                while (i < cTypeIds.length) {
                    String id = cTypeIds[i];
                    if (CExternalSettingsDeltaProcessor.contains(ids, id)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return false;
        }
        ids = provider.getCompatibleExtensions();
        if (ids != null && ids.length > 0) {
            String[] srcIds = setting.getSourceExtensions();
            if (srcIds.length != 0) {
                int i = 0;
                while (i < srcIds.length) {
                    String id = srcIds[i];
                    if (CExternalSettingsDeltaProcessor.contains(ids, id)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean contains(Object[] array, Object value) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

