/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownScope;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTemplateTypeParameter
extends PDOMCPPBinding
implements IPDOMMemberOwner,
ICPPTemplateTypeParameter,
ICPPUnknownBinding,
ICPPUnknownType,
IIndexType,
IPDOMCPPTemplateParameter {
    private static final int DEFAULT_TYPE = 28;
    private static final int MEMBERLIST = 32;
    private static final int PARAMETERID = 36;
    protected static final int RECORD_SIZE = 40;
    private ICPPScope fUnknownScope;
    private int fCachedParamID = -1;

    public PDOMCPPTemplateTypeParameter(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateTypeParameter param) throws CoreException {
        super(linkage, parent, param.getNameCharArray());
        Database db = this.getDB();
        db.putInt(this.record + 36L, param.getParameterID());
    }

    public PDOMCPPTemplateTypeParameter(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 40;
    }

    public int getNodeType() {
        return 43;
    }

    public short getParameterPosition() {
        this.readParamID();
        return (short)this.fCachedParamID;
    }

    public short getTemplateNestingLevel() {
        this.readParamID();
        return (short)(this.fCachedParamID >> 16);
    }

    public int getParameterID() {
        this.readParamID();
        return this.fCachedParamID;
    }

    private void readParamID() {
        if (this.fCachedParamID == -1) {
            try {
                Database db = this.getDB();
                this.fCachedParamID = db.getInt(this.record + 36L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fCachedParamID = -2;
            }
        }
    }

    public void addChild(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L);
        list.addMember(member);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L);
        list.accept(visitor);
    }

    public boolean isSameType(IType type) {
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPTemplateTypeParameter)) {
            return false;
        }
        return this.getParameterID() == ((ICPPTemplateParameter)((Object)type)).getParameterID();
    }

    public IType getDefault() {
        try {
            PDOMNode node = ((PDOMLinkage)this.getLinkage()).getNode(this.getDB().getRecPtr(this.record + 28L));
            if (node instanceof IType) {
                return (IType)((Object)node);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public ICPPTemplateArgument getDefaultValue() {
        IType d = this.getDefault();
        if (d == null) {
            return null;
        }
        return new CPPTemplateArgument(d);
    }

    public Object clone() {
        this.fail();
        return null;
    }

    public ICPPScope asScope() {
        if (this.fUnknownScope == null) {
            this.fUnknownScope = new PDOMCPPUnknownScope(this, (IASTName)new CPPASTName(this.getNameCharArray()));
        }
        return this.fUnknownScope;
    }

    public IASTName getUnknownName() {
        return new CPPASTName(this.getNameCharArray());
    }

    public void configure(ICPPTemplateParameter param) {
        try {
            IType dflt;
            ICPPTemplateArgument val = param.getDefaultValue();
            if (val != null && (dflt = val.getTypeValue()) != null) {
                Database db = this.getPDOM().getDB();
                PDOMNode typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, dflt);
                if (typeNode != null) {
                    db.putRecPtr(this.record + 28L, typeNode.getRecord());
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPTemplateTypeParameter) {
            ICPPTemplateTypeParameter ttp = (ICPPTemplateTypeParameter)newBinding;
            this.updateName(newBinding.getNameCharArray());
            IType newDefault = null;
            try {
                newDefault = ttp.getDefault();
            }
            catch (DOMException dOMException) {}
            if (newDefault != null) {
                Database db = this.getDB();
                IType mytype = this.getDefault();
                PDOMNode typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, newDefault);
                if (typeNode != null) {
                    db.putRecPtr(this.record + 28L, typeNode.getRecord());
                    if (mytype != null) {
                        linkage.deleteType(mytype, this.record);
                    }
                }
            }
        }
    }

    public void forceDelete(PDOMLinkage linkage) throws CoreException {
        this.getDBName().delete();
        IType type = this.getDefault();
        if (type instanceof PDOMNode) {
            ((PDOMNode)((Object)type)).delete(linkage);
        }
    }
}

