/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPTemplateParameterMap {
    public static long putMap(PDOMNode parent, ICPPTemplateParameterMap map) throws CoreException {
        long block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        Integer[] keys = map.getAllParameterPositions();
        int len = Math.min(keys.length, 341);
        long p = block = db.malloc(2 + 12 * len);
        db.putShort(p, (short)len);
        p += 2L;
        int i = 0;
        while (i < len) {
            PDOMNode type;
            Integer paramPos = keys[i];
            db.putInt(p, paramPos);
            p += 4L;
            ICPPTemplateArgument arg = map.getArgument(paramPos);
            if (arg.isNonTypeValue()) {
                type = linkage.addType(parent, arg.getTypeOfNonTypeValue());
                db.putRecPtr(p, type == null ? 0L : type.getRecord());
                long valueRec = PDOMValue.store(db, linkage, arg.getNonTypeValue());
                db.putRecPtr(p + 4L, valueRec);
            } else {
                type = linkage.addType(parent, arg.getTypeValue());
                db.putRecPtr(p, type == null ? 0L : type.getRecord());
            }
            p += 8L;
            ++i;
        }
        return block;
    }

    public static void clearMap(PDOMNode parent, int rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 341 ? 1 : 0) != 0);
        rec += 2;
        int i = 0;
        while (i < len) {
            long typeRec = db.getRecPtr(rec += 4);
            if (typeRec != 0L) {
                IType t = (IType)((Object)linkage.getNode(typeRec));
                linkage.deleteType(t, parent.getRecord());
            }
            long nonTypeValueRec = db.getRecPtr(rec + 4);
            PDOMValue.delete(db, nonTypeValueRec);
            rec += 8;
            ++i;
        }
        db.free(rec);
    }

    public static CPPTemplateParameterMap getMap(PDOMNode parent, long rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 341 ? 1 : 0) != 0);
        if (len == 0) {
            return CPPTemplateParameterMap.EMPTY;
        }
        rec += 2L;
        CPPTemplateParameterMap result = new CPPTemplateParameterMap(len);
        int i = 0;
        while (i < len) {
            CPPTemplateArgument arg;
            int parPos = db.getInt(rec);
            long typeRec = db.getRecPtr(rec + 4L);
            IType type = typeRec == 0L ? new CPPBasicType(-1, 0) : (IType)((Object)linkage.getNode(typeRec));
            long nonTypeValRec = db.getRecPtr(rec + 8L);
            if (nonTypeValRec != 0L) {
                IValue val = PDOMValue.restore(db, linkage, nonTypeValRec);
                arg = new CPPTemplateArgument(val, type);
            } else {
                arg = new CPPTemplateArgument(type);
            }
            result.put(parPos, (ICPPTemplateArgument)arg);
            rec += 12L;
            ++i;
        }
        return result;
    }
}

