/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPBasicType
extends PDOMNode
implements ICPPBasicType,
IIndexType {
    private static final int TYPE_ID = 8;
    private static final int QUALIFIER_FLAGS = 10;
    private static final int RECORD_SIZE = 12;
    protected short fFlags = (short)-1;
    protected short fType = (short)-1;

    public PDOMCPPBasicType(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCPPBasicType(PDOMLinkage linkage, PDOMNode parent, ICPPBasicType type) throws CoreException {
        this(linkage, parent, type, PDOMCPPBasicType.encodeFlags(type));
    }

    protected PDOMCPPBasicType(PDOMLinkage linkage, PDOMNode parent, ICPPBasicType type, short flags) throws CoreException {
        super(linkage, parent);
        this.fFlags = flags;
        Database db = this.getDB();
        db.putShort(this.record + 8L, this.getTypeCode(type));
        db.putShort(this.record + 10L, flags);
    }

    private short getTypeCode(ICPPBasicType type) {
        short tc = 0;
        try {
            tc = (short)type.getType();
        }
        catch (DOMException dOMException) {}
        return tc;
    }

    protected static short encodeFlags(ICPPBasicType type) {
        short flags = 0;
        try {
            if (type.isLong()) {
                flags = (short)(flags | 1);
            }
            if (type.isShort()) {
                flags = (short)(flags | 2);
            }
            if (type.isSigned()) {
                flags = (short)(flags | 4);
            }
            if (type.isUnsigned()) {
                flags = (short)(flags | 8);
            }
        }
        catch (DOMException dOMException) {}
        return flags;
    }

    protected int getRecordSize() {
        return 12;
    }

    public int getNodeType() {
        return 13;
    }

    public int getType() {
        if (this.fType == -1) {
            try {
                this.fType = this.getDB().getShort(this.record + 8L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fType = 0;
            }
        }
        return this.fType;
    }

    @Deprecated
    public IASTExpression getValue() throws DOMException {
        return null;
    }

    public int getQualifierBits() {
        if (this.fFlags == -1) {
            try {
                this.fFlags = this.getDB().getShort(this.record + 10L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fFlags = 0;
            }
        }
        return this.fFlags;
    }

    public boolean isLong() throws DOMException {
        return (this.getQualifierBits() & 1) != 0;
    }

    public boolean isShort() throws DOMException {
        return (this.getQualifierBits() & 2) != 0;
    }

    public boolean isSigned() throws DOMException {
        return (this.getQualifierBits() & 4) != 0;
    }

    public boolean isUnsigned() throws DOMException {
        return (this.getQualifierBits() & 8) != 0;
    }

    public boolean isSameType(IType rhs) {
        int type;
        ICPPBasicType rhs1;
        block6: {
            if (rhs instanceof ITypedef) {
                return rhs.isSameType(this);
            }
            if (!(rhs instanceof ICPPBasicType)) {
                return false;
            }
            rhs1 = (ICPPBasicType)rhs;
            try {
                type = this.getType();
                if (type != -1 && type == rhs1.getType()) break block6;
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type == 3) {
            return (this.getQualifierBits() & 0xFFFFFFFB) == (rhs1.getQualifierBits() & 0xFFFFFFFB);
        }
        return this.getQualifierBits() == rhs1.getQualifierBits();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

