/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.internal.core.pdom.db.Chunk;

public final class ChunkCache {
    private static ChunkCache sSharedInstance = new ChunkCache();
    private Chunk[] fPageTable;
    private boolean fTableIsFull = false;
    private int fPointer = 0;

    public static ChunkCache getSharedInstance() {
        return sSharedInstance;
    }

    public ChunkCache() {
        this(0x500000L);
    }

    public ChunkCache(long maxSize) {
        this.fPageTable = new Chunk[this.computeLength(maxSize)];
    }

    public synchronized void add(Chunk chunk, boolean locked) {
        if (locked) {
            chunk.fLocked = true;
        }
        if (chunk.fCacheIndex >= 0) {
            chunk.fCacheHitFlag = true;
            return;
        }
        if (this.fTableIsFull) {
            this.evictChunk();
            chunk.fCacheIndex = this.fPointer;
            this.fPageTable[this.fPointer] = chunk;
        } else {
            chunk.fCacheIndex = this.fPointer;
            this.fPageTable[this.fPointer] = chunk;
            ++this.fPointer;
            if (this.fPointer == this.fPageTable.length) {
                this.fPointer = 0;
                this.fTableIsFull = true;
            }
        }
    }

    private void evictChunk() {
        Chunk chunk;
        while (true) {
            chunk = this.fPageTable[this.fPointer];
            if (!chunk.fCacheHitFlag) break;
            chunk.fCacheHitFlag = false;
            this.fPointer = (this.fPointer + 1) % this.fPageTable.length;
        }
        chunk.fDatabase.releaseChunk(chunk);
        chunk.fCacheIndex = -1;
        this.fPageTable[this.fPointer] = null;
    }

    public synchronized void remove(Chunk chunk) {
        int idx = chunk.fCacheIndex;
        if (idx >= 0) {
            Chunk move;
            if (this.fTableIsFull) {
                this.fPointer = this.fPageTable.length - 1;
                this.fTableIsFull = false;
            } else {
                --this.fPointer;
            }
            chunk.fCacheIndex = -1;
            this.fPageTable[idx] = move = this.fPageTable[this.fPointer];
            move.fCacheIndex = idx;
            this.fPageTable[this.fPointer] = null;
        }
    }

    public synchronized long getMaxSize() {
        return (long)this.fPageTable.length * 4096L;
    }

    public synchronized void setMaxSize(long maxSize) {
        int oldLength;
        int newLength = this.computeLength(maxSize);
        int n = oldLength = this.fTableIsFull ? this.fPageTable.length : this.fPointer;
        if (newLength > oldLength) {
            Chunk[] newTable = new Chunk[newLength];
            System.arraycopy(this.fPageTable, 0, newTable, 0, oldLength);
            this.fTableIsFull = false;
            this.fPointer = oldLength;
            this.fPageTable = newTable;
        } else {
            int i = newLength;
            while (i < oldLength) {
                Chunk chunk = this.fPageTable[i];
                chunk.fDatabase.releaseChunk(chunk);
                chunk.fCacheIndex = -1;
                ++i;
            }
            Chunk[] newTable = new Chunk[newLength];
            System.arraycopy(this.fPageTable, 0, newTable, 0, newLength);
            this.fTableIsFull = true;
            this.fPointer = 0;
            this.fPageTable = newTable;
        }
    }

    private int computeLength(long maxSize) {
        long maxLength = Math.min(maxSize / 4096L, Integer.MAX_VALUE);
        return Math.max(1, (int)maxLength);
    }
}

