/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryElement;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.SourceMapper;
import org.eclipse.cdt.internal.core.model.SourceRange;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryElement
extends CElement
implements IBinaryElement,
ISourceManipulation,
ISourceReference {
    IAddress addr;
    int fStartLine;
    int fEndLine;
    ITranslationUnit fSourceTU;

    public BinaryElement(ICElement parent, String name, int type, IAddress a) {
        super(parent, name, type);
        this.addr = a;
    }

    @Override
    public void copy(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    @Override
    public void move(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    @Override
    public void rename(String name, boolean replace, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    @Override
    public String getSource() throws CModelException {
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu != null) {
            try {
                IResource res = tu.getResource();
                if (res != null && res instanceof IFile) {
                    StringBuffer buffer = Util.getContent((IFile)res);
                    return buffer.substring(this.getStartPos(), this.getStartPos() + this.getLength());
                }
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
        }
        return "";
    }

    @Override
    public ISourceRange getSourceRange() throws CModelException {
        return new SourceRange(this.getStartPos(), this.getLength(), this.getIdStartPos(), this.getIdLength(), this.getStartLine(), this.getEndLine());
    }

    @Override
    public ITranslationUnit getTranslationUnit() {
        if (this.fSourceTU == null) {
            ITranslationUnit tu = null;
            CModelManager mgr = CModelManager.getDefault();
            ICElement parent = this.getParent();
            if (parent != null) {
                String lastSegment;
                ICProject cproject;
                SourceMapper mapper;
                IPath path = parent.getPath();
                if (path != null && path.isAbsolute()) {
                    ICElement e;
                    IFile res = mgr.getCModel().getWorkspace().getRoot().getFileForLocation(path);
                    if (res != null && res.exists() && res.getType() == 1 && (e = CModelManager.getDefault().create((IResource)res, null)) instanceof ITranslationUnit) {
                        tu = (ITranslationUnit)e;
                    }
                    ICProject cproject2 = this.getCProject();
                    tu = mgr.createTranslationUnitFrom(cproject2, path);
                } else {
                    path = new Path("");
                }
                if (tu == null && (mapper = mgr.getSourceMapper(cproject = this.getCProject())) != null && (lastSegment = path.lastSegment()) != null) {
                    tu = mapper.findTranslationUnit(lastSegment);
                }
            }
            this.fSourceTU = tu;
        }
        return this.fSourceTU;
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new CElementInfo(this);
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    public IAddress getAddress() throws CModelException {
        return this.addr;
    }

    public void setLines(int startline, int endLine) {
        this.fStartLine = startline;
        this.fEndLine = endLine;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    private int getLength() {
        return 0;
    }

    public int getStartPos() {
        return 0;
    }

    private int getIdLength() {
        return 0;
    }

    public int getIdStartPos() {
        return 0;
    }

    @Override
    public IBinary getBinary() {
        ICElement current = this;
        do {
            if (!(current instanceof IBinary)) continue;
            return (IBinary)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    protected void generateInfos(CElementInfo info, Map<ICElement, CElementInfo> newElements, IProgressMonitor monitor) throws CModelException {
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        return null;
    }

    @Override
    public String getHandleMemento() {
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public int getIndex() {
        return 0;
    }
}

