/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexType;

public class CPPClassSpecialization
extends CPPSpecialization
implements ICPPClassSpecialization,
ICPPInternalClassTypeMixinHost {
    private ICPPClassSpecializationScope specScope;
    private ObjectMap specializationMap = ObjectMap.EMPTY_MAP;
    private boolean checked;

    public CPPClassSpecialization(ICPPClassType specialized, IBinding owner, ICPPTemplateParameterMap argumentMap) {
        super(specialized, owner, argumentMap);
    }

    public ICPPClassType getSpecializedBinding() {
        return (ICPPClassType)super.getSpecializedBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinding specializeMember(IBinding original) {
        CPPClassSpecialization cPPClassSpecialization = this;
        synchronized (cPPClassSpecialization) {
            IBinding result = (IBinding)this.specializationMap.get(original);
            if (result != null) {
                return result;
            }
        }
        IBinding result = CPPTemplates.createSpecialization(this, original);
        CPPClassSpecialization cPPClassSpecialization2 = this;
        synchronized (cPPClassSpecialization2) {
            IBinding concurrent = (IBinding)this.specializationMap.get(original);
            if (concurrent != null) {
                return concurrent;
            }
            if (this.specializationMap == ObjectMap.EMPTY_MAP) {
                this.specializationMap = new ObjectMap(2);
            }
            this.specializationMap.put(original, result);
            return result;
        }
    }

    public void checkForDefinition() {
        if (!this.checked && this.definition == null) {
            IBinding orig = this.getSpecializedBinding();
            IASTNode tu = null;
            while (orig != null) {
                IASTNode node;
                if (orig instanceof ICPPInternalBinding && (node = ((ICPPInternalBinding)orig).getDefinition()) != null && (tu = node.getTranslationUnit()) != null || !(orig instanceof ICPPSpecialization)) break;
                orig = ((ICPPSpecialization)orig).getSpecializedBinding();
            }
            if (tu != null) {
                FindDefinitionAction action = new FindDefinitionAction();
                tu.accept(action);
                this.definition = action.result;
            }
            this.checked = true;
        }
    }

    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        IASTNode definition = this.getDefinition();
        if (definition != null) {
            IASTNode node = definition;
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    public ICPPBase[] getBases() throws DOMException {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getBases(this);
        }
        return scope.getBases();
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getDeclaredFields(this);
        }
        return scope.getDeclaredFields();
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getDeclaredMethods(this);
        }
        return scope.getDeclaredMethods();
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getConstructors(this);
        }
        return scope.getConstructors();
    }

    public IBinding[] getFriends() throws DOMException {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getFriends(this);
        }
        return scope.getFriends();
    }

    public ICPPClassType[] getNestedClasses() throws DOMException {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getNestedClasses(this);
        }
        return scope.getNestedClasses();
    }

    public IField[] getFields() throws DOMException {
        return ClassTypeHelper.getFields(this);
    }

    public IField findField(String name) throws DOMException {
        return ClassTypeHelper.findField(this, name);
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return ClassTypeHelper.getMethods(this);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        return ClassTypeHelper.getAllDeclaredMethods(this);
    }

    public int getKey() throws DOMException {
        if (this.getDefinition() != null) {
            return this.getCompositeTypeSpecifier().getKey();
        }
        return this.getSpecializedBinding().getKey();
    }

    public ICPPClassScope getCompositeScope() throws DOMException {
        ICPPClassSpecializationScope specScope = this.getSpecializationScope();
        if (specScope != null) {
            return specScope;
        }
        return this.getCompositeTypeSpecifier().getScope();
    }

    private ICPPClassSpecializationScope getSpecializationScope() {
        this.checkForDefinition();
        if (this.getDefinition() != null) {
            return null;
        }
        if (this.specScope == null) {
            this.specScope = new CPPClassSpecializationScope(this);
        }
        return this.specScope;
    }

    public final boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexType) {
            return type.isSameType(this);
        }
        return false;
    }

    public Object clone() {
        return this;
    }

    public boolean isAnonymous() throws DOMException {
        if (this.getNameCharArray().length > 0) {
            return false;
        }
        ICPPASTCompositeTypeSpecifier spec = this.getCompositeTypeSpecifier();
        if (spec == null) {
            return this.getSpecializedBinding().isAnonymous();
        }
        IASTNode node = spec.getParent();
        return node instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)node).getDeclarators().length == 0;
    }

    private class FindDefinitionAction
    extends CPPASTVisitor {
        private char[] nameArray;
        public IASTName result;

        private FindDefinitionAction() {
            this.nameArray = CPPClassSpecialization.this.getNameCharArray();
            this.result = null;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId) {
                return 1;
            }
            if (name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            char[] c = name.getLookupKey();
            if (name.getParent() instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name.getParent()).getNames();
                if (ns[ns.length - 1] != name) {
                    return 3;
                }
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTCompositeTypeSpecifier && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPClassSpecialization.this) {
                if (name instanceof ICPPASTQualifiedName) {
                    IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                    name = ns[ns.length - 1];
                }
                this.result = name;
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration || declaration instanceof ICPPASTTemplateDeclaration) {
                return 3;
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTCompositeTypeSpecifier ? 3 : 1;
        }

        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

