/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.internal.core.index.IIndexType;

public class CPPBasicType
implements ICPPBasicType {
    protected int qualifierBits = 0;
    protected int type;
    protected IASTExpression expression = null;

    public CPPBasicType(int t, int bits) {
        this.type = t;
        this.qualifierBits = bits;
        if (this.type == 0 && (this.qualifierBits & 0xF) != 0) {
            this.type = 3;
        }
    }

    public CPPBasicType(int t, int bits, IASTExpression fromExpression) {
        this.type = t;
        this.qualifierBits = bits;
        this.expression = fromExpression;
    }

    public boolean isSameType(IType object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ITypedef || object instanceof IIndexType) {
            return object.isSameType(this);
        }
        if (!(object instanceof CPPBasicType)) {
            return false;
        }
        if (this.type == -1) {
            return false;
        }
        CPPBasicType t = (CPPBasicType)object;
        if (this.type != t.type) {
            return false;
        }
        if (this.type == 3) {
            return (this.qualifierBits & 0xFFFFFFFB) == (t.qualifierBits & 0xFFFFFFFB);
        }
        return this.qualifierBits == t.qualifierBits;
    }

    public int getType() {
        return this.type;
    }

    public boolean isSigned() {
        return (this.qualifierBits & 4) != 0;
    }

    public boolean isUnsigned() {
        return (this.qualifierBits & 8) != 0;
    }

    public boolean isShort() {
        return (this.qualifierBits & 2) != 0;
    }

    public boolean isLong() {
        return (this.qualifierBits & 1) != 0;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Deprecated
    public IASTExpression getValue() {
        return this.expression;
    }

    public void setFromExpression(IASTExpression val) {
        this.expression = val;
    }

    public IASTExpression getCreatedFromExpression() {
        return this.expression;
    }

    public int getQualifierBits() {
        return this.qualifierBits;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

