/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTUsingDeclaration
extends ASTNode
implements ICPPASTUsingDeclaration,
IASTCompletionContext {
    private boolean typeName;
    private IASTName name;

    public CPPASTUsingDeclaration() {
    }

    public CPPASTUsingDeclaration(IASTName name) {
        this.setName(name);
    }

    public CPPASTUsingDeclaration copy() {
        CPPASTUsingDeclaration copy = new CPPASTUsingDeclaration(this.name == null ? null : this.name.copy());
        copy.typeName = this.typeName;
        copy.setOffsetAndLength(this);
        return copy;
    }

    public void setIsTypename(boolean value) {
        this.assertNotFrozen();
        this.typeName = value;
    }

    public boolean isTypename() {
        return this.typeName;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 2;
        }
        return 3;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof ICPPNamespace) {
                filtered.add(bindings[i]);
            }
            ++i;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }

    public String toString() {
        return this.name.toString();
    }
}

