/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.GCCBuiltinSymbolProvider;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguityResolver;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespace;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScopeMapper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPASTPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeFileContent;

public class CPPASTTranslationUnit
extends ASTTranslationUnit
implements ICPPASTTranslationUnit,
IASTAmbiguityParent {
    private CPPNamespaceScope fScope = null;
    private ICPPNamespace fBinding = null;
    private CPPScopeMapper fScopeMapper = new CPPScopeMapper(this);

    public CPPASTTranslationUnit copy() {
        CPPASTTranslationUnit copy = new CPPASTTranslationUnit();
        this.copyAbstractTU(copy);
        return copy;
    }

    public CPPNamespaceScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CPPNamespaceScope(this);
            this.addBuiltinOperators(this.fScope);
        }
        return this.fScope;
    }

    private void addBuiltinOperators(CPPScope theScope) {
        CPPBasicType cpp_void = new CPPBasicType(1, 0);
        GPPPointerType cpp_void_p = new GPPPointerType((IType)new CPPQualifierType(new CPPBasicType(1, 0), false, false), new GPPASTPointer());
        CPPBasicType cpp_size_t = new CPPBasicType(3, 0);
        CPPImplicitFunction temp = null;
        IType[] newParms = new IType[]{cpp_size_t};
        CPPFunctionType newFunctionType = new CPPFunctionType(cpp_void_p, newParms);
        IParameter[] newTheParms = new IParameter[]{new GCCBuiltinSymbolProvider.CPPBuiltinParameter(newParms[0])};
        temp = new CPPImplicitFunction(OverloadableOperator.NEW.toCharArray(), theScope, newFunctionType, newTheParms, false);
        theScope.addBinding(temp);
        temp = null;
        temp = new CPPImplicitFunction(OverloadableOperator.NEW_ARRAY.toCharArray(), theScope, newFunctionType, newTheParms, false);
        theScope.addBinding(temp);
        temp = null;
        IType[] deleteParms = new IType[]{cpp_void_p};
        CPPFunctionType deleteFunctionType = new CPPFunctionType(cpp_void, deleteParms);
        IParameter[] deleteTheParms = new IParameter[]{new GCCBuiltinSymbolProvider.CPPBuiltinParameter(deleteParms[0])};
        temp = new CPPImplicitFunction(OverloadableOperator.DELETE.toCharArray(), theScope, deleteFunctionType, deleteTheParms, false);
        theScope.addBinding(temp);
        temp = null;
        temp = new CPPImplicitFunction(OverloadableOperator.DELETE_ARRAY.toCharArray(), theScope, deleteFunctionType, deleteTheParms, false);
        theScope.addBinding(temp);
    }

    public IASTName[] getDeclarationsInAST(IBinding binding) {
        if (binding instanceof IMacroBinding) {
            return this.getMacroDefinitionsInAST((IMacroBinding)binding);
        }
        return CPPVisitor.getDeclarations(this, binding);
    }

    public IASTName[] getDefinitionsInAST(IBinding binding) {
        if (binding instanceof IMacroBinding) {
            return this.getMacroDefinitionsInAST((IMacroBinding)binding);
        }
        Object[] names = CPPVisitor.getDeclarations(this, binding);
        int i = 0;
        while (i < names.length) {
            if (!names[i].isDefinition()) {
                names[i] = null;
            }
            ++i;
        }
        return (IASTName[])ArrayUtil.removeNulls(IASTName.class, names);
    }

    public IASTName[] getReferences(IBinding binding) {
        if (binding instanceof IMacroBinding) {
            return this.getMacroReferencesInAST((IMacroBinding)binding);
        }
        return CPPVisitor.getReferences(this, binding);
    }

    public IBinding resolveBinding() {
        if (this.fBinding == null) {
            this.fBinding = new CPPNamespace(this);
        }
        return this.fBinding;
    }

    public ParserLanguage getParserLanguage() {
        return ParserLanguage.CPP;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public void skippedFile(int offset, IncludeFileContent fileContent) {
        super.skippedFile(offset, fileContent);
        this.fScopeMapper.registerAdditionalDirectives(offset, fileContent.getUsingDirectives());
    }

    public IScope mapToASTScope(IIndexScope scope) {
        return this.fScopeMapper.mapToASTScope(scope);
    }

    public ICPPClassType mapToAST(ICPPClassType binding) {
        return this.fScopeMapper.mapToAST(binding);
    }

    public void handleAdditionalDirectives(ICPPNamespaceScope scope) {
        this.fScopeMapper.handleAdditionalDirectives(scope);
    }

    public void resolveAmbiguities() {
        this.accept(new CPPASTAmbiguityResolver());
    }
}

