/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpressionList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTExpressionList
extends ASTNode
implements ICPPASTExpressionList,
IASTAmbiguityParent {
    private IASTImplicitName[] implicitNames;
    private ICPPFunction[] overloads = null;
    private IASTExpression[] expressions = new IASTExpression[2];

    public CPPASTExpressionList copy() {
        CPPASTExpressionList copy = new CPPASTExpressionList();
        IASTExpression[] iASTExpressionArray = this.getExpressions();
        int n = iASTExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTExpression expr = iASTExpressionArray[n2];
            copy.addExpression(expr == null ? null : expr.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression[] getExpressions() {
        if (this.expressions == null) {
            return IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return (IASTExpression[])ArrayUtil.trim(IASTExpression.class, this.expressions);
    }

    public void addExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.expressions = (IASTExpression[])ArrayUtil.append(IASTExpression.class, this.expressions, expression);
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NESTED_EXPRESSION);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTExpression[] exps = this.getExpressions();
        IASTImplicitName[] implicits = action.shouldVisitImplicitNames ? this.computeImplicitNames() : null;
        int i = 0;
        int n = exps.length;
        while (i < n) {
            if (!exps[i].accept(action)) {
                return false;
            }
            if (i < n - 1 && implicits != null && implicits[i] != null && !implicits[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    private IASTImplicitName[] computeImplicitNames() {
        if (this.implicitNames == null) {
            IASTExpression[] exprs = this.getExpressions();
            if (exprs.length < 2) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            this.implicitNames = new IASTImplicitName[exprs.length - 1];
            ICPPFunction[] overloads = this.getOverloads();
            int i = 0;
            while (i < overloads.length) {
                ICPPFunction overload = overloads[i];
                if (overload != null) {
                    CPPASTImplicitName operatorName = new CPPASTImplicitName(OverloadableOperator.COMMA, (IASTNode)this);
                    operatorName.setBinding(overload);
                    operatorName.computeOperatorOffsets(exprs[i], true);
                    this.implicitNames[i] = operatorName;
                }
                ++i;
            }
        }
        return this.implicitNames;
    }

    public IASTImplicitName[] getImplicitNames() {
        return (IASTImplicitName[])ArrayUtil.removeNulls(IASTImplicitName.class, this.computeImplicitNames());
    }

    private ICPPFunction[] getOverloads() {
        if (this.overloads == null) {
            IASTExpression[] exprs = this.getExpressions();
            if (exprs.length < 2 || this.getPropertyInParent() == IASTFunctionCallExpression.PARAMETERS) {
                this.overloads = new ICPPFunction[0];
                return this.overloads;
            }
            this.overloads = new ICPPFunction[exprs.length - 1];
            IType lookupType = exprs[0].getExpressionType();
            int i = 1;
            while (i < exprs.length) {
                IASTExpression e1 = exprs[i - 1];
                IASTExpression e2 = exprs[i];
                ICPPFunction overload = CPPSemantics.findOverloadedOperatorComma(e1, e2, lookupType);
                if (overload == null) {
                    lookupType = e2.getExpressionType();
                } else {
                    this.overloads[i - 1] = overload;
                    try {
                        lookupType = overload.getType().getReturnType();
                    }
                    catch (DOMException dOMException) {
                        lookupType = e2.getExpressionType();
                    }
                }
                ++i;
            }
        }
        return this.overloads;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.expressions == null) {
            return;
        }
        int i = 0;
        while (i < this.expressions.length) {
            if (child == this.expressions[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.expressions[i] = (IASTExpression)other;
            }
            ++i;
        }
    }

    public IType getExpressionType() {
        ICPPFunction last;
        ICPPFunction[] overloads = this.getOverloads();
        if (overloads.length > 0 && (last = overloads[overloads.length - 1]) != null) {
            try {
                return last.getType().getReturnType();
            }
            catch (DOMException dOMException) {}
        }
        int i = this.expressions.length - 1;
        while (i >= 0) {
            IASTExpression expr = this.expressions[i];
            if (expr != null) {
                return expr.getExpressionType();
            }
            --i;
        }
        return null;
    }
}

