/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTArraySubscriptExpression
extends ASTNode
implements ICPPASTArraySubscriptExpression,
IASTAmbiguityParent {
    private IASTExpression subscriptExp;
    private IASTExpression arrayExpression;
    private IASTImplicitName[] implicitNames = null;

    public CPPASTArraySubscriptExpression() {
    }

    public CPPASTArraySubscriptExpression(IASTExpression arrayExpression, IASTExpression subscriptExp) {
        this.setArrayExpression(arrayExpression);
        this.setSubscriptExpression(subscriptExp);
    }

    public CPPASTArraySubscriptExpression copy() {
        CPPASTArraySubscriptExpression copy = new CPPASTArraySubscriptExpression();
        copy.setArrayExpression(this.arrayExpression == null ? null : this.arrayExpression.copy());
        copy.setSubscriptExpression(this.subscriptExp == null ? null : this.subscriptExp.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression getArrayExpression() {
        return this.arrayExpression;
    }

    public void setArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.arrayExpression = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(ARRAY);
        }
    }

    public IASTExpression getSubscriptExpression() {
        return this.subscriptExp;
    }

    public void setSubscriptExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.subscriptExp = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT);
        }
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                return IASTImplicitName.EMPTY_NAME_ARRAY;
            }
            CPPASTImplicitName n1 = new CPPASTImplicitName(OverloadableOperator.BRACKET, (IASTNode)this);
            n1.setBinding(overload);
            n1.computeOperatorOffsets(this.arrayExpression, true);
            CPPASTImplicitName n2 = new CPPASTImplicitName(OverloadableOperator.BRACKET, (IASTNode)this);
            n2.setBinding(overload);
            n2.computeOperatorOffsets(this.subscriptExp, true);
            n2.setAlternate(true);
            this.implicitNames = new IASTImplicitName[]{n1, n2};
        }
        return this.implicitNames;
    }

    public ICPPFunction getOverload() {
        return CPPSemantics.findOverloadedOperator(this);
    }

    public boolean accept(ASTVisitor action) {
        IASTImplicitName[] implicits;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.arrayExpression != null && !this.arrayExpression.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null && implicits.length > 0 && !implicits[0].accept(action)) {
            return false;
        }
        if (this.subscriptExp != null && !this.subscriptExp.accept(action)) {
            return false;
        }
        if (implicits != null && implicits.length > 0 && !implicits[1].accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.subscriptExp) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.subscriptExp = (IASTExpression)other;
        }
        if (child == this.arrayExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.arrayExpression = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        IType t = this.getArrayExpression().getExpressionType();
        t = SemanticUtil.getUltimateTypeUptoPointers(t);
        try {
            ICPPFunction op;
            if (t instanceof ICPPUnknownType) {
                return CPPUnknownClass.createUnnamedInstance();
            }
            if (t instanceof ICPPClassType && (op = this.getOverload()) != null) {
                return op.getType().getReturnType();
            }
            if (t instanceof IPointerType) {
                return ((IPointerType)t).getType();
            }
            if (t instanceof IArrayType) {
                return ((IArrayType)t).getType();
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }
}

