/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.ParserMessages;

public class ASTProblem
extends ASTNode
implements IASTProblem {
    private final int id;
    private final char[] arg;
    private boolean isError = false;
    protected static final Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    static {
        errorMessages.put(new Integer(0x2000001), ParserMessages.getString("ScannerProblemFactory.error.preproc.error"));
        errorMessages.put(new Integer(0x200000E), ParserMessages.getString("ScannerProblemFactory.error.preproc.warning"));
        errorMessages.put(new Integer(0x2000002), ParserMessages.getString("ScannerProblemFactory.error.preproc.inclusionNotFound"));
        errorMessages.put(new Integer(0x2000003), ParserMessages.getString("ScannerProblemFactory.error.preproc.definitionNotFound"));
        errorMessages.put(new Integer(0x2000005), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroDefn"));
        errorMessages.put(new Integer(0x2000007), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroRedefn"));
        errorMessages.put(new Integer(0x2000004), ParserMessages.getString("ScannerProblemFactory.error.preproc.unbalancedConditional"));
        errorMessages.put(new Integer(0x2000008), ParserMessages.getString("ScannerProblemFactory.error.preproc.conditionalEval"));
        errorMessages.put(new Integer(0x2000009), ParserMessages.getString("ScannerProblemFactory.error.preproc.macroUsage"));
        errorMessages.put(new Integer(0x200000B), ParserMessages.getString("ScannerProblemFactory.error.preproc.circularInclusion"));
        errorMessages.put(new Integer(0x2000006), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidDirective"));
        errorMessages.put(new Integer(0x200000A), ParserMessages.getString("ScannerProblemFactory.error.preproc.macroPasting"));
        errorMessages.put(new Integer(0x200000C), ParserMessages.getString("ScannerProblemFactory.error.preproc.missingRParen"));
        errorMessages.put(new Integer(0x200000D), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidVaArgs"));
        errorMessages.put(new Integer(0x1000003), ParserMessages.getString("ScannerProblemFactory.error.scanner.invalidEscapeChar"));
        errorMessages.put(new Integer(0x1000002), ParserMessages.getString("ScannerProblemFactory.error.scanner.unboundedString"));
        errorMessages.put(new Integer(0x1000004), ParserMessages.getString("ScannerProblemFactory.error.scanner.badFloatingPoint"));
        errorMessages.put(new Integer(0x100000F), ParserMessages.getString("ScannerProblemFactory.error.scanner.badBinaryFormat"));
        errorMessages.put(new Integer(0x1000005), ParserMessages.getString("ScannerProblemFactory.error.scanner.badHexFormat"));
        errorMessages.put(new Integer(0x1000007), ParserMessages.getString("ScannerProblemFactory.error.scanner.badOctalFormat"));
        errorMessages.put(new Integer(0x1000008), ParserMessages.getString("ScannerProblemFactory.error.scanner.badDecimalFormat"));
        errorMessages.put(new Integer(0x1000009), ParserMessages.getString("ScannerProblemFactory.error.scanner.assignmentNotAllowed"));
        errorMessages.put(new Integer(0x100000A), ParserMessages.getString("ScannerProblemFactory.error.scanner.divideByZero"));
        errorMessages.put(new Integer(0x100000B), ParserMessages.getString("ScannerProblemFactory.error.scanner.missingRParen"));
        errorMessages.put(new Integer(0x100000C), ParserMessages.getString("ScannerProblemFactory.error.scanner.expressionSyntaxError"));
        errorMessages.put(new Integer(0x100000D), ParserMessages.getString("ScannerProblemFactory.error.scanner.illegalIdentifier"));
        errorMessages.put(new Integer(0x100000E), ParserMessages.getString("ScannerProblemFactory.error.scanner.badConditionalExpression"));
        errorMessages.put(new Integer(0x1000006), ParserMessages.getString("ScannerProblemFactory.error.scanner.unexpectedEOF"));
        errorMessages.put(new Integer(0x1000001), ParserMessages.getString("ScannerProblemFactory.error.scanner.badCharacter"));
        errorMessages.put(new Integer(0x4000001), ParserMessages.getString("ParserProblemFactory.error.syntax.syntaxError"));
    }

    public ASTProblem(IASTNode parent, ASTNodeProperty property, int id, char[] arg, boolean isError, int startNumber, int endNumber) {
        this.setParent(parent);
        this.setPropertyInParent(property);
        this.setOffset(startNumber);
        this.setLength(endNumber - startNumber);
        this.isError = isError;
        this.id = id;
        this.arg = arg;
    }

    public ASTProblem(int id, char[] arg, boolean isError) {
        this.id = id;
        this.arg = arg;
        this.isError = isError;
    }

    public ASTProblem copy() {
        ASTProblem problem = new ASTProblem(this.id, this.arg == null ? null : (char[])this.arg.clone(), this.isError);
        problem.setOffsetAndLength(this);
        return problem;
    }

    public int getID() {
        return this.id;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWarning() {
        return !this.isError;
    }

    public String getMessageWithLocation() {
        String msg = this.getMessage();
        char[] file = this.getOriginatingFileName();
        int line = this.getSourceLineNumber();
        Object[] args = new Object[]{msg, new String(file), new Integer(line)};
        return ParserMessages.getFormattedString("BaseProblemFactory.problemPattern", args);
    }

    public static String getMessage(int id, String arg) {
        String msg = errorMessages.get(new Integer(id));
        if (msg == null) {
            msg = "";
        }
        if (arg != null) {
            return MessageFormat.format((String)msg, (Object[])new Object[]{arg});
        }
        return msg;
    }

    public String getMessage() {
        return ASTProblem.getMessage(this.id, this.arg == null ? null : new String(this.arg));
    }

    public boolean checkCategory(int bitmask) {
        return (this.id & bitmask) != 0;
    }

    public String[] getArguments() {
        String[] stringArray;
        if (this.arg == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = new String(this.arg);
        }
        return stringArray;
    }

    public char[] getArgument() {
        return this.arg;
    }

    public char[] getOriginatingFileName() {
        return this.getContainingFilename().toCharArray();
    }

    public int getSourceEnd() {
        IASTFileLocation location = this.getFileLocation();
        if (location != null) {
            return location.getNodeOffset() + location.getNodeLength() - 1;
        }
        return -1;
    }

    public int getSourceLineNumber() {
        IASTFileLocation location = this.getFileLocation();
        if (location != null) {
            return location.getStartingLineNumber();
        }
        return -1;
    }

    public int getSourceStart() {
        IASTFileLocation location = this.getFileLocation();
        if (location != null) {
            return location.getNodeOffset();
        }
        return -1;
    }
}

