/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ProcessClosure {
    protected static int fCounter = 0;
    protected Process fProcess;
    protected OutputStream fOutput;
    protected OutputStream fError;
    protected ReaderThread fOutputReader;
    protected ReaderThread fErrorReader;

    public ProcessClosure(Process process, OutputStream outputStream, OutputStream errorStream) {
        this.fProcess = process;
        this.fOutput = outputStream;
        this.fError = errorStream;
    }

    public void runNonBlocking() {
        ThreadGroup group = new ThreadGroup("CBuilder" + fCounter++);
        InputStream stdin = this.fProcess.getInputStream();
        InputStream stderr = this.fProcess.getErrorStream();
        this.fOutputReader = new ReaderThread(group, "OutputReader", stdin, this.fOutput);
        this.fErrorReader = new ReaderThread(group, "ErrorReader", stderr, this.fError);
        this.fOutputReader.start();
        this.fErrorReader.start();
    }

    public void runBlocking() {
        this.runNonBlocking();
        boolean finished = false;
        while (!finished) {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.fProcess.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fProcess = null;
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    public boolean isAlive() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
            this.fOutputReader.close();
            this.fErrorReader.close();
            this.fOutputReader = null;
            this.fErrorReader = null;
        }
        return false;
    }

    public boolean isRunning() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() || this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
        }
        return false;
    }

    public void terminate() {
        if (this.fProcess != null) {
            this.fProcess.destroy();
            this.fProcess = null;
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fOutputReader.close();
        this.fErrorReader.close();
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    protected static class ReaderThread
    extends Thread {
        private InputStream fInputStream;
        private OutputStream fOutputStream;
        private boolean fFinished = false;
        private String lineSeparator;

        public ReaderThread(ThreadGroup group, String name, InputStream in, OutputStream out) {
            super(group, name);
            this.fOutputStream = out;
            this.fInputStream = in;
            this.setDaemon(true);
            this.lineSeparator = System.getProperty("line.separator");
        }

        public void run() {
            block21: {
                try {
                    try {
                        try {
                            String line;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
                            while ((line = reader.readLine()) != null) {
                                line = String.valueOf(line) + this.lineSeparator;
                                this.fOutputStream.write(line.getBytes());
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                this.fOutputStream.flush();
                            }
                            catch (IOException iOException2) {}
                            try {
                                this.fInputStream.close();
                            }
                            catch (IOException iOException3) {}
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.fOutputStream.flush();
                        }
                        catch (IOException iOException) {}
                        try {
                            this.fInputStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        this.fOutputStream.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.fInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    this.complete();
                }
            }
        }

        public synchronized boolean finished() {
            return this.fFinished;
        }

        public synchronized void waitFor() {
            while (!this.fFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void complete() {
            this.fFinished = true;
            this.notify();
        }

        public void close() {
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

