/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataSerializer;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.core.settings.model.util.UserAndDiscoveredEntryLanguageData;

public class UserAndDiscoveredEntryDataSerializer
extends CDataSerializer {
    protected static final String DISABLED_DISCOVERED_ENTRIES = "disabledDiscoveredEntries";
    protected static final String KIND = "kind";
    protected static final String VALUE = "value";
    private static UserAndDiscoveredEntryDataSerializer fInstance;

    public static CDataSerializer getDefault() {
        if (fInstance == null) {
            fInstance = new UserAndDiscoveredEntryDataSerializer();
        }
        return fInstance;
    }

    public void loadEntries(CLanguageData data, ICStorageElement el) {
        UserAndDiscoveredEntryLanguageData lData = (UserAndDiscoveredEntryLanguageData)data;
        List entries = LanguageSettingEntriesSerializer.loadEntriesList(el);
        EntryStore store = new EntryStore();
        store.addEntries(entries.toArray(new ICLanguageSettingEntry[entries.size()]));
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            int kind = kinds[i];
            if (store.containsEntriesList(kind)) {
                ICLanguageSettingEntry[] sortedEntries = store.getEntries(kind);
                lData.setEntriesToStore(kind, sortedEntries);
            }
            ++i;
        }
        ICStorageElement[] children = el.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            ICStorageElement child = children[i2];
            String name = child.getName();
            if (DISABLED_DISCOVERED_ENTRIES.equals(name)) {
                this.loadDisabledEntriesInfo(lData, child);
            }
            ++i2;
        }
    }

    protected void loadDisabledEntriesInfo(UserAndDiscoveredEntryLanguageData lData, ICStorageElement el) {
        ICStorageElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            String tmp;
            int kind;
            ICStorageElement child = children[i];
            String name = child.getName();
            if ("name".equals(name) && (kind = LanguageSettingEntriesSerializer.stringToKind(tmp = child.getAttribute(KIND))) != 0 && (tmp = child.getAttribute(VALUE)) != null) {
                HashSet<String> set = lData.getDisabledSet(kind);
                if (set == null) {
                    set = new HashSet<String>();
                }
                set.add(tmp);
                lData.setDisabledSet(kind, set);
            }
            ++i;
        }
    }

    public void storeEntries(CLanguageData data, ICStorageElement el) {
        UserAndDiscoveredEntryLanguageData lData = (UserAndDiscoveredEntryLanguageData)data;
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            int kind = kinds[i];
            ICSettingEntry[] sortedEntries = lData.getEntriesFromStore(kind);
            if (sortedEntries != null && sortedEntries.length != 0) {
                LanguageSettingEntriesSerializer.serializeEntries(sortedEntries, el);
            }
            ++i;
        }
        ICStorageElement disabledNamesEl = el.createChild(DISABLED_DISCOVERED_ENTRIES);
        this.storeDisabledEntriesInfo(lData, disabledNamesEl);
    }

    protected void storeDisabledEntriesInfo(UserAndDiscoveredEntryLanguageData lData, ICStorageElement el) {
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            int kind = kinds[i];
            Set set = lData.getDisabledSet(kind);
            if (set != null && set.size() != 0) {
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    ICStorageElement child = el.createChild("name");
                    child.setAttribute(KIND, LanguageSettingEntriesSerializer.kindToString(kind));
                    child.setAttribute(VALUE, (String)iter.next());
                }
            }
            ++i;
        }
    }
}

