/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParser2;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorParserManager
extends OutputStream {
    private int nOpens;
    public static final String PREF_ERROR_PARSER = "org.eclipse.cdt.core.errorOutputParser";
    private final IProject fProject;
    private final IMarkerGenerator fMarkerGenerator;
    private Map<String, IErrorParser[]> fErrorParsers;
    private ArrayList<ProblemMarkerInfo> fErrors;
    private Vector<URI> fDirectoryStack;
    private final URI fBaseDirectoryURI;
    private String previousLine;
    private OutputStream outputStream;
    private final StringBuilder currentLine = new StringBuilder();
    private final StringBuilder scratchBuffer = new StringBuilder();
    private boolean hasErrors = false;
    private String cachedFileName = null;
    private URI cachedWorkingDirectory = null;
    private IFile cachedFile = null;
    private static boolean isCygwin = true;

    public ErrorParserManager(ACBuilder builder) {
        this(builder.getProject(), builder);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator) {
        this(project, markerGenerator, null);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, project.getLocationURI(), markerGenerator, parsersIDs);
    }

    @Deprecated
    public ErrorParserManager(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, workingDirectory == null || workingDirectory.isEmpty() ? null : URIUtil.toURI((IPath)workingDirectory), markerGenerator, parsersIDs);
    }

    public ErrorParserManager(IProject project, URI baseDirectoryURI, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this.fProject = project;
        this.fMarkerGenerator = markerGenerator;
        this.fDirectoryStack = new Vector();
        this.fErrors = new ArrayList();
        this.enableErrorParsers(parsersIDs);
        this.fBaseDirectoryURI = baseDirectoryURI != null ? baseDirectoryURI : project.getLocationURI();
    }

    private void enableErrorParsers(String[] parsersIDs) {
        if (parsersIDs == null) {
            parsersIDs = CCorePlugin.getDefault().getAllErrorParsersIDs();
        }
        this.fErrorParsers = new LinkedHashMap<String, IErrorParser[]>(parsersIDs.length);
        String[] stringArray = parsersIDs;
        int n = parsersIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String parsersID = stringArray[n2];
            IErrorParser[] parsers = CCorePlugin.getDefault().getErrorParser(parsersID);
            this.fErrorParsers.put(parsersID, parsers);
            ++n2;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    @Deprecated
    public IPath getWorkingDirectory() {
        return URIUtil.toPath((URI)this.getWorkingDirectoryURI());
    }

    public URI getWorkingDirectoryURI() {
        if (!this.fDirectoryStack.isEmpty()) {
            return this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectoryURI;
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            URI uri;
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            if (!dir.isAbsolute()) {
                uri = org.eclipse.core.runtime.URIUtil.append((URI)workingDirectoryURI, (String)dir.toString());
            } else {
                uri = this.toURI(dir);
                if (uri == null) {
                    return;
                }
            }
            this.pushDirectoryURI(uri);
        }
    }

    public void pushDirectoryURI(URI dir) {
        if (dir != null) {
            if (dir.isAbsolute()) {
                this.fDirectoryStack.addElement(dir);
            } else {
                this.fDirectoryStack.addElement(org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)dir, (URI)this.getWorkingDirectoryURI()));
            }
        }
    }

    @Deprecated
    public IPath popDirectory() {
        return URIUtil.toPath((URI)this.popDirectoryURI());
    }

    public URI popDirectoryURI() {
        int i = this.fDirectoryStack.size();
        if (i != 0) {
            URI dir = this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return this.fBaseDirectoryURI;
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    @Deprecated
    protected void collectFiles(IProject parent, final List<IResource> result) {
        try {
            parent.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) {
                    if (proxy.getType() == 1) {
                        result.add(proxy.requestResource());
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private void processLine(String line) {
        if (this.fErrorParsers.size() == 0) {
            return;
        }
        String lineTrimmed = line.trim();
        Iterator<IErrorParser[]> iterator = this.fErrorParsers.values().iterator();
        while (iterator.hasNext()) {
            IErrorParser[] parsers;
            IErrorParser[] iErrorParserArray = parsers = iterator.next();
            int n = parsers.length;
            int n2 = 0;
            while (n2 < n) {
                IErrorParser curr = iErrorParserArray[n2];
                int types = 0;
                if (curr instanceof IErrorParser2) {
                    types = ((IErrorParser2)curr).getProcessLineBehaviour();
                }
                if ((types & 4) != 0 || lineTrimmed.length() <= 1000) {
                    String lineToParse = lineTrimmed;
                    if ((types & 1) != 0) {
                        lineToParse = line;
                    }
                    try {
                        if (curr.processLine(lineToParse, this)) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        String message = "Error parsing line [" + lineToParse + "]";
                        CCorePlugin.log(message, e);
                    }
                }
                ++n2;
            }
        }
    }

    public IFile findFileName(String partialLoc) {
        if (partialLoc.equals(this.cachedFileName) && this.cachedWorkingDirectory != null && URIUtil.equals((URI)this.getWorkingDirectoryURI(), (URI)this.cachedWorkingDirectory)) {
            return this.cachedFile;
        }
        Path path = new Path(partialLoc.replace('\\', '/'));
        IFile file = this.findFileInWorkspace((IPath)path);
        if (file == null) {
            IProject[] prjs;
            IFile[] files = ResourceLookup.findFilesByName((IPath)(path = path.setDevice(null)), prjs = new IProject[]{this.fProject}, false);
            if (files.length == 0) {
                files = ResourceLookup.findFilesByName((IPath)path, prjs, true);
            }
            if (files.length == 0 && (files = ResourceLookup.findFilesByName((IPath)path, prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects(), false)).length == 0) {
                files = ResourceLookup.findFilesByName((IPath)path, prjs, true);
            }
            if (files.length == 1) {
                file = files[0];
            }
        }
        if (file == null && isCygwin && path.isAbsolute()) {
            file = this.findCygwinFile(partialLoc);
        }
        this.cachedFileName = partialLoc;
        this.cachedWorkingDirectory = this.getWorkingDirectoryURI();
        this.cachedFile = file;
        return file;
    }

    protected IFile findFileInWorkspace(IPath path) {
        URI uri;
        if (!path.isAbsolute()) {
            uri = org.eclipse.core.runtime.URIUtil.append((URI)this.getWorkingDirectoryURI(), (String)path.toString());
        } else {
            uri = this.toURI(path);
            if (uri == null) {
                return null;
            }
        }
        return this.findFileInWorkspace(uri);
    }

    protected IFile findFileInWorkspace(URI uri) {
        IFile f;
        if (!uri.isAbsolute()) {
            uri = org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)uri, (URI)this.getWorkingDirectoryURI());
        }
        if ((f = ResourceLookup.selectFileForLocationURI(uri, this.fProject)) != null && f.isAccessible()) {
            return f;
        }
        return null;
    }

    @Deprecated
    public boolean isConflictingName(String fileName) {
        return ResourceLookup.findFilesByName((IPath)new Path(fileName), new IProject[]{this.fProject}, false).length > 1;
    }

    @Deprecated
    public IFile findFilePath(String filePath) {
        Path path = new Path(filePath);
        IFile file = this.findFileInWorkspace((IPath)path);
        if (file == null && isCygwin) {
            file = this.findCygwinFile(filePath);
        }
        return file != null && file.exists() ? file : null;
    }

    private IFile findCygwinFile(String filePath) {
        IFile file = null;
        CygPath cygpath = null;
        try {
            try {
                cygpath = new CygPath();
                Path path = new Path(cygpath.getFileName(filePath));
                file = this.findFileInWorkspace((IPath)path);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                isCygwin = false;
                if (cygpath != null) {
                    cygpath.dispose();
                }
            }
            catch (Exception exception) {
                if (cygpath != null) {
                    cygpath.dispose();
                }
            }
        }
        finally {
            if (cygpath != null) {
                cygpath.dispose();
            }
        }
        return file;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        this.generateExternalMarker(file, lineNumber, desc, severity, varName, null);
    }

    public void generateExternalMarker(IResource file, int lineNumber, String desc, int severity, String varName, IPath externalPath) {
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, desc, severity, varName, externalPath);
        this.fErrors.add(problemMarkerInfo);
        if (severity == 2) {
            this.hasErrors = true;
        }
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public OutputStream getOutputStream() {
        ++this.nOpens;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            this.fDirectoryStack.removeAllElements();
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b, off, len);
        }
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i);
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            this.processLine(line);
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    public boolean reportProblems() {
        boolean reset = false;
        if (this.nOpens == 0) {
            for (ProblemMarkerInfo problemMarkerInfo : this.fErrors) {
                if (problemMarkerInfo.severity == 3) {
                    reset = true;
                }
                this.fMarkerGenerator.addMarker(problemMarkerInfo);
            }
            this.fErrors.clear();
        }
        return reset;
    }

    private URI toURI(IPath path) {
        try {
            URI baseURI = this.getWorkingDirectoryURI();
            String uriString = path.toString();
            if (path.isAbsolute() && uriString.charAt(0) != '/') {
                uriString = String.valueOf('/') + uriString;
            }
            return new URI(baseURI.getScheme(), baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), uriString, null, null);
        }
        catch (URISyntaxException e) {
            String message = "Problem converting path to URI [" + path.toString() + "]";
            CCorePlugin.log(message, e);
            return null;
        }
    }

    @Deprecated
    public String getScratchBuffer() {
        return this.scratchBuffer.toString();
    }

    @Deprecated
    public void appendToScratchBuffer(String line) {
        this.scratchBuffer.append(line);
    }

    @Deprecated
    public void clearScratchBuffer() {
        this.scratchBuffer.setLength(0);
    }

    @Deprecated
    public boolean hasErrors() {
        return this.hasErrors;
    }
}

