/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIThreadListIdsInfo
extends MIInfo {
    int[] threadIds;
    private String[] strThreadIds;

    public MIThreadListIdsInfo(MIOutput out) {
        super(out);
    }

    public int[] getThreadIds() {
        if (this.threadIds == null) {
            String[] tIds = this.getStrThreadIds();
            this.threadIds = new int[tIds.length];
            int i = 0;
            while (i < tIds.length) {
                try {
                    this.threadIds[i] = Integer.parseInt(tIds[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.threadIds[i] = 0;
                }
                ++i;
            }
        }
        return this.threadIds;
    }

    public String[] getStrThreadIds() {
        if (this.strThreadIds == null) {
            this.parse();
        }
        return this.strThreadIds;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue val;
                String var = results[i].getVariable();
                if (var.equals("thread-ids") && (val = results[i].getMIValue()) instanceof MITuple) {
                    this.parseThreadIds((MITuple)val);
                }
                ++i;
            }
        }
        if (this.strThreadIds == null) {
            this.strThreadIds = new String[0];
        }
    }

    void parseThreadIds(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        this.strThreadIds = new String[results.length];
        int i = 0;
        while (i < results.length) {
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("thread-id") && (value = results[i].getMIValue()) instanceof MIConst) {
                this.strThreadIds[i] = ((MIConst)value).getCString().trim();
            }
            ++i;
        }
    }
}

