/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIListThreadGroups;
import org.eclipse.cdt.dsf.mi.service.command.commands.MITargetAttach;
import org.eclipse.cdt.dsf.mi.service.command.commands.MITargetDetach;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIThreadInfo;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupCreatedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupExitedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIListThreadGroupsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThread;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBProcesses_7_0
extends AbstractDsfService
implements IGDBProcesses,
ICachingService,
IEventListener {
    private Map<String, String> fThreadToGroupMap = new HashMap<String, String>();
    private IGDBControl fCommandControl;
    private IGDBBackend fBackend;
    private CommandCache fContainerCommandCache;
    private CommandCache fThreadCommandCache;
    private CommandCache fListThreadGroupsAvailableCache;
    private Map<String, String> fDebuggedProcessNames = new HashMap<String, String>();
    private static final String FAKE_THREAD_ID = "0";

    public GDBProcesses_7_0(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_0.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fContainerCommandCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fThreadCommandCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fThreadCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fListThreadGroupsAvailableCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fListThreadGroupsAvailableCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        this.fCommandControl.addEventListener(this);
        this.register(new String[]{IProcesses.class.getName(), IMIProcesses.class.getName(), IGDBProcesses.class.getName(), GDBProcesses_7_0.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fCommandControl.removeEventListener(this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    @Override
    public IProcesses.IThreadDMContext createThreadContext(IProcesses.IProcessDMContext processDmc, String threadId) {
        return new MIThreadDMC(this.getSession().getId(), processDmc, threadId);
    }

    @Override
    public IProcesses.IProcessDMContext createProcessContext(ICommandControlService.ICommandControlDMContext controlDmc, String pid) {
        return new MIProcessDMC(this.getSession().getId(), controlDmc, pid);
    }

    @Override
    public IMIExecutionDMContext createExecutionContext(IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
        return new MIExecutionDMC(this.getSession().getId(), containerDmc, threadDmc, threadId);
    }

    @Override
    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new GDBContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromThreadId(ICommandControlService.ICommandControlDMContext controlDmc, String threadId) {
        String groupId = this.fThreadToGroupMap.get(threadId);
        if (groupId == null) {
            if (this.fThreadToGroupMap.isEmpty()) {
                groupId = "";
            } else {
                Collection<String> values = this.fThreadToGroupMap.values();
                Iterator<String> iterator = values.iterator();
                if (iterator.hasNext()) {
                    String value;
                    groupId = value = iterator.next();
                }
            }
        }
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, groupId);
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public IMIExecutionDMContext[] getExecutionContexts(IMIContainerDMContext containerDmc) {
        String groupId = containerDmc.getGroupId();
        ArrayList<IMIExecutionDMContext> execDmcList = new ArrayList<IMIExecutionDMContext>();
        for (Map.Entry<String, String> entry : this.fThreadToGroupMap.entrySet()) {
            if (!entry.getValue().equals(groupId)) continue;
            String threadId = entry.getKey();
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
            IMIExecutionDMContext execDmc = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            execDmcList.add(execDmc);
        }
        return execDmcList.toArray(new IMIExecutionDMContext[0]);
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            String id = ((IMIProcessDMContext)dmc).getProcId();
            String name = null;
            if (this.fBackend.getSessionType() == SessionType.CORE || "42000".equals(id)) {
                name = this.fBackend.getProgramPath().lastSegment();
                id = null;
            } else {
                name = this.fDebuggedProcessNames.get(id);
                if (name == null) {
                    name = "Unknown name";
                }
            }
            rm.setData((Object)new MIThreadDMData(name, id));
            rm.done();
        } else if (dmc instanceof MIThreadDMC) {
            final MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
            this.fThreadCommandCache.execute((ICommand)new MIThreadInfo(controlDmc, threadDmc.getId()), (DataRequestMonitor)new DataRequestMonitor<MIThreadInfoInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIThread thread;
                    MIThreadDMData threadData = null;
                    if (((MIThreadInfoInfo)this.getData()).getThreadList().length != 0 && (thread = ((MIThreadInfoInfo)this.getData()).getThreadList()[0]).getThreadId().equals(threadDmc.getId())) {
                        threadData = new MIThreadDMData("", thread.getOsId());
                    }
                    if (threadData != null) {
                        rm.setData(threadData);
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Could not get thread info", null));
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DMC type", null));
            rm.done();
        }
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        if (dmc instanceof MIProcessDMC) {
            MIProcessDMC procDmc = (MIProcessDMC)dmc;
            rm.setData((Object)this.createContainerContext(procDmc, procDmc.getProcId()));
        } else if (dmc instanceof MIThreadDMC) {
            MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
            IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, procDmc.getProcId());
            rm.setData((Object)this.createExecutionContext(containerDmc, threadDmc, threadDmc.getId()));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid thread context.", null));
        }
        rm.done();
    }

    private boolean doIsDebuggerAttachSupported() {
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        if (backend != null) {
            return backend.getIsAttachSession();
        }
        return false;
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doIsDebuggerAttachSupported());
        rm.done();
    }

    public void attachDebuggerToProcess(final IProcesses.IProcessDMContext procCtx, final DataRequestMonitor<IDMContext> rm) {
        if (procCtx instanceof IMIProcessDMContext) {
            if (!this.doIsDebuggerAttachSupported()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Attach not supported.", null));
                rm.done();
                return;
            }
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)procCtx, ICommandControlService.ICommandControlDMContext.class);
            this.fCommandControl.queueCommand(new MITargetAttach(controlDmc, ((IMIProcessDMContext)procCtx).getProcId()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IMIContainerDMContext containerDmc = GDBProcesses_7_0.this.createContainerContext(procCtx, ((IMIProcessDMContext)procCtx).getProcId());
                    rm.setData((Object)containerDmc);
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    private boolean doCanDetachDebuggerFromProcess() {
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        if (backend != null) {
            return backend.getIsAttachSession() && this.fCommandControl.isConnected();
        }
        return false;
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doCanDetachDebuggerFromProcess());
        rm.done();
    }

    public void detachDebuggerFromProcess(IDMContext dmc, RequestMonitor rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
        if (controlDmc != null && procDmc != null) {
            if (!this.doCanDetachDebuggerFromProcess()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Detach not supported.", null));
                rm.done();
                return;
            }
            this.fCommandControl.queueCommand(new MITargetDetach(controlDmc, procDmc.getProcId()), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void isDebugNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void debugNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void getProcessesBeingDebugged(IDMContext dmc, final DataRequestMonitor<IDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (containerDmc != null) {
            this.fThreadCommandCache.execute((ICommand)new MIListThreadGroups(controlDmc, containerDmc.getGroupId()), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses_7_0.this.makeExecutionDMCs(containerDmc, ((MIListThreadGroupsInfo)this.getData()).getThreadInfo().getThreadList()));
                    rm.done();
                }
            });
        } else {
            this.fContainerCommandCache.execute((ICommand)new MIListThreadGroups(controlDmc), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses_7_0.this.makeContainerDMCs(controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                    rm.done();
                }
            });
        }
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerDmc, MIThread[] threadInfos) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
        if (threadInfos.length == 0) {
            return new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, FAKE_THREAD_ID), FAKE_THREAD_ID)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[threadInfos.length];
        int i = 0;
        while (i < threadInfos.length) {
            String threadId = threadInfos[i].getThreadId();
            executionDmcs[i] = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            ++i;
        }
        return executionDmcs;
    }

    private IMIContainerDMContext[] makeContainerDMCs(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] groups) {
        IMIContainerDMContext[] containerDmcs = new IMIContainerDMContext[groups.length];
        int i = 0;
        while (i < groups.length) {
            String groupId = groups[i].getGroupId();
            IProcesses.IProcessDMContext procDmc = this.createProcessContext(controlDmc, groupId);
            containerDmcs[i] = this.createContainerContext(procDmc, groupId);
            ++i;
        }
        return containerDmcs;
    }

    public void getRunningProcesses(IDMContext dmc, final DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc != null) {
            this.fListThreadGroupsAvailableCache.execute((ICommand)new MIListThreadGroups(controlDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    GDBProcesses_7_0.this.fListThreadGroupsAvailableCache.reset();
                    if (this.isSuccess()) {
                        rm.setData((Object)GDBProcesses_7_0.this.makeProcessDMCAndData(controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                    } else {
                        rm.setData((Object)new IProcesses.IProcessDMContext[0]);
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    private MIProcessDMCAndData[] makeProcessDMCAndData(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] processes) {
        MIProcessDMCAndData[] procDmcs = new MIProcessDMCAndData[processes.length];
        int i = 0;
        while (i < procDmcs.length) {
            procDmcs[i] = new MIProcessDMCAndData(controlDmc.getSessionId(), controlDmc, processes[i].getGroupId(), processes[i].getName());
            ++i;
        }
        return procDmcs;
    }

    public void isRunNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void runNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor rm) {
        this.fCommandControl.terminate(rm);
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupCreatedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerStartedDMEvent(containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupExitedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerExitedDMEvent(containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), false);
            this.fThreadCommandCache.setContextAvailable(e.getDMContext(), false);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
            this.fThreadCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e instanceof ContainerStartedDMEvent) {
            this.fContainerCommandCache.reset();
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e instanceof ContainerExitedDMEvent) {
            this.fContainerCommandCache.reset();
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    public void flushCache(IDMContext context) {
        this.fContainerCommandCache.reset(context);
        this.fThreadCommandCache.reset(context);
    }

    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MINotifyAsyncOutput) {
                MINotifyAsyncOutput exec = (MINotifyAsyncOutput)oobr;
                String miEvent = exec.getAsyncClass();
                if ("thread-created".equals(miEvent) || "thread-exited".equals(miEvent)) {
                    String threadId = null;
                    String groupId = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        String var = results[i].getVariable();
                        MIValue val = results[i].getMIValue();
                        if (var.equals("group-id")) {
                            if (val instanceof MIConst) {
                                groupId = ((MIConst)val).getString();
                            }
                        } else if (var.equals("id") && val instanceof MIConst) {
                            threadId = ((MIConst)val).getString();
                        }
                        ++i;
                    }
                    if ("thread-created".equals(miEvent)) {
                        this.fThreadToGroupMap.put(threadId, groupId);
                    } else {
                        this.fThreadToGroupMap.remove(threadId);
                    }
                } else if ("thread-group-created".equals(miEvent) || "thread-group-exited".equals(miEvent)) {
                    String groupId = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        String var = results[i].getVariable();
                        MIValue val = results[i].getMIValue();
                        if (var.equals("id") && val instanceof MIConst) {
                            groupId = ((MIConst)val).getString().trim();
                        }
                        ++i;
                    }
                    if (groupId != null) {
                        if ("thread-group-created".equals(miEvent)) {
                            final String finalGroupId = groupId;
                            this.fListThreadGroupsAvailableCache.execute((ICommand)new MIListThreadGroups(this.fCommandControl.getContext(), true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), null){

                                protected void handleCompleted() {
                                    GDBProcesses_7_0.this.fListThreadGroupsAvailableCache.reset();
                                    if (this.isSuccess()) {
                                        MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = ((MIListThreadGroupsInfo)this.getData()).getGroupList();
                                        int n = iThreadGroupInfoArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            MIListThreadGroupsInfo.IThreadGroupInfo groupInfo = iThreadGroupInfoArray[n2];
                                            if (groupInfo.getPid().equals(finalGroupId)) {
                                                GDBProcesses_7_0.this.fDebuggedProcessNames.put(groupInfo.getPid(), groupInfo.getName());
                                            }
                                            ++n2;
                                        }
                                    }
                                }
                            });
                        } else if ("thread-group-exited".equals(miEvent)) {
                            if (this.fThreadToGroupMap.containsValue(groupId)) {
                                Iterator<Map.Entry<String, String>> iterator = this.fThreadToGroupMap.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    if (!iterator.next().getValue().equals(groupId)) continue;
                                    iterator.remove();
                                }
                            }
                            this.fDebuggedProcessNames.remove(groupId);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerExitedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        public ContainerExitedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerStartedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public ContainerStartedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    private class GDBContainerDMC
    extends MIContainerDMC
    implements IMemory.IMemoryDMContext {
        public GDBContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            super(sessionId, processDmc, groupId);
        }
    }

    @Immutable
    private static class MIContainerDMC
    extends AbstractDMContext
    implements IMIContainerDMContext {
        private final String fId;

        public MIContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = groupId;
        }

        public String getGroupId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".threadGroup[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((MIContainerDMC)obj).fId == null ? this.fId == null : ((MIContainerDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext {
        private final String fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc == null && threadDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else if (containerDmc == null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = threadDmc;
            } else if (threadDmc == null) {
                IDMContext[] iDMContextArray3 = new IDMContext[1];
                iDMContextArray = iDMContextArray3;
                iDMContextArray3[0] = containerDmc;
            } else {
                IDMContext[] iDMContextArray4 = new IDMContext[2];
                iDMContextArray4[0] = containerDmc;
                iDMContextArray = iDMContextArray4;
                iDMContextArray4[1] = threadDmc;
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        public int getThreadId() {
            try {
                return Integer.parseInt(this.fThreadId);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public String getId() {
            return this.fThreadId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && ((MIExecutionDMC)obj).fThreadId.equals(this.fThreadId);
        }

        public int hashCode() {
            return this.baseHashCode() ^ this.fThreadId.hashCode();
        }
    }

    @Immutable
    private static class MIProcessDMC
    extends AbstractDMContext
    implements IMIProcessDMContext {
        private final String fId;

        public MIProcessDMC(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id) {
            IDMContext[] iDMContextArray;
            if (controlDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = controlDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getProcId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".proc[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((MIProcessDMC)obj).fId == null ? this.fId == null : ((MIProcessDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIProcessDMCAndData
    extends MIProcessDMC
    implements IProcesses.IThreadDMData {
        final String fName;

        public MIProcessDMCAndData(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id, String name) {
            super(sessionId, controlDmc, id);
            this.fName = name;
        }

        public String getId() {
            return this.getProcId();
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".proc[" + this.getId() + "," + this.getName() + "]";
        }

        public boolean equals(Object obj) {
            return super.equals(obj) && (((MIProcessDMCAndData)obj).fName == null ? this.fName == null : ((MIProcessDMCAndData)obj).fName.equals(this.fName));
        }

        public int hashCode() {
            return super.hashCode() ^ (this.fName == null ? 0 : this.fName.hashCode());
        }
    }

    @Immutable
    private static class MIThreadDMC
    extends AbstractDMContext
    implements IProcesses.IThreadDMContext {
        private final String fId;

        public MIThreadDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String id) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".OSthread[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((MIThreadDMC)((Object)obj)).fId == null ? this.fId == null : ((MIThreadDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    protected static class MIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public MIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

