/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.memorybrowser;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.GoToAddressBarWidget;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.MemoryBrowserPlugin;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.memory.MemoryRenderingManager;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;

public class MemoryBrowser
extends ViewPart
implements IDebugContextListener,
ILaunchListener,
IMemoryRenderingSite {
    public static final String ID = "org.eclipse.cdt.debug.ui.memory.memorybrowser.MemoryBrowser";
    protected StackLayout fStackLayout;
    private Composite fRenderingsComposite;
    private HashMap<Object, CTabFolder> fContextFolders = new HashMap();
    private GoToAddressBarWidget fGotoAddressBar;
    private Control fGotoAddressBarControl;
    private Label fUnsupportedLabel;
    private Composite fMainComposite;
    private String defaultRenderingTypeId = null;
    private ArrayList<IMemoryRenderingContainer> fCurrentContainers = new ArrayList();
    private static final String KEY_RENDERING = "RENDERING";
    private static final String KEY_CONTEXT = "CONTEXT";
    private static final String KEY_MEMORY_BLOCK = "MEMORY";
    private static final String KEY_RETRIEVAL = "RETRIEVAL";
    private static final String KEY_CONTAINER = "CONTAINER";

    private Control getControl() {
        return this.fMainComposite;
    }

    public void createPartControl(Composite parent) {
        IMemoryRenderingType[] types;
        boolean isTraditionalRenderingAvailable = false;
        IMemoryRenderingType[] iMemoryRenderingTypeArray = types = this.getRenderingTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
            if (type.getId().equals("org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering")) {
                isTraditionalRenderingAvailable = true;
                break;
            }
            ++n2;
        }
        if (isTraditionalRenderingAvailable) {
            this.defaultRenderingTypeId = "org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering";
        } else if (types.length > 0) {
            this.defaultRenderingTypeId = types[0].getId();
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new SelectionProviderAdapter());
        this.fMainComposite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.spacing = 0;
        this.fMainComposite.setLayout((Layout)layout);
        this.fGotoAddressBar = new GoToAddressBarWidget();
        this.fGotoAddressBarControl = this.fGotoAddressBar.createControl(this.fMainComposite);
        this.fGotoAddressBar.getButton(0).addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryBrowser.this.performGo(false);
            }
        });
        this.fGotoAddressBar.getButton(GoToAddressBarWidget.ID_GO_NEW_TAB).addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryBrowser.this.performGo(true);
            }
        });
        this.fGotoAddressBar.getExpressionWidget().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MemoryBrowser.this.performGo(false);
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.fGotoAddressBarControl.setLayoutData((Object)data);
        this.fRenderingsComposite = new Composite(this.fMainComposite, 0);
        data = new FormData();
        data.top = new FormAttachment(this.fGotoAddressBarControl);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.fRenderingsComposite.setLayoutData((Object)data);
        this.fStackLayout = new StackLayout();
        this.fRenderingsComposite.setLayout((Layout)this.fStackLayout);
        this.fUnsupportedLabel = new Label(this.fRenderingsComposite, 0);
        this.fUnsupportedLabel.setText("");
        this.handleUnsupportedSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fMainComposite, "org.eclipse.cdt.debug.ui.memory.memorybrowser");
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        ISelection selection = null;
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow());
        if (this.isBug145635Patched()) {
            String presentationContextId = this.getPresentationContextId();
            contextService.addDebugContextListener((IDebugContextListener)this, presentationContextId);
            selection = contextService.getActiveContext(presentationContextId);
        } else {
            contextService.addDebugContextListener((IDebugContextListener)this);
            selection = contextService.getActiveContext();
        }
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        if (selection instanceof StructuredSelection) {
            this.handleDebugContextChanged(((StructuredSelection)selection).getFirstElement());
        }
    }

    private boolean isBug145635Patched() {
        Type[] managerTypes = DebugUITools.getDebugContextManager().getClass().getGenericInterfaces();
        int i = 0;
        while (i < managerTypes.length) {
            Class clazz;
            if (managerTypes[i] instanceof Class && "org.eclipse.debug.ui.contexts.IBug145635Marker".equals((clazz = (Class)managerTypes[i]).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getPresentationContextId() {
        IViewSite site = (IViewSite)this.getSite();
        return String.valueOf(site.getId()) + (site.getSecondaryId() != null ? ":" + site.getSecondaryId() : "");
    }

    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow());
        if (this.isBug145635Patched()) {
            String presentationContextId = this.getPresentationContextId();
            contextService.removeDebugContextListener((IDebugContextListener)this, presentationContextId);
        } else {
            contextService.removeDebugContextListener((IDebugContextListener)this);
        }
        super.dispose();
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
        IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget target = iDebugTargetArray[n2];
            IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)target.getAdapter(IMemoryBlockRetrieval.class);
            if (retrieval != null) {
                this.releaseTabFolder(retrieval);
            }
            ++n2;
        }
    }

    public IMemoryRenderingContainer getContainer(String id) {
        return null;
    }

    public IMemoryRenderingContainer[] getMemoryRenderingContainers() {
        IMemoryRenderingContainer[] containerList = new IMemoryRenderingContainer[this.fCurrentContainers.size()];
        int idx = 0;
        while (idx < this.fCurrentContainers.size()) {
            containerList[idx] = this.fCurrentContainers.get(idx);
            ++idx;
        }
        return containerList;
    }

    public IMemoryRenderingSynchronizationService getSynchronizationService() {
        return null;
    }

    private void handleUnsupportedSelection() {
        this.fStackLayout.topControl = this.fUnsupportedLabel;
        this.fGotoAddressBarControl.setVisible(false);
    }

    private void performGo(boolean inNewTab) {
        final CTabFolder activeFolder = (CTabFolder)this.fStackLayout.topControl;
        if (activeFolder != null) {
            final IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)activeFolder.getData(KEY_RETRIEVAL);
            final Object context = activeFolder.getData(KEY_CONTEXT);
            if (inNewTab || activeFolder.getSelection() == null) {
                CTabItem item = this.createTab(activeFolder, activeFolder.getSelectionIndex() + 1);
                this.populateTabWithRendering(item, retrieval, context);
                this.setTabFolder(retrieval, activeFolder);
                activeFolder.setSelection(item);
                this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(item.getData(KEY_RENDERING)));
            }
            final IRepositionableMemoryRendering rendering = (IRepositionableMemoryRendering)activeFolder.getSelection().getData(KEY_RENDERING);
            final String expression = this.fGotoAddressBar.getExpressionText();
            if (retrieval instanceof IMemoryBlockRetrievalExtension) {
                new Thread(){

                    public void run() {
                        try {
                            BigInteger newBase = MemoryBrowser.this.getExpressionAddress(retrieval, expression, context);
                            if (((IMemoryBlockExtension)rendering.getMemoryBlock()).supportBaseAddressModification()) {
                                ((IMemoryBlockExtension)rendering.getMemoryBlock()).setBaseAddress(newBase);
                            }
                            rendering.goToAddress(newBase);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    MemoryBrowser.this.updateLabel(activeFolder.getSelection(), (IMemoryRendering)rendering);
                                }
                            });
                        }
                        catch (DebugException e1) {
                            MemoryViewUtil.openError((String)Messages.getString("MemoryBrowser.FailedToGoToAddressTitle"), (String)"", (Exception)((Object)e1));
                        }
                    }
                }.start();
            }
        }
    }

    private void updateLabel(CTabItem tab, IMemoryRendering rendering) {
        String label = null;
        try {
            Method m = rendering.getControl().getClass().getMethod("getViewportStartAddress", new Class[0]);
            if (m != null) {
                label = "0x" + ((BigInteger)m.invoke((Object)rendering.getControl(), new Object[0])).toString(16).toUpperCase();
            }
        }
        catch (Exception exception) {}
        if (label == null) {
            label = rendering.getLabel();
        }
        tab.setText(label);
    }

    private CTabFolder createTabFolder(Composite parent) {
        final CTabFolder folder = new CTabFolder(parent, 0x900008);
        ColorRegistry reg = JFaceResources.getColorRegistry();
        Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        folder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        folder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        folder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        folder.setBorderVisible(true);
        folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = true;
                CTabItem item = (CTabItem)event.item;
                MemoryBrowser.this.disposeTab(item);
            }
        });
        folder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CTabItem[] cTabItemArray = folder.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem tab = cTabItemArray[n2];
                    MemoryBrowser.this.disposeTab(tab);
                    ++n2;
                }
                folder.removeDisposeListener((DisposeListener)this);
            }
        });
        return folder;
    }

    private void disposeTab(CTabItem item) {
        if (item.isDisposed()) {
            return;
        }
        IMemoryRenderingContainer container = (IMemoryRenderingContainer)item.getData(KEY_CONTAINER);
        this.fCurrentContainers.remove(container);
        IMemoryRendering rendering = (IMemoryRendering)item.getData(KEY_RENDERING);
        if (rendering != null) {
            rendering.deactivated();
            rendering.dispose();
        }
        IMemoryBlockExtension block = (IMemoryBlockExtension)item.getData(KEY_MEMORY_BLOCK);
        try {
            block.dispose();
        }
        catch (DebugException e) {
            MemoryBrowserPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", "Could not dispose memory block", (Throwable)e));
        }
    }

    private CTabItem createTab(CTabFolder tabFolder, int index) {
        int swtStyle = 64;
        CTabItem tab = new CTabItem(tabFolder, swtStyle, index);
        return tab;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MemoryBrowser.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        MenuManager sub = new MenuManager(Messages.getString("MemoryBrowser.DefaultRendering"));
        IMemoryRenderingType[] iMemoryRenderingTypeArray = this.getRenderingTypes();
        int n = iMemoryRenderingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
            Action action = new Action(type.getLabel(), 8){

                public void run() {
                    MemoryBrowser.this.setDefaultRenderingTypeId(type.getId());
                }
            };
            action.setChecked(type.getId().equals(this.getDefaultRenderingTypeId()));
            sub.add((IAction)action);
            ++n2;
        }
        manager.add((IContributionItem)sub);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
    }

    private IMemoryRenderingType[] getRenderingTypes() {
        return MemoryRenderingManager.getDefault().getRenderingTypes((IMemoryBlock)new IMemoryBlockExtension(){

            public void connect(Object client) {
            }

            public void disconnect(Object client) {
            }

            public void dispose() throws DebugException {
            }

            public int getAddressSize() throws DebugException {
                return 0;
            }

            public int getAddressableSize() throws DebugException {
                return 0;
            }

            public BigInteger getBigBaseAddress() throws DebugException {
                return null;
            }

            public BigInteger getBigLength() throws DebugException {
                return null;
            }

            public MemoryByte[] getBytesFromAddress(BigInteger address, long units) throws DebugException {
                return null;
            }

            public MemoryByte[] getBytesFromOffset(BigInteger unitOffset, long addressableUnits) throws DebugException {
                return null;
            }

            public Object[] getConnections() {
                return null;
            }

            public String getExpression() {
                return null;
            }

            public BigInteger getMemoryBlockEndAddress() throws DebugException {
                return null;
            }

            public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
                return null;
            }

            public BigInteger getMemoryBlockStartAddress() throws DebugException {
                return null;
            }

            public void setBaseAddress(BigInteger address) throws DebugException {
            }

            public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
            }

            public boolean supportBaseAddressModification() throws DebugException {
                return false;
            }

            public boolean supportsChangeManagement() {
                return false;
            }

            public byte[] getBytes() throws DebugException {
                return null;
            }

            public long getLength() {
                return 0L;
            }

            public long getStartAddress() {
                return 0L;
            }

            public void setValue(long offset, byte[] bytes) throws DebugException {
            }

            public boolean supportsValueModification() {
                return false;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public ILaunch getLaunch() {
                return null;
            }

            public String getModelIdentifier() {
                return null;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        });
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.handleDebugContextChanged(((StructuredSelection)event.getContext()).getFirstElement());
    }

    public void handleDebugContextChanged(Object context) {
        if (this.defaultRenderingTypeId == null) {
            return;
        }
        if (context instanceof IAdaptable) {
            IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)((IAdaptable)context).getAdapter(IMemoryBlockRetrieval.class);
            if (retrieval != null) {
                this.fGotoAddressBarControl.setVisible(true);
                CTabFolder tabFolder = this.getTabFolder(retrieval);
                if (tabFolder != null) {
                    this.fStackLayout.topControl = tabFolder;
                } else {
                    tabFolder = this.createTabFolder(this.fRenderingsComposite);
                    tabFolder.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            MemoryBrowser.this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(((CTabItem)e.item).getData(MemoryBrowser.KEY_RENDERING)));
                        }
                    });
                    tabFolder.setData(KEY_RETRIEVAL, (Object)retrieval);
                    CTabItem item = this.createTab(tabFolder, 0);
                    this.populateTabWithRendering(item, retrieval, context);
                    this.setTabFolder(retrieval, tabFolder);
                    this.fStackLayout.topControl = this.getTabFolder(retrieval);
                }
                tabFolder.setData(KEY_CONTEXT, context);
            } else {
                this.handleUnsupportedSelection();
            }
            this.fStackLayout.topControl.getParent().layout(true);
        }
    }

    private String getDefaultRenderingTypeId() {
        return this.defaultRenderingTypeId;
    }

    private void setDefaultRenderingTypeId(String id) {
        this.defaultRenderingTypeId = id;
    }

    private void populateTabWithRendering(final CTabItem tab, IMemoryBlockRetrieval retrieval, Object context) {
        IMemoryRenderingType type = DebugUITools.getMemoryRenderingManager().getRenderingType(this.getDefaultRenderingTypeId());
        try {
            final IMemoryRendering rendering = type.createRendering();
            IMemoryRenderingContainer container = new IMemoryRenderingContainer(){

                public void addMemoryRendering(IMemoryRendering rendering2) {
                }

                public IMemoryRendering getActiveRendering() {
                    return rendering;
                }

                public String getId() {
                    return "???";
                }

                public String getLabel() {
                    return rendering.getLabel();
                }

                public IMemoryRenderingSite getMemoryRenderingSite() {
                    return MemoryBrowser.this;
                }

                public IMemoryRendering[] getRenderings() {
                    return new IMemoryRendering[]{rendering};
                }

                public void removeMemoryRendering(IMemoryRendering rendering2) {
                }
            };
            IMemoryBlockExtension block = this.createMemoryBlock(retrieval, "0", context);
            this.fCurrentContainers.add(container);
            rendering.init(container, (IMemoryBlock)block);
            rendering.createControl((Composite)tab.getParent());
            tab.setControl(rendering.getControl());
            tab.getParent().setSelection(0);
            tab.setData(KEY_RENDERING, (Object)rendering);
            tab.setData(KEY_CONTAINER, (Object)container);
            tab.setData(KEY_MEMORY_BLOCK, (Object)block);
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(tab.getData(KEY_RENDERING)));
            this.updateLabel(tab, rendering);
            rendering.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(final PropertyChangeEvent event) {
                    WorkbenchJob job = new WorkbenchJob("MemoryBrowser PropertyChanged"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (tab.isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            if (event.getProperty().equals("org.eclipse.jface.text")) {
                                MemoryBrowser.this.updateLabel(tab, rendering);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            });
        }
        catch (CoreException e) {
            MemoryBrowserPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", "", (Throwable)e));
        }
    }

    private CTabFolder getTabFolder(Object context) {
        return this.fContextFolders.get(context);
    }

    private CTabFolder setTabFolder(Object context, CTabFolder folder) {
        return this.fContextFolders.put(context, folder);
    }

    private void releaseTabFolder(Object context) {
        CTabFolder folder = this.getTabFolder(context);
        if (folder != null) {
            CTabItem[] cTabItemArray = folder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tab = cTabItemArray[n2];
                this.disposeTab(tab);
                ++n2;
            }
        }
        this.fContextFolders.remove(context);
        folder.dispose();
        if (this.fStackLayout.topControl.equals(folder)) {
            this.handleUnsupportedSelection();
        }
    }

    private IMemoryBlockExtension createMemoryBlock(IMemoryBlockRetrieval retrieval, String expression, Object context) throws DebugException {
        IMemoryBlockRetrievalExtension retrievalExtension;
        IMemoryBlockExtension block = null;
        if (retrieval instanceof IAdaptable && (retrievalExtension = (IMemoryBlockRetrievalExtension)((IAdaptable)retrieval).getAdapter(IMemoryBlockRetrievalExtension.class)) != null) {
            block = retrievalExtension.getExtendedMemoryBlock(expression, context);
        }
        if (block == null) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", "Extended Memory Block could not be obtained"));
        }
        return block;
    }

    private BigInteger getExpressionAddress(IMemoryBlockRetrieval retrieval, String expression, Object context) throws DebugException {
        IMemoryBlockExtension newBlock = this.createMemoryBlock(retrieval, expression, context);
        BigInteger address = newBlock.getBigBaseAddress();
        newBlock.dispose();
        return address;
    }

    class SelectionProviderAdapter
    implements ISelectionProvider {
        List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        ISelection theSelection = StructuredSelection.EMPTY;

        SelectionProviderAdapter() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public ISelection getSelection() {
            return this.theSelection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.theSelection = selection;
            final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] listenersArray = this.listeners.toArray();
            int i = 0;
            while (i < listenersArray.length) {
                final ISelectionChangedListener l = (ISelectionChangedListener)listenersArray[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(e);
                    }
                });
                ++i;
            }
        }
    }
}

