/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpointManagement3;
import org.eclipse.cdt.debug.core.cdi.model.ICDIEventBreakpoint;
import org.eclipse.cdt.debug.core.tests.AbstractDebugTest;
import org.eclipse.cdt.debug.mi.core.MIException;

public class EventBreakpointTests
extends AbstractDebugTest {
    public static Test suite() {
        return new AbstractDebugTest.DebugTestWrapper(EventBreakpointTests.class){};
    }

    protected String getProjectName() {
        return "catchpoints";
    }

    protected String getProjectZip() {
        return "resources/debugCxxTest.zip";
    }

    protected String getProjectBinary() {
        return "catchpoints.exe";
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createDebugSession();
        EventBreakpointTests.assertNotNull((Object)this.currentTarget);
        this.currentTarget.deleteAllBreakpoints();
        this.pause();
    }

    public void testCatch() throws CModelException, IOException, MIException, CDIException {
        this.eventbreakpoints("org.eclipse.cdt.debug.gdb.catch", "");
    }

    public void testThrow() throws CModelException, IOException, MIException, CDIException {
        this.eventbreakpoints("org.eclipse.cdt.debug.gdb.throw", "");
    }

    private void eventbreakpoints(String type, String arg) throws CModelException, IOException, MIException, CDIException {
        this.setBreakOnMain();
        this.currentTarget.restart();
        this.waitSuspend(this.currentTarget);
        ICDILocator locator = this.getCurrentLocator();
        EventBreakpointTests.assertEquals((String)("Debug should be stopped in function 'main' but it is stopped in: " + locator.getFunction()), (String)"main", (String)locator.getFunction());
        this.currentTarget.deleteAllBreakpoints();
        this.pause();
        EventBreakpointTests.assertTrue((boolean)(this.currentTarget instanceof ICDIBreakpointManagement3));
        ((ICDIBreakpointManagement3)this.currentTarget).setEventBreakpoint(type, arg, 0, null, false, true);
        this.pause();
        ICDIBreakpoint[] breakpoints = this.currentTarget.getBreakpoints();
        EventBreakpointTests.assertNotNull((Object)breakpoints);
        EventBreakpointTests.assertEquals((int)1, (int)breakpoints.length);
        ICDIEventBreakpoint curbreak = breakpoints[0] instanceof ICDIEventBreakpoint ? (ICDIEventBreakpoint)breakpoints[0] : null;
        EventBreakpointTests.assertNotNull((String)"Found breakpoint is not an event breakpoint", (Object)curbreak);
        this.currentTarget.resume(false);
        this.waitSuspend(this.currentTarget);
    }
}

