/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class BreakpointProblems {
    public static final String BREAKPOINT_PROBLEM_MARKER_ID = "org.eclipse.cdt.debug.core.breakpointproblem";
    public static final String BREAKPOINT_PROBLEM_TYPE = "bp_problem_type";
    public static final String UNRESOLVED = "unresolved";
    public static final String BAD_CONDITION = "bad_condition";
    public static final String MOVED = "moved";
    public static final String BREAKPOINT_CONTEXT_NAME = "bp_context_name";
    public static final String BREAKPOINT_CONTEXT_ID = "bp_context_id";

    public static IMarker reportBreakpointMoved(ICBreakpoint breakpoint, int oldLineNumber, int newLineNumber, String contextName, String contextID) throws CoreException {
        String message = MessageFormat.format((String)BreakpointMessages.getString("BreakpointProblems_Moved"), (Object[])new Object[]{new Integer(oldLineNumber), new Integer(newLineNumber)});
        IMarker marker = BreakpointProblems.reportBreakpointProblem(breakpoint, message, 0, MOVED, true, false, contextName, contextID);
        return marker;
    }

    public static IMarker reportUnresolvedBreakpoint(ICBreakpoint breakpoint, String contextName, String contextID) throws CoreException {
        IMarker marker = BreakpointProblems.reportBreakpointProblem(breakpoint, BreakpointMessages.getString("BreakpointProblems_Unresolved"), 1, UNRESOLVED, true, false, contextName, contextID);
        return marker;
    }

    public static void removeProblemsForBreakpoint(ICBreakpoint breakpoint) throws CoreException {
        IMarker marker = breakpoint.getMarker();
        if (marker != null) {
            int lineNumber = marker.getAttribute("lineNumber", 0);
            IResource bpResource = marker.getResource();
            if (bpResource != null) {
                IMarker[] bpProblems = bpResource.findMarkers(BREAKPOINT_PROBLEM_MARKER_ID, true, 2);
                int i = 0;
                while (i < bpProblems.length) {
                    if (bpProblems[i].getAttribute("lineNumber", 0) == lineNumber) {
                        bpProblems[i].delete();
                    }
                    ++i;
                }
            }
        }
    }

    public static void removeProblemsForResolvedBreakpoint(ICBreakpoint breakpoint, String contextID) throws CoreException {
        IMarker marker = breakpoint.getMarker();
        if (marker != null) {
            int lineNumber = marker.getAttribute("lineNumber", 0);
            IResource bpResource = marker.getResource();
            if (bpResource != null) {
                IMarker[] bpProblems = bpResource.findMarkers(BREAKPOINT_PROBLEM_MARKER_ID, true, 2);
                int i = 0;
                while (i < bpProblems.length) {
                    if (bpProblems[i].getAttribute(BREAKPOINT_PROBLEM_TYPE, "").equalsIgnoreCase(UNRESOLVED) && bpProblems[i].getAttribute("lineNumber", 0) == lineNumber && bpProblems[i].getAttribute(BREAKPOINT_CONTEXT_ID, "").equals(contextID)) {
                        bpProblems[i].delete();
                    }
                    ++i;
                }
            }
        }
    }

    public static IMarker reportBreakpointProblem(ICBreakpoint breakpoint, String description, int severity, String problemType, boolean removePrevious, boolean removeOnly, String contextName, String contextID) {
        try {
            if (breakpoint instanceof ICLineBreakpoint) {
                IResource bpResource;
                IMarker existingMarker;
                ICLineBreakpoint lineBreakpoint = (ICLineBreakpoint)breakpoint;
                IMarker marker = null;
                if (removePrevious && (existingMarker = lineBreakpoint.getMarker()) != null && (bpResource = existingMarker.getResource()) != null) {
                    int lineNumber = existingMarker.getAttribute("lineNumber", 0);
                    IMarker[] bpProblems = bpResource.findMarkers(BREAKPOINT_PROBLEM_MARKER_ID, true, 2);
                    int i = 0;
                    while (i < bpProblems.length) {
                        if (bpProblems[i].getAttribute(BREAKPOINT_PROBLEM_TYPE, "").equalsIgnoreCase(problemType) && bpProblems[i].getAttribute("lineNumber", 0) == lineNumber) {
                            bpProblems[i].delete();
                        }
                        ++i;
                    }
                }
                if (!removeOnly && (marker = BreakpointProblems.reportBreakpointProblem(new ProblemMarkerInfo(lineBreakpoint.getMarker().getResource(), lineBreakpoint.getLineNumber(), description, severity, ""))) != null) {
                    marker.setAttribute(BREAKPOINT_PROBLEM_TYPE, (Object)problemType);
                    marker.setAttribute(BREAKPOINT_CONTEXT_NAME, (Object)contextName);
                    marker.setAttribute(BREAKPOINT_CONTEXT_ID, (Object)contextID);
                }
                return marker;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static IMarker reportBreakpointProblem(ProblemMarkerInfo problemMarkerInfo) {
        IResource markerResource = problemMarkerInfo.file;
        if (markerResource == null) {
            return null;
        }
        try {
            IMarker[] cur = markerResource.findMarkers(BREAKPOINT_PROBLEM_MARKER_ID, true, 1);
            if (cur != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("lineNumber");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == problemMarkerInfo.lineNumber && sev == problemMarkerInfo.severity && mesg.equals(problemMarkerInfo.description)) {
                        return cur[i];
                    }
                    ++i;
                }
            }
            IMarker marker = markerResource.createMarker(BREAKPOINT_PROBLEM_MARKER_ID);
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", problemMarkerInfo.severity);
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (problemMarkerInfo.externalPath != null) {
                marker.setAttribute("problem.externalLocation", (Object)problemMarkerInfo.externalPath.toOSString());
            }
            return marker;
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

