/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.IExecutableImporter;
import org.eclipse.cdt.debug.core.executables.IExecutableProvider;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemapping;
import org.eclipse.cdt.debug.core.executables.ISourceFilesProvider;
import org.eclipse.cdt.debug.internal.core.executables.ExecutablesChangeEvent;
import org.eclipse.cdt.debug.internal.core.executables.StandardExecutableImporter;
import org.eclipse.cdt.debug.internal.core.executables.StandardExecutableProvider;
import org.eclipse.cdt.debug.internal.core.executables.StandardSourceFileRemapping;
import org.eclipse.cdt.debug.internal.core.executables.StandardSourceFilesProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;

public class ExecutablesManager
extends PlatformObject {
    private final HashMap<String, Executable> executables = new HashMap();
    private final List<IExecutablesChangeListener> changeListeners = Collections.synchronizedList(new ArrayList());
    private final List<ISourceFileRemapping> sourceFileRemappings = Collections.synchronizedList(new ArrayList());
    private final List<IExecutableProvider> executableProviders = Collections.synchronizedList(new ArrayList());
    private final List<ISourceFilesProvider> sourceFileProviders = Collections.synchronizedList(new ArrayList());
    private final List<IExecutableImporter> executableImporters = Collections.synchronizedList(new ArrayList());
    private boolean refreshNeeded = true;
    private boolean tempDisableRefresh = false;
    private final Job refreshJob = new Job("Get Executables"){

        public IStatus run(IProgressMonitor monitor) {
            ExecutablesManager.this.refreshExecutables(monitor);
            return Status.OK_STATUS;
        }
    };
    private static ExecutablesManager executablesManager = null;

    public static ExecutablesManager getExecutablesManager() {
        if (executablesManager == null) {
            executablesManager = new ExecutablesManager();
        }
        return executablesManager;
    }

    public ExecutablesManager() {
        this.addSourceFileRemapping(new StandardSourceFileRemapping());
        this.addExecutableImporter(new StandardExecutableImporter());
        this.addExecutablesProvider(new StandardExecutableProvider());
        this.addSourceFilesProvider(new StandardSourceFilesProvider());
    }

    public void addExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeExecutablesChangeListener(IExecutablesChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void addSourceFileRemapping(ISourceFileRemapping remapping) {
        this.sourceFileRemappings.add(remapping);
    }

    public void removeSourceFileRemapping(ISourceFileRemapping remapping) {
        this.sourceFileRemappings.remove(remapping);
    }

    public void addExecutableImporter(IExecutableImporter importer) {
        this.executableImporters.add(importer);
    }

    public void removeExecutableImporter(IExecutableImporter importer) {
        this.executableImporters.remove(importer);
    }

    public void addExecutablesProvider(IExecutableProvider provider) {
        this.executableProviders.add(provider);
    }

    public void addSourceFilesProvider(ISourceFilesProvider provider) {
        this.sourceFileProviders.add(provider);
    }

    public void removeSourceFilesProvider(ISourceFilesProvider provider) {
        this.sourceFileProviders.remove(provider);
    }

    public void removeExecutablesProvider(IExecutableProvider provider) {
        this.executableProviders.remove(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus refreshExecutables(IProgressMonitor monitor) {
        if (this.tempDisableRefresh) {
            return Status.OK_STATUS;
        }
        HashMap<String, Executable> hashMap = this.executables;
        synchronized (hashMap) {
            HashMap<String, Executable> oldList = new HashMap<String, Executable>(this.executables);
            this.executables.clear();
            IExecutableProvider[] exeProviders = this.getExecutableProviders();
            Arrays.sort(exeProviders, new Comparator<IExecutableProvider>(){

                @Override
                public int compare(IExecutableProvider arg0, IExecutableProvider arg1) {
                    int p1;
                    int p0 = arg0.getPriority();
                    if (p0 > (p1 = arg1.getPriority())) {
                        return 1;
                    }
                    if (p0 < p1) {
                        return -1;
                    }
                    return 0;
                }
            });
            this.refreshNeeded = false;
            monitor.beginTask("Refresh Executables", exeProviders.length);
            IExecutableProvider[] iExecutableProviderArray = exeProviders;
            int n = exeProviders.length;
            int n2 = 0;
            while (n2 < n) {
                Executable[] exes;
                IExecutableProvider provider = iExecutableProviderArray[n2];
                Executable[] executableArray = exes = provider.getExecutables((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                int n3 = exes.length;
                int n4 = 0;
                while (n4 < n3) {
                    Executable executable = executableArray[n4];
                    this.executables.put(executable.getPath().toOSString(), executable);
                    ++n4;
                }
                ++n2;
            }
            monitor.done();
            List<IExecutablesChangeListener> list = this.changeListeners;
            synchronized (list) {
                Collection<Executable> newExes = this.executables.values();
                Executable[] exeArray = newExes.toArray(new Executable[newExes.size()]);
                Collection<Executable> oldExes = oldList.values();
                Executable[] oldArray = oldExes.toArray(new Executable[oldExes.size()]);
                for (IExecutablesChangeListener listener : this.changeListeners) {
                    listener.executablesChanged(new ExecutablesChangeEvent(oldArray, exeArray));
                }
            }
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executable[] getExecutables() {
        if (this.refreshNeeded) {
            try {
                this.refreshJob.schedule();
                this.refreshJob.join();
            }
            catch (InterruptedException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        HashMap<String, Executable> hashMap = this.executables;
        synchronized (hashMap) {
            Collection<Executable> exes = this.executables.values();
            return exes.toArray(new Executable[exes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remapSourceFile(Executable executable, String filePath) {
        List<ISourceFileRemapping> list = this.sourceFileRemappings;
        synchronized (list) {
            for (ISourceFileRemapping remapping : this.sourceFileRemappings) {
                String remappedPath = remapping.remapSourceFile(executable, filePath);
                if (remappedPath.equals(filePath)) continue;
                return remappedPath;
            }
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importExecutables(final String[] fileNames, IProgressMonitor monitor) {
        boolean handled = false;
        try {
            this.tempDisableRefresh = true;
            monitor.beginTask("Import Executables", this.executableImporters.size());
            List<IExecutableImporter> list = this.executableImporters;
            synchronized (list) {
                Collections.sort(this.executableImporters, new Comparator<IExecutableImporter>(){

                    @Override
                    public int compare(IExecutableImporter arg0, IExecutableImporter arg1) {
                        int p1;
                        int p0 = arg0.getPriority(fileNames);
                        if (p0 < (p1 = arg1.getPriority(fileNames))) {
                            return 1;
                        }
                        if (p0 > p1) {
                            return -1;
                        }
                        return 0;
                    }
                });
                for (IExecutableImporter importer : this.executableImporters) {
                    handled = importer.importExecutables(fileNames, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (handled || monitor.isCanceled()) break;
                }
            }
        }
        finally {
            this.tempDisableRefresh = false;
        }
        if (handled) {
            this.refreshExecutables(monitor);
        }
        monitor.done();
    }

    public ISourceFileRemapping[] getSourceFileRemappings() {
        return this.sourceFileRemappings.toArray(new ISourceFileRemapping[this.sourceFileRemappings.size()]);
    }

    public IExecutableProvider[] getExecutableProviders() {
        return this.executableProviders.toArray(new IExecutableProvider[this.executableProviders.size()]);
    }

    public ISourceFilesProvider[] getSourceFileProviders() {
        return this.sourceFileProviders.toArray(new ISourceFilesProvider[this.sourceFileProviders.size()]);
    }

    public IExecutableImporter[] getExecutableImporters() {
        return this.executableImporters.toArray(new IExecutableImporter[this.executableImporters.size()]);
    }

    public void scheduleRefresh(IExecutableProvider provider, long delay) {
        this.refreshNeeded = true;
        this.refreshJob.schedule(delay);
    }

    public boolean refreshNeeded() {
        return this.refreshNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executableExists(IPath exePath) {
        HashMap<String, Executable> hashMap = this.executables;
        synchronized (hashMap) {
            return this.executables.containsKey(exePath.toOSString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSourceFiles(final Executable executable, IProgressMonitor monitor) {
        String[] result = new String[]{};
        List<ISourceFilesProvider> list = this.sourceFileProviders;
        synchronized (list) {
            Collections.sort(this.sourceFileProviders, new Comparator<ISourceFilesProvider>(){

                @Override
                public int compare(ISourceFilesProvider arg0, ISourceFilesProvider arg1) {
                    int p1;
                    int p0 = arg0.getPriority(executable);
                    if (p0 < (p1 = arg1.getPriority(executable))) {
                        return 1;
                    }
                    if (p0 > p1) {
                        return -1;
                    }
                    return 0;
                }
            });
            monitor.beginTask("Finding source files in " + executable.getName(), this.sourceFileProviders.size());
            for (ISourceFilesProvider provider : this.sourceFileProviders) {
                String[] sourceFiles = provider.getSourceFiles(executable, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (sourceFiles.length <= 0) continue;
                result = sourceFiles;
                break;
            }
            monitor.done();
        }
        return result;
    }

    public IStatus removeExecutables(Executable[] executables, IProgressMonitor monitor) {
        IExecutableProvider[] exeProviders = this.getExecutableProviders();
        IStatus result = Status.OK_STATUS;
        Arrays.sort(exeProviders, new Comparator<IExecutableProvider>(){

            @Override
            public int compare(IExecutableProvider arg0, IExecutableProvider arg1) {
                int p1;
                int p0 = arg0.getPriority();
                if (p0 > (p1 = arg1.getPriority())) {
                    return 1;
                }
                if (p0 < p1) {
                    return -1;
                }
                return 0;
            }
        });
        MultiStatus combinedStatus = new MultiStatus("org.eclipse.cdt.debug.core", 2, "Couldn't remove all of the selected executables", null);
        this.refreshNeeded = false;
        monitor.beginTask("Remove Executables", exeProviders.length);
        Executable[] executableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            Executable executable = executableArray[n2];
            boolean handled = false;
            IStatus rmvStatus = Status.OK_STATUS;
            IExecutableProvider[] iExecutableProviderArray = exeProviders;
            int n3 = exeProviders.length;
            int n4 = 0;
            while (n4 < n3) {
                IExecutableProvider provider = iExecutableProviderArray[n4];
                if (!handled) {
                    rmvStatus = provider.removeExecutable(executable, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    handled = rmvStatus.getSeverity() == 0;
                }
                ++n4;
            }
            if (!handled) {
                combinedStatus.add(rmvStatus);
                result = combinedStatus;
            }
            ++n2;
        }
        monitor.done();
        return result;
    }

    public void setRefreshNeeded(boolean refresh) {
        this.refreshNeeded = true;
    }
}

