/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;

public class GdbRestartCommand
implements IRestart {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final GdbLaunch fLaunch;

    public GdbRestartCommand(DsfSession session, GdbLaunch launch) {
        this.fExecutor = session.getExecutor();
        this.fLaunch = launch;
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean canRestart() {
        Query<Boolean> canRestart = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                IGDBControl gdbControl = (IGDBControl)GdbRestartCommand.this.fTracker.getService(IGDBControl.class);
                if (gdbControl != null) {
                    rm.setData((Object)gdbControl.canRestart());
                } else {
                    rm.setData((Object)false);
                }
                rm.done();
            }
        };
        this.fExecutor.execute((Runnable)canRestart);
        try {
            return (Boolean)canRestart.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        return false;
    }

    public void restart() throws DebugException {
        IProcess[] launchProcesses;
        final AtomicReference execPathRef = new AtomicReference();
        Query<Object> restartQuery = new Query<Object>(){

            protected void execute(DataRequestMonitor<Object> rm) {
                final IGDBControl gdbControl = (IGDBControl)GdbRestartCommand.this.fTracker.getService(IGDBControl.class);
                IGDBBackend backend = (IGDBBackend)GdbRestartCommand.this.fTracker.getService(IGDBBackend.class);
                if (gdbControl != null && backend != null) {
                    execPathRef.set(backend.getProgramPath());
                    gdbControl.initInferiorInputOutput(new RequestMonitor((Executor)GdbRestartCommand.this.fExecutor, (RequestMonitor)rm, (DataRequestMonitor)rm){
                        private final /* synthetic */ DataRequestMonitor val$rm;
                        {
                            this.val$rm = dataRequestMonitor;
                            super($anonymous0, $anonymous1);
                        }

                        protected void handleSuccess() {
                            gdbControl.createInferiorProcess();
                            gdbControl.restart(GdbRestartCommand.this.fLaunch, (RequestMonitor)this.val$rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        };
        this.fExecutor.execute((Runnable)restartQuery);
        try {
            restartQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        String inferiorLabel = ((IPath)execPathRef.get()).lastSegment();
        IProcess[] iProcessArray = launchProcesses = this.fLaunch.getProcesses();
        int n = launchProcesses.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess p = iProcessArray[n2];
            if (p.getLabel().equals(inferiorLabel)) {
                this.fLaunch.removeProcess(p);
                break;
            }
            ++n2;
        }
        try {
            this.fLaunch.addInferiorProcess(inferiorLabel);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }
}

