/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;

public class RSEHelper {
    public static IHost getRemoteConnectionByName(String remoteConnection) {
        if (remoteConnection == null) {
            return null;
        }
        IHost[] connections = RSECorePlugin.getTheSystemRegistry().getHosts();
        int i = 0;
        while (i < connections.length) {
            if (connections[i].getAliasName().equals(remoteConnection)) {
                return connections[i];
            }
            ++i;
        }
        return null;
    }

    public static IService getConnectedRemoteFileService(IHost currentConnection, IProgressMonitor monitor) throws Exception {
        ISubSystem subsystem = RSEHelper.getFileSubsystem(currentConnection);
        if (subsystem == null) {
            throw new Exception(Messages.RemoteRunLaunchDelegate_4);
        }
        try {
            subsystem.connect(monitor, false);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (!subsystem.isConnected()) {
            throw new Exception(Messages.RemoteRunLaunchDelegate_5);
        }
        return ((IFileServiceSubSystem)subsystem).getFileService();
    }

    public static IService getConnectedRemoteShellService(IHost currentConnection, IProgressMonitor monitor) throws Exception {
        ISubSystem subsystem = RSEHelper.getSubSystemWithShellService(currentConnection);
        if (subsystem != null) {
            try {
                subsystem.connect(monitor, false);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            if (!subsystem.isConnected()) {
                throw new Exception(Messages.RemoteRunLaunchDelegate_5);
            }
            return (IShellService)subsystem.getSubSystemConfiguration().getService(currentConnection).getAdapter(IShellService.class);
        }
        throw new Exception(Messages.RemoteRunLaunchDelegate_4);
    }

    public static IShellService getShellService(IHost host) {
        ISubSystem ss = RSEHelper.getSubSystemWithShellService(host);
        if (ss != null) {
            return (IShellService)ss.getSubSystemConfiguration().getService(host).getAdapter(IShellService.class);
        }
        return null;
    }

    public static ISubSystem getSubSystemWithShellService(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        IShellService ssvc = null;
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            IService svc = subSystems[i].getSubSystemConfiguration().getService(host);
            if (svc != null && (ssvc = (IShellService)svc.getAdapter(IShellService.class)) != null) {
                return subSystems[i];
            }
            ++i;
        }
        return null;
    }

    public static ISubSystem getFileSubsystem(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        int i = 0;
        while (i < subSystems.length) {
            if (subSystems[i] instanceof IFileServiceSubSystem) {
                return subSystems[i];
            }
            ++i;
        }
        return null;
    }

    public static IHost[] getSuitableConnections() {
        ArrayList<IHost> shellConnections = new ArrayList<IHost>(Arrays.asList(RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory("shells")));
        ArrayList<IHost> terminalConnections = new ArrayList<IHost>(Arrays.asList(RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory("terminals")));
        for (IHost terminalConnection : terminalConnections) {
            if (shellConnections.contains(terminalConnection)) continue;
            shellConnections.add(terminalConnection);
        }
        return shellConnections.toArray(new IHost[shellConnections.size()]);
    }
}

