/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public abstract class AbstractContainerAreaDropAdapter
implements TransferDropTargetListener {
    private int originallyRequestedOperation = 0;
    private Object lastDragOverTarget = null;
    private int lastDragOverOperation = 0;

    protected abstract int dragEnterOperation(int var1);

    protected abstract int dragOverOperation(int var1, IContainer var2, Object var3);

    protected abstract void dropToContainer(Object var1, IContainer var2, int var3);

    public boolean isSupportedType(TransferData transferData) {
        return this.getTransfer().isSupportedType(transferData);
    }

    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    public void dragEnter(DropTargetEvent event) {
        this.lastDragOverTarget = null;
        this.lastDragOverOperation = 0;
        if (this.isSupportedType(event.currentDataType)) {
            this.originallyRequestedOperation = event.detail;
            event.detail = this.dragEnterOperation(this.originallyRequestedOperation);
        } else {
            event.detail = 0;
            this.originallyRequestedOperation = 0;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.originallyRequestedOperation = event.detail;
        event.detail = this.dragOverOperationCached(this.originallyRequestedOperation, AbstractContainerAreaDropAdapter.determineDropContainer(event), AbstractContainerAreaDropAdapter.determineDropTarget(event));
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = this.dragOverOperationCached(this.originallyRequestedOperation, AbstractContainerAreaDropAdapter.determineDropContainer(event), AbstractContainerAreaDropAdapter.determineDropTarget(event));
        if (this.originallyRequestedOperation != 0) {
            event.feedback = 24;
            if (event.detail != 0) {
                event.feedback |= 1;
            }
        } else {
            event.feedback = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        IContainer dropContainer = AbstractContainerAreaDropAdapter.determineDropContainer(event);
        if (dropContainer != null) {
            event.detail = this.dragOverOperationCached(event.detail, dropContainer, AbstractContainerAreaDropAdapter.determineDropTarget(event));
            this.dropToContainer(event.data, dropContainer, event.detail);
        } else {
            event.detail = 0;
        }
    }

    private int dragOverOperationCached(int operation, IContainer dropContainer, Object dropTarget) {
        if (dropTarget != this.lastDragOverTarget || operation != this.lastDragOverOperation) {
            this.lastDragOverOperation = this.dragOverOperation(operation, dropContainer, dropTarget);
            this.lastDragOverTarget = dropTarget;
        }
        return this.lastDragOverOperation;
    }

    private static Object determineDropTarget(DropTargetEvent event) {
        return event.item == null ? null : event.item.getData();
    }

    public static IContainer determineDropContainer(DropTargetEvent event) {
        Object dropTarget = AbstractContainerAreaDropAdapter.determineDropTarget(event);
        if (dropTarget instanceof IMakeTarget) {
            return ((IMakeTarget)dropTarget).getContainer();
        }
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        return null;
    }
}

