/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.DbgTcmUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectTypeBasedStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PathComparator;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.IConflict;
import org.eclipse.core.runtime.IPath;

public class ConflictSet {
    public static final IConflict[] EMPTY_CONFLICT_ARRAY = new IConflict[0];
    public static final IRealBuildObjectAssociation[] EMPTY_BO_ARRAY = new IRealBuildObjectAssociation[0];
    private PerTypeMapStorage fConflictStorage;
    private List fConflictMatchList;
    private Set fExtConflictSet;
    private IRealBuildObjectAssociation fRealObj;

    public ConflictSet(IRealBuildObjectAssociation realObj, List conflictMatchList, Set extConflictSet) {
        this.fConflictMatchList = conflictMatchList;
        this.fExtConflictSet = extConflictSet;
        this.fRealObj = realObj;
    }

    private void init() {
        if (this.fConflictStorage == null) {
            this.fConflictStorage = new PerTypeMapStorage();
            if (this.fConflictMatchList != null && this.fConflictMatchList.size() != 0) {
                int size = this.fConflictMatchList.size();
                PerTypeMapStorage result = new PerTypeMapStorage();
                int i = 0;
                while (i < size) {
                    ToolChainModificationManager.ConflictMatch match = (ToolChainModificationManager.ConflictMatch)this.fConflictMatchList.get(i);
                    int objType = match.fMatchType;
                    Map cm = match.fRObjToPathMap;
                    Map cur = result.getMap(objType, true);
                    for (Map.Entry entry : cm.entrySet()) {
                        TreeSet set;
                        Object obj = entry.getKey();
                        if (DbgTcmUtil.DEBUG && ((IRealBuildObjectAssociation)obj).getType() != objType) {
                            DbgTcmUtil.fail();
                        }
                        if ((set = (TreeSet)cur.get(obj)) == null) {
                            set = new TreeSet(PathComparator.INSTANCE);
                            cur.put(obj, set);
                        }
                        set.addAll((Set)entry.getValue());
                    }
                    ++i;
                }
                int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
                int i2 = 0;
                while (i2 < types.length) {
                    int type = types[i2];
                    Map map = result.getMap(type, false);
                    if (map != null) {
                        for (Map.Entry entry : map.entrySet()) {
                            IRealBuildObjectAssociation obj = (IRealBuildObjectAssociation)entry.getKey();
                            TreeSet set = (TreeSet)entry.getValue();
                            Map cMap = this.fConflictStorage.getMap(type, true);
                            cMap.put(obj, new Conflict(1, obj, set));
                        }
                    }
                    ++i2;
                }
            }
        }
    }

    public IConflict[] getConflicts() {
        this.init();
        int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < types.length) {
            Map map = this.fConflictStorage.getMap(types[i], false);
            if (map != null) {
                ConflictSet.getConflicts(map, list);
            }
            ++i;
        }
        return ConflictSet.conflictArray(list);
    }

    private static List getConflicts(Map map, List list) {
        if (list == null) {
            list = new ArrayList();
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    private static Conflict[] conflictArray(Collection list) {
        return list.toArray(new Conflict[list.size()]);
    }

    private static IRealBuildObjectAssociation[] objArray(Collection list) {
        return list.toArray(new IRealBuildObjectAssociation[list.size()]);
    }

    public IConflict[] getConflictsWith(int objectType) {
        this.init();
        Map map = this.fConflictStorage.getMap(objectType, false);
        if (map == null) {
            return EMPTY_CONFLICT_ARRAY;
        }
        return ConflictSet.conflictArray(map.values());
    }

    public IBuildObject[] getConflictingObjects(int objectType) {
        this.init();
        Map map = this.fConflictStorage.getMap(objectType, false);
        if (map == null) {
            return EMPTY_BO_ARRAY;
        }
        return ConflictSet.objArray(map.keySet());
    }

    public IConflict getConflictWith(IBuildObject bo) {
        this.init();
        if (!(bo instanceof IRealBuildObjectAssociation)) {
            return null;
        }
        IRealBuildObjectAssociation obj = (IRealBuildObjectAssociation)bo;
        Map map = this.fConflictStorage.getMap(obj.getType(), false);
        if (map == null) {
            return null;
        }
        return (IConflict)map.get(obj);
    }

    private static class Conflict
    implements IConflict {
        private IRealBuildObjectAssociation fObj;
        private SortedSet fPathSet;
        private int fType;

        Conflict(int type, IRealBuildObjectAssociation obj, SortedSet paths) {
            this.fType = type;
            this.fObj = obj;
            this.fPathSet = paths;
        }

        public IBuildObject getBuildObject() {
            return this.fObj;
        }

        public int getConflictType() {
            return this.fType;
        }

        public int getObjectType() {
            return this.fObj.getType();
        }

        public IPath[] getPaths() {
            return this.fPathSet.toArray(new IPath[this.fPathSet.size()]);
        }
    }
}

