/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import java.util.ArrayList;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class MbsEnvironmentSupplier
implements IEnvironmentVariableSupplier {
    public IEnvironmentVariable getVariable(String name, Object context) {
        if (context instanceof IConfiguration) {
            return this.getConfigurationVariable(name, (IConfiguration)context);
        }
        return null;
    }

    public IBuildEnvironmentVariable getConfigurationVariable(String name, IConfiguration configuration) {
        IBuilder builder;
        IPath topBuildDir;
        IResource owner;
        BuildEnvVar variable = null;
        if (("CWD".equals(name) || "PWD".equals(name)) && (owner = configuration.getOwner()) != null && (topBuildDir = ManagedBuildManager.getBuildLocation(configuration, builder = configuration.getEditableBuilder())) != null) {
            variable = new BuildEnvVar(name, topBuildDir.toOSString(), 1, null);
        }
        return variable;
    }

    public IEnvironmentVariable[] getVariables(Object context) {
        if (context instanceof IConfiguration) {
            ArrayList<IBuildEnvironmentVariable> variables = new ArrayList<IBuildEnvironmentVariable>(2);
            IBuildEnvironmentVariable var = this.getConfigurationVariable("CWD", (IConfiguration)context);
            if (var == null) {
                return null;
            }
            variables.add(var);
            variables.add(new BuildEnvVar("PWD", var.getValue(), 1, null));
            return variables.toArray(new IBuildEnvironmentVariable[variables.size()]);
        }
        return null;
    }
}

