/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConfigurationV2;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationV2
extends BuildObject
implements IConfigurationV2 {
    private boolean isDirty = false;
    private IConfigurationV2 parent;
    private boolean rebuildNeeded = false;
    private boolean resolved = true;
    private ITarget target;
    private List toolReferences;
    private IConfiguration createdConfig;

    public ConfigurationV2(Target target, Element element) {
        this.target = target;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("parent")) {
            ITarget targetParent = target.getParent();
            this.parent = targetParent != null ? targetParent.getConfiguration(element.getAttribute("parent")) : null;
        }
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("toolReference")) {
                new ToolReference((BuildObject)this, (Element)configElement);
            }
            ++i;
        }
    }

    public ConfigurationV2(Target target, IConfigurationV2 parentConfig, String id) {
        this.id = id;
        this.name = parentConfig.getName();
        this.target = target;
        this.parent = parentConfig.getParent() == null ? parentConfig : parentConfig.getParent();
        IProject cfr_ignored_0 = (IProject)target.getOwner();
        Vector allToolRefs = new Vector(target.getLocalToolReferences());
        allToolRefs.addAll(((ConfigurationV2)parentConfig).getLocalToolReferences());
        ListIterator iter = allToolRefs.listIterator();
        while (iter.hasNext()) {
            ToolReference toolRef = (ToolReference)iter.next();
            ITool parentTool = toolRef.getTool();
            ToolReference newRef = new ToolReference((BuildObject)this, parentTool);
            String refCmd = toolRef.getToolCommand();
            if (!refCmd.equals(parentTool.getToolCommand())) {
                newRef.setToolCommand(refCmd);
            }
            List optRefs = toolRef.getOptionReferenceList();
            ListIterator optIter = optRefs.listIterator();
            while (optIter.hasNext()) {
                OptionReference optRef = (OptionReference)optIter.next();
                IOption opt = optRef.getOption();
                try {
                    switch (opt.getValueType()) {
                        case 0: {
                            new OptionReference(newRef, opt).setValue(optRef.getBooleanValue());
                            break;
                        }
                        case 2: {
                            new OptionReference(newRef, opt).setValue(optRef.getStringValue());
                            break;
                        }
                        case 1: {
                            new OptionReference(newRef, opt).setValue(optRef.getSelectedEnum());
                            break;
                        }
                        case 3: {
                            new OptionReference(newRef, opt).setValue(optRef.getStringListValue());
                            break;
                        }
                        case 4: {
                            new OptionReference(newRef, opt).setValue(optRef.getIncludePaths());
                            break;
                        }
                        case 5: {
                            new OptionReference(newRef, opt).setValue(optRef.getDefinedSymbols());
                            break;
                        }
                        case 6: {
                            new OptionReference(newRef, opt).setValue(optRef.getLibraries());
                            break;
                        }
                        case 7: {
                            new OptionReference(newRef, opt).setValue(optRef.getUserObjects());
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        target.addConfiguration(this);
    }

    public ConfigurationV2(Target target, IManagedConfigElement element) {
        this.target = target;
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        this.setName(element.getAttribute("name"));
        IManagedConfigElement[] configElements = element.getChildren();
        int l = 0;
        while (l < configElements.length) {
            IManagedConfigElement configElement = configElements[l];
            if (configElement.getName().equals("toolReference")) {
                new ToolReference((BuildObject)this, configElement);
            }
            ++l;
        }
    }

    public ConfigurationV2(Target target, String id) {
        this.id = id;
        this.target = target;
        target.addConfiguration(this);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            for (ToolReference ref : this.getLocalToolReferences()) {
                ref.resolveReferences();
            }
        }
    }

    public void addToolReference(ToolReference toolRef) {
        this.getLocalToolReferences().add(toolRef);
    }

    public IToolReference[] getToolReferences() {
        List list = this.getLocalToolReferences();
        IToolReference[] tools = new IToolReference[list.size()];
        list.toArray(tools);
        return tools;
    }

    private OptionReference createOptionReference(IOption option) {
        ToolReference searchRef = null;
        ToolReference answer = null;
        if (option instanceof OptionReference) {
            OptionReference optionRef = (OptionReference)option;
            searchRef = optionRef.getToolReference();
            if (searchRef.ownedByConfiguration(this)) {
                return optionRef;
            }
            answer = this.findLocalReference(searchRef);
            if (answer == null) {
                answer = new ToolReference((BuildObject)this, searchRef);
            }
            return answer.createOptionReference(option);
        }
        searchRef = (ToolReference)this.getToolReference((ITool)option.getOptionHolder());
        answer = searchRef == null ? new ToolReference((BuildObject)this, (ITool)option.getOptionHolder()) : (!searchRef.ownedByConfiguration(this) ? new ToolReference((BuildObject)this, searchRef) : searchRef);
        return answer.createOptionReference(option);
    }

    private ToolReference findLocalReference(ToolReference toolRef) {
        for (ToolReference ref : this.getLocalToolReferences()) {
            if (!toolRef.getTool().equals(ref.getTool())) continue;
            return ref;
        }
        return null;
    }

    public ITool[] getFilteredTools(IProject project) {
        ITool[] localTools = this.getTools();
        Vector<ITool> tools = new Vector<ITool>(localTools.length);
        int i = 0;
        while (i < localTools.length) {
            ITool tool = localTools[i];
            try {
                switch (tool.getNatureFilter()) {
                    case 0: {
                        if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            tools.add(tool);
                        }
                        break;
                    }
                    case 1: {
                        if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            tools.add(tool);
                        }
                        break;
                    }
                    case 2: {
                        tools.add(tool);
                        break;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return tools.toArray(new ITool[tools.size()]);
    }

    protected List getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
        }
        return this.toolReferences;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITool[] getTools() {
        ITool[] tools = this.parent != null ? this.parent.getTools() : this.target.getTools();
        IProject project = (IProject)this.target.getOwner();
        if (project != null) {
            ArrayList<ITool> validTools = new ArrayList<ITool>();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                switch (tool.getNatureFilter()) {
                    case 0: {
                        try {
                            if (!project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            validTools.add(tool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 1: {
                        try {
                            if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            validTools.add(tool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 2: {
                        validTools.add(tool);
                    }
                }
                ++i;
            }
            tools = validTools.toArray(new ITool[validTools.size()]);
        }
        int i = 0;
        while (i < tools.length) {
            IToolReference ref = this.getToolReference(tools[i]);
            if (ref != null) {
                tools[i] = ref;
            }
            ++i;
        }
        return tools;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        ListIterator iter = this.getLocalToolReferences().listIterator();
        while (iter.hasNext()) {
            IToolReference ref = (IToolReference)iter.next();
            if (!ref.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public boolean needsRebuild() {
        return this.rebuildNeeded;
    }

    public IConfigurationV2 getParent() {
        return this.parent;
    }

    protected List getOptionReferences(ITool tool) {
        ArrayList<OptionReference> references = new ArrayList<OptionReference>();
        IToolReference toolRef = this.getToolReference(tool);
        if (toolRef != null) {
            references.addAll(toolRef.getOptionReferenceList());
        }
        if (this.parent != null) {
            List temp = ((ConfigurationV2)this.parent).getOptionReferences(tool);
            ListIterator iter = temp.listIterator();
            while (iter.hasNext()) {
                OptionReference ref = (OptionReference)iter.next();
                if (references.contains(ref)) continue;
                references.add(ref);
            }
        }
        return references;
    }

    public ITool getToolById(String id) {
        ITool[] tools = this.parent != null ? this.parent.getTools() : this.target.getTools();
        int i = 0;
        while (i < tools.length) {
            IToolReference ref = this.getToolReference(tools[i]);
            if (ref != null) {
                tools[i] = ref;
            }
            ++i;
        }
        int index = tools.length - 1;
        while (index >= 0) {
            if (tools[index].getId().equals(id)) {
                return tools[index];
            }
            --index;
        }
        return null;
    }

    public ITarget getTarget() {
        return this.target == null && this.parent != null ? this.parent.getTarget() : this.target;
    }

    public IResource getOwner() {
        return this.getTarget().getOwner();
    }

    private IToolReference getToolReference(ITool tool) {
        if (tool == null) {
            return null;
        }
        ListIterator iter = this.getLocalToolReferences().listIterator();
        while (iter.hasNext()) {
            ToolReference temp = (ToolReference)iter.next();
            if (!temp.references(tool)) continue;
            return temp;
        }
        ITool[] targetTools = this.target.getTools();
        int index = targetTools.length - 1;
        while (index >= 0) {
            ITool targetTool = targetTools[index];
            if (targetTool instanceof ToolReference && ((ToolReference)targetTool).references(tool)) {
                return (ToolReference)targetTool;
            }
            --index;
        }
        return null;
    }

    public void reset(IManagedConfigElement element) {
        this.getLocalToolReferences().clear();
        IManagedConfigElement[] configElements = element.getChildren();
        int l = 0;
        while (l < configElements.length) {
            IManagedConfigElement configElement = configElements[l];
            if (configElement.getName().equals("toolReference")) {
                ToolReference ref = new ToolReference((BuildObject)this, configElement);
                ref.resolveReferences();
            }
            ++l;
        }
        this.isDirty = true;
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        ListIterator iter = this.getLocalToolReferences().listIterator();
        while (iter.hasNext()) {
            ToolReference toolRef = (ToolReference)iter.next();
            Element toolRefElement = doc.createElement("toolReference");
            element.appendChild(toolRefElement);
            toolRef.serialize(doc, toolRefElement);
        }
        this.isDirty = false;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        ListIterator iter = this.getLocalToolReferences().listIterator();
        while (iter.hasNext()) {
            ((ToolReference)iter.next()).setDirty(isDirty);
        }
    }

    public void setOption(IOption option, boolean value) throws BuildException {
        if (option.getBooleanValue() != value) {
            this.createOptionReference(option).setValue(value);
            this.isDirty = true;
            this.rebuildNeeded = true;
        }
    }

    public void setOption(IOption option, String value) throws BuildException {
        String oldValue = option.getValueType() == 1 ? option.getSelectedEnum() : option.getStringValue();
        if (oldValue != null && !oldValue.equals(value)) {
            this.createOptionReference(option).setValue(value);
            this.isDirty = true;
            this.rebuildNeeded = true;
        }
    }

    public void setOption(IOption option, String[] value) throws BuildException {
        Object[] oldValue;
        switch (option.getValueType()) {
            case 3: {
                oldValue = option.getStringListValue();
                break;
            }
            case 4: {
                oldValue = option.getIncludePaths();
                break;
            }
            case 5: {
                oldValue = option.getDefinedSymbols();
                break;
            }
            case 6: {
                oldValue = option.getLibraries();
                break;
            }
            case 7: {
                oldValue = option.getUserObjects();
                break;
            }
            default: {
                oldValue = new String[]{};
            }
        }
        if (!Arrays.equals(value, oldValue)) {
            this.createOptionReference(option).setValue(value);
            this.isDirty = true;
            this.rebuildNeeded = true;
        }
    }

    public void setRebuildState(boolean rebuild) {
        this.rebuildNeeded = rebuild;
    }

    public void setToolCommand(ITool tool, String command) {
        if (command != null) {
            IToolReference ref = this.getToolReference(tool);
            if (ref == null) {
                ref = new ToolReference((BuildObject)this, tool);
            }
            if (ref != null) {
                this.rebuildNeeded = this.isDirty = ref.setToolCommand(command);
            }
        }
    }

    public void setCreatedConfig(IConfiguration config) {
        this.createdConfig = config;
    }

    public IConfiguration getCreatedConfig() {
        return this.createdConfig;
    }
}

