/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStateManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ConfigurationBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IProjectBuildState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ProjectBuildState
implements IProjectBuildState {
    private Properties fCfgIdToFileNameProps;
    private Map fCfgIdToStateMap = new HashMap();
    private IProject fProject;
    private boolean fIsMapInfoDirty;
    private static final int OP_CREATE = 1;
    private static final int OP_REMOVE = 2;

    public ProjectBuildState(IProject project) {
        this.fProject = project;
    }

    void setProject(IProject project) {
        this.fProject = project;
        for (ConfigurationBuildState cbs : this.fCfgIdToStateMap.values()) {
            cbs.setProject(project);
        }
    }

    public IConfigurationBuildState getConfigurationBuildState(String id, boolean create) {
        ConfigurationBuildState state = (ConfigurationBuildState)this.fCfgIdToStateMap.get(id);
        if (state == null) {
            state = this.loadState(id, create);
            if (state.exists() || create) {
                this.fCfgIdToStateMap.put(id, state);
            } else {
                state = null;
            }
        }
        return state;
    }

    private ConfigurationBuildState loadState(String id, boolean create) {
        File file = this.getFileForCfg(id, create);
        ConfigurationBuildState bs = new ConfigurationBuildState(this.fProject, id);
        if (file != null && file.exists()) {
            try {
                FileInputStream iStream = new FileInputStream(file);
                bs.load(iStream);
                ((InputStream)iStream).close();
            }
            catch (FileNotFoundException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        return bs;
    }

    public IConfigurationBuildState[] getConfigurationBuildStates() {
        Properties props = this.getIdToNameProperties();
        ArrayList<IConfigurationBuildState> list = new ArrayList<IConfigurationBuildState>(props.size());
        for (String string : props.keySet()) {
            IConfigurationBuildState state = this.getConfigurationBuildState(string, false);
            if (state == null) continue;
            list.add(state);
        }
        return list.toArray(new ConfigurationBuildState[list.size()]);
    }

    public void removeConfigurationBuildState(String id) {
        ConfigurationBuildState cbs = (ConfigurationBuildState)this.getConfigurationBuildState(id, false);
        if (cbs != null) {
            cbs.setState(1);
        }
    }

    public int getState() {
        return 0;
    }

    public void setState(int state) {
    }

    private String getFileName(String id, int op) {
        Properties props = this.getIdToNameProperties();
        String name = props.getProperty(id);
        if (name == null) {
            if (op == 1) {
                name = new Integer(CDataUtil.genRandomNumber()).toString();
                props.setProperty(id, name);
                this.fIsMapInfoDirty = true;
            }
        } else if (op == 2) {
            props.remove(id);
            this.fIsMapInfoDirty = true;
        }
        return name;
    }

    private File getFileForCfg(String id, boolean create) {
        String name = this.getFileName(id, create ? 1 : 0);
        if (name == null) {
            return null;
        }
        IPath path = BuildStateManager.getInstance().getPrefsDirPath(this.fProject);
        path = path.append(name);
        return path.toFile();
    }

    private void saveMapFile() {
        if (this.fCfgIdToFileNameProps == null) {
            return;
        }
        File file = this.getMapFile();
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try {
            FileOutputStream oStream = new FileOutputStream(file);
            this.fCfgIdToFileNameProps.store(oStream, "");
            ((OutputStream)oStream).close();
        }
        catch (FileNotFoundException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        catch (IOException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    private File getMapFile() {
        IPath path = BuildStateManager.getInstance().getPrefsDirPath(this.fProject);
        path = path.append(this.getProjFileName());
        File file = path.toFile();
        return file;
    }

    private Properties getIdToNameProperties() {
        if (this.fCfgIdToFileNameProps == null) {
            this.fCfgIdToFileNameProps = new Properties();
            File file = this.getMapFile();
            if (file.exists()) {
                try {
                    FileInputStream iStream = new FileInputStream(file);
                    this.fCfgIdToFileNameProps.load(iStream);
                    ((InputStream)iStream).close();
                }
                catch (FileNotFoundException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                catch (IOException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            }
        }
        return this.fCfgIdToFileNameProps;
    }

    private String getProjFileName() {
        return this.fProject.getName();
    }

    public IProject getProject() {
        return this.fProject;
    }

    void serialize() {
        for (ConfigurationBuildState s : this.fCfgIdToStateMap.values()) {
            File file;
            String id = s.getConfigurationId();
            if (!s.exists()) {
                file = this.getFileForCfg(id, false);
                if (file == null || !file.exists()) continue;
                file.delete();
                this.getFileName(id, 2);
                continue;
            }
            file = this.getFileForCfg(id, true);
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try {
                FileOutputStream oStream = new FileOutputStream(file);
                s.store(oStream);
                oStream.close();
            }
            catch (FileNotFoundException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        if (this.fIsMapInfoDirty) {
            this.saveMapFile();
        }
    }
}

