/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.buildmodel.IStepVisitor;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.GenDirInfo;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IBuildModelBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IResourceRebuildStateContainer;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.StepBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DescriptionBuilder
implements IBuildModelBuilder {
    private static final String BUILDER_MSG_HEADER = "InternalBuilder.msg.header";
    private static final String BUILDER_NOTHING_TODO = "InternalBuilder.nothing.todo";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private IBuildDescription fDes;
    private IPath fCWD;
    private boolean fBuildIncrementaly;
    private boolean fResumeOnErrs;
    private Map fStepToStepBuilderMap = new HashMap();
    private int fNumCommands = -1;
    private GenDirInfo fDir;
    private IResourceRebuildStateContainer fRebuildStateContainer;

    public DescriptionBuilder(IBuildDescription des, IResourceRebuildStateContainer rs) {
        this(des, true, rs);
    }

    public DescriptionBuilder(IBuildDescription des, boolean buildIncrementaly, IResourceRebuildStateContainer rs) {
        this(des, buildIncrementaly, true, rs);
    }

    public DescriptionBuilder(IBuildDescription des, boolean buildIncrementaly, boolean resumeOnError, IResourceRebuildStateContainer rs) {
        this(des, buildIncrementaly, resumeOnError, null, rs);
    }

    public DescriptionBuilder(IBuildDescription des, boolean buildIncrementaly, boolean resumeOnErrs, IPath cwd, IResourceRebuildStateContainer rs) {
        this.fDes = des;
        this.fCWD = cwd;
        this.fBuildIncrementaly = buildIncrementaly;
        this.fResumeOnErrs = resumeOnErrs;
        this.fDir = new GenDirInfo(this.fDes.getConfiguration());
        if (this.fCWD == null) {
            this.fCWD = this.fDes.getDefaultBuildDirLocation();
        }
        this.fRebuildStateContainer = rs;
    }

    public int build(OutputStream out, OutputStream err, IProgressMonitor monitor) {
        this.initRebuildStates();
        int num = this.getNumCommands();
        int status = 0;
        monitor.beginTask("", num > 0 ? num : 1);
        monitor.subTask("");
        if (num > 0) {
            BuildStepVisitor visitor = new BuildStepVisitor(out, err, monitor);
            try {
                BuildDescriptionManager.accept(visitor, this.fDes, true);
            }
            catch (CoreException coreException) {
                status = -2;
            }
            if (status == 0) {
                status = visitor.fStatus;
            }
        } else {
            this.printMessage(ManagedMakeMessages.getFormattedString(BUILDER_NOTHING_TODO, this.fDes.getConfiguration().getOwner().getName()), out);
        }
        monitor.done();
        if (status == 0) {
            this.clearRebuildStates();
        }
        return status;
    }

    public int getNumCommands() {
        if (this.fNumCommands == -1) {
            this.fNumCommands = 0;
            BuildStepVisitor visitor = new BuildStepVisitor(null, null, (IProgressMonitor)new NullProgressMonitor(), false);
            try {
                BuildDescriptionManager.accept(visitor, this.fDes, true);
            }
            catch (CoreException coreException) {}
            if (DbgUtil.DEBUG) {
                DbgUtil.trace("Description Builder: total work = " + this.fNumCommands);
            }
        }
        return this.fNumCommands;
    }

    protected StepBuilder getStepBuilder(IBuildStep step) {
        StepBuilder b = (StepBuilder)this.fStepToStepBuilderMap.get(step);
        if (b == null) {
            b = new StepBuilder(step, this.fCWD, this.fResumeOnErrs, this.fDir, this.fRebuildStateContainer);
            this.fStepToStepBuilderMap.put(step, b);
        }
        return b;
    }

    protected void printMessage(String msg, OutputStream os) {
        if (os != null) {
            msg = String.valueOf(ManagedMakeMessages.getFormattedString(BUILDER_MSG_HEADER, msg)) + LINE_SEPARATOR;
            try {
                os.write(msg.getBytes());
                os.flush();
            }
            catch (IOException iOException) {}
        }
    }

    private void initRebuildStates() {
        if (this.fRebuildStateContainer == null) {
            return;
        }
        this.fRebuildStateContainer.setState(0);
        IBuildResource[] rcs = this.fDes.getResources();
        DescriptionBuilder.putAll(this.fRebuildStateContainer, rcs, 1, true);
    }

    private void clearRebuildStates() {
        if (this.fRebuildStateContainer == null) {
            return;
        }
        this.fRebuildStateContainer.setState(0);
    }

    static void putAll(IResourceRebuildStateContainer cbs, IBuildResource[] rcs, int state, boolean rebuildRcOnly) {
        int i = 0;
        while (i < rcs.length) {
            IPath fullPath;
            IBuildResource rc = rcs[i];
            if ((!rebuildRcOnly || rc.needsRebuild()) && rc.isProjectResource() && (fullPath = rc.getFullPath()) != null) {
                cbs.setStateForFullPath(fullPath, state);
            }
            ++i;
        }
    }

    private class BuildStepVisitor
    implements IStepVisitor {
        private OutputStream fOut;
        private OutputStream fErr;
        private IProgressMonitor fMonitor;
        private int fStatus;
        private boolean fBuild;

        public BuildStepVisitor(OutputStream out, OutputStream err, IProgressMonitor monitor) {
            this(out, err, monitor, true);
        }

        public BuildStepVisitor(OutputStream out, OutputStream err, IProgressMonitor monitor, boolean build) {
            this.fOut = out;
            this.fErr = err;
            this.fMonitor = monitor;
            this.fStatus = 0;
            this.fBuild = build;
        }

        public int visit(IBuildStep action) throws CoreException {
            if (this.fMonitor.isCanceled()) {
                return 2;
            }
            if (DbgUtil.DEBUG) {
                DbgUtil.trace("visiting step " + DbgUtil.stepName(action));
            }
            if (!(action.isRemoved() || DescriptionBuilder.this.fBuildIncrementaly && !action.needsRebuild())) {
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace("step " + DbgUtil.stepName(action) + " needs rebuild");
                }
                StepBuilder builder = DescriptionBuilder.this.getStepBuilder(action);
                if (this.fBuild) {
                    switch (builder.build(this.fOut, this.fErr, (IProgressMonitor)new SubProgressMonitor(this.fMonitor, builder.getNumCommands()))) {
                        case 0: {
                            break;
                        }
                        case -3: {
                            this.fStatus = -3;
                            break;
                        }
                        default: {
                            this.fStatus = -1;
                            break;
                        }
                    }
                } else {
                    DescriptionBuilder descriptionBuilder = DescriptionBuilder.this;
                    descriptionBuilder.fNumCommands = descriptionBuilder.fNumCommands + builder.getNumCommands();
                }
            }
            if (this.fStatus != -3 && (DescriptionBuilder.this.fResumeOnErrs || this.fStatus == 0)) {
                return 1;
            }
            return 2;
        }
    }
}

