/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.eclipse.cdt.examples.dsf.timers.AlarmService;
import org.eclipse.cdt.examples.dsf.timers.TriggerCellModifier;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

class TriggersVMNode
extends AbstractDMVMNode
implements IElementEditor,
IElementPropertiesProvider,
IElementLabelProvider {
    private static final String PROP_TRIGGER_NUMBER = "alarmNumber";
    private static final String PROP_TRIGGER_VALUE = "alarmTriggerValue";
    private static final PropertiesBasedLabelProvider fgLabelProvider = new PropertiesBasedLabelProvider();
    private TriggerCellModifier fAlarmCellModifier;

    static {
        LabelColumnInfo idCol = new LabelColumnInfo(new LabelAttribute[]{new LabelText("Trigger #{0}", new String[]{PROP_TRIGGER_NUMBER}), new LabelImage(DsfExamplesPlugin.getDefault().getImageRegistry().getDescriptor("icons/alarm.gif"))});
        fgLabelProvider.setColumnInfo("org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_ID", idCol);
        LabelColumnInfo valueCol = new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0}", new String[]{PROP_TRIGGER_VALUE})});
        fgLabelProvider.setColumnInfo("org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_VALUE", valueCol);
    }

    public TriggersVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, AlarmService.TriggerDMContext.class);
    }

    public String toString() {
        return "TriggersVMNode(" + this.getSession().getId() + ")";
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        AlarmService alarmService = (AlarmService)((Object)this.getServicesTracker().getService(AlarmService.class, null));
        if (alarmService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        AlarmService.TriggerDMContext[] triggers = alarmService.getTriggers();
        this.fillUpdateWithVMCs(update, (IDMContext[])triggers);
        update.done();
    }

    public void update(ILabelUpdate[] updates) {
        fgLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
                        int n = updates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
                            TriggersVMNode.this.updatePropertiesInSessionThread(update);
                            ++n2;
                        }
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException v0) {
                var5_2 = updates;
                var4_3 = updates.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                update = var5_2[var3_4];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++var3_4;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession#getExecutor")
    private void updatePropertiesInSessionThread(IPropertiesUpdate update) {
        AlarmService.TriggerDMContext triggerCtx = (AlarmService.TriggerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), AlarmService.TriggerDMContext.class);
        AlarmService alarmService = (AlarmService)((Object)this.getServicesTracker().getService(AlarmService.class, null));
        if (triggerCtx == null || alarmService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        int value = alarmService.getTriggerValue(triggerCtx);
        if (value == -1) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setProperty(PROP_TRIGGER_NUMBER, (Object)triggerCtx.getTriggerNumber());
        update.setProperty(PROP_TRIGGER_VALUE, (Object)value);
        update.done();
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_VALUE".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        if (this.fAlarmCellModifier == null) {
            this.fAlarmCellModifier = new TriggerCellModifier(this.getSession());
        }
        return this.fAlarmCellModifier;
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof AlarmService.TriggersChangedEvent) {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof AlarmService.TriggersChangedEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        requestMonitor.done();
    }

    public void dispose() {
        if (this.fAlarmCellModifier != null) {
            this.fAlarmCellModifier.dispose();
        }
        super.dispose();
    }
}

