/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.util.HashSet;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ITextEditor;

public class CElementContentProvider
extends BaseCElementContentProvider
implements IElementChangedListener,
IInformationProvider,
IInformationProviderExtension {
    protected ITextEditor fEditor;
    protected StructuredViewer fViewer;
    protected Object fInput;
    protected HashSet<IRefreshable> pendingRefreshes = new HashSet();

    public CElementContentProvider() {
    }

    public CElementContentProvider(ITextEditor editor) {
        this.fEditor = editor;
    }

    public CElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        super(provideMembers, provideWorkingCopy);
    }

    public void dispose() {
        super.dispose();
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (StructuredViewer)viewer;
        if (oldInput == null && newInput != null) {
            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
            e.printStackTrace();
        }
    }

    protected boolean isPathEntryChange(ICElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && ((flags & 0x800000) != 0 || (flags & 0x1000) != 0 || (flags & 0x100) != 0 || (flags & 0x2000) != 0 || (flags & 0x40000) != 0 || (flags & 0x200) != 0 || (flags & 0x800) != 0);
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        ICElementDelta[] affectedChildren;
        Object parent;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        ICElement element = delta.getElement();
        if ((flags & 0x80) != 0 || (flags & 0x40) != 0) {
            this.postRefresh(element);
            return;
        }
        if (element instanceof ITranslationUnit) {
            ITranslationUnit unit = (ITranslationUnit)element;
            if (unit.isWorkingCopy() && (!this.getProvideWorkingCopy() || kind == 2 || kind == 1)) {
                return;
            }
            if (!this.getProvideMembers() && kind == 4) {
                return;
            }
        }
        if (kind == 2) {
            this.postRemove(element);
            this.updateContainer(element);
            return;
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            this.postAdd(parent, element);
            this.updateContainer(element);
        }
        if (kind == 4) {
            if (this.updateContainer(element)) {
                parent = this.getParent(element);
                this.postRefresh(parent);
                return;
            }
            if (element instanceof ITranslationUnit) {
                this.postRefresh(element);
                return;
            }
            if (element instanceof ArchiveContainer || element instanceof BinaryContainer) {
                this.postContainerRefresh((IParent)element, element.getCProject());
            }
        }
        if (this.isPathEntryChange(delta)) {
            this.postRefresh(element.getCProject());
            return;
        }
        if (this.processResourceDeltas(delta.getResourceDeltas(), element)) {
            return;
        }
        ICElementDelta[] iCElementDeltaArray = affectedChildren = delta.getAffectedChildren();
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICElementDelta element2 = iCElementDeltaArray[n2];
            this.processDelta(element2);
            ++n2;
        }
    }

    private boolean processResourceDeltas(IResourceDelta[] deltas, Object parent) {
        if (deltas == null) {
            return false;
        }
        if (deltas.length > 1 && !(parent instanceof ICModel)) {
            this.postRefresh(parent);
            return true;
        }
        IResourceDelta[] iResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            if (this.processResourceDelta(delta, parent)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent) {
        int flags;
        int status = delta.getKind();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            this.postRemove(resource);
        }
        if ((status & 1) != 0) {
            this.postAdd(parent, resource);
        }
        if (((flags = delta.getFlags()) & 0x4000) != 0) {
            this.postProjectStateChanged(parent);
            return true;
        }
        this.processResourceDeltas(delta.getAffectedChildren(), resource);
        return false;
    }

    private boolean updateContainer(ICElement cfile) throws CModelException {
        IArchiveContainer container = null;
        ICProject cproject = null;
        if (cfile instanceof IBinary) {
            IBinary bin = (IBinary)cfile;
            if (bin.showInBinaryContainer()) {
                cproject = bin.getCProject();
                container = cproject.getBinaryContainer();
            }
        } else if (cfile instanceof IArchive) {
            cproject = cfile.getCProject();
            container = cproject.getArchiveContainer();
        }
        if (container != null) {
            this.postContainerRefresh((IParent)container, cproject);
            return true;
        }
        return false;
    }

    protected void postContainerRefresh(IParent container, ICProject cproject) {
        this.postRefreshable(new RefreshContainer(container, cproject));
    }

    protected void postRefresh(Object element) {
        this.postRefreshable(new RefreshElement(element));
    }

    protected void postAdd(Object parent, Object element) {
        this.postRefreshable(new RefreshElement(parent));
    }

    protected void postRemove(Object element) {
        this.postRefreshable(new RefreshElement(this.internalGetParent(element)));
    }

    protected void postProjectStateChanged(Object root) {
        this.postRefreshable(new RefreshProjectState(root));
    }

    protected final void postRefreshable(final IRefreshable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            if (this.pendingRefreshes.contains(r)) {
                return;
            }
            this.pendingRefreshes.add(r);
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CElementContentProvider.this.pendingRefreshes.remove(r);
                    Control ctrl = CElementContentProvider.this.fViewer.getControl();
                    if (ctrl != null && !ctrl.isDisposed()) {
                        r.refresh();
                    }
                }
            });
        }
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fEditor != null) {
            IRegion region = CWordFinder.findWord(textViewer.getDocument(), offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        Object info = this.getInformation2(textViewer, subject);
        if (info != null) {
            return info.toString();
        }
        return null;
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.fEditor == null) {
            return null;
        }
        try {
            ICElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                return element;
            }
            return SelectionConverter.getInput(this.fEditor);
        }
        catch (CModelException cModelException) {
            return null;
        }
    }

    protected static interface IRefreshable {
        public void refresh();
    }

    protected final class RefreshContainer
    implements IRefreshable {
        private IParent container;
        private Object project;

        public RefreshContainer(IParent container, Object project) {
            this.container = container;
            this.project = project;
        }

        public void refresh() {
            if (this.container.hasChildren()) {
                if (CElementContentProvider.this.fViewer.testFindItem((Object)this.container) != null) {
                    CElementContentProvider.this.fViewer.refresh((Object)this.container);
                } else {
                    CElementContentProvider.this.fViewer.refresh(this.project);
                }
            } else {
                CElementContentProvider.this.fViewer.refresh(this.project);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof RefreshContainer) {
                RefreshContainer c = (RefreshContainer)o;
                return c.container.equals(this.container) && c.project.equals(this.project);
            }
            return false;
        }

        public int hashCode() {
            return this.container.hashCode() * 10903143 + 31181;
        }
    }

    protected final class RefreshElement
    implements IRefreshable {
        private Object element;

        public RefreshElement(Object element) {
            this.element = element;
        }

        public void refresh() {
            if (this.element instanceof IWorkingCopy) {
                if (CElementContentProvider.this.fViewer.testFindItem(this.element) != null) {
                    CElementContentProvider.this.fViewer.refresh(this.element);
                } else {
                    CElementContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)this.element).getOriginalElement());
                }
            } else if (this.element instanceof IBinary) {
                CElementContentProvider.this.fViewer.refresh(this.element, true);
            } else {
                CElementContentProvider.this.fViewer.refresh(this.element);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof RefreshElement) {
                RefreshElement c = (RefreshElement)o;
                return c.element.equals(this.element);
            }
            return false;
        }

        public int hashCode() {
            return this.element.hashCode() * 7 + 490487;
        }
    }

    protected final class RefreshProjectState
    implements IRefreshable {
        private Object element;

        public RefreshProjectState(Object element) {
            this.element = element;
        }

        public void refresh() {
            CElementContentProvider.this.fViewer.refresh(this.element, true);
            CElementContentProvider.this.fViewer.setSelection(CElementContentProvider.this.fViewer.getSelection());
        }

        public boolean equals(Object o) {
            if (o instanceof RefreshElement) {
                RefreshElement c = (RefreshElement)o;
                return c.element.equals(this.element);
            }
            return false;
        }

        public int hashCode() {
            return this.element.hashCode() * 11 + 490487;
        }
    }
}

