/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfigurationController;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectConfigurationController
implements IWorkingSetProjectConfigurationController {
    private IWorkingSetProjectConfiguration.ISnapshot config;

    public ProjectConfigurationController(IWorkingSetProjectConfiguration.ISnapshot config) {
        this.config = config;
    }

    public IWorkingSetProjectConfiguration.ISnapshot getProjectConfiguration() {
        return this.config;
    }

    public void checkStateChanged(Object element, boolean checked, IWorkingSetProjectConfigurationController.IControllerContext context) {
        if (!context.isReadOnly() && element instanceof ICConfigurationDescription) {
            boolean newActive;
            ICConfigurationDescription newSel = (ICConfigurationDescription)element;
            ICConfigurationDescription oldSel = this.getProjectConfiguration().resolveSelectedConfiguration();
            boolean oldActive = this.getProjectConfiguration().isActive();
            if (checked) {
                if (newSel != oldSel) {
                    this.getProjectConfiguration().setSelectedConfigurationID(newSel.getId());
                    if (oldSel != null) {
                        context.setChecked(oldSel, false);
                    }
                }
            } else if (newSel == oldSel) {
                context.setChecked(oldSel, true);
            }
            if (oldActive != (newActive = this.getProjectConfiguration().isActive())) {
                context.activationStateChanged(this.getProjectConfiguration());
            }
        } else {
            context.setChecked(element, !checked);
        }
    }

    public void updateCheckState(IWorkingSetProjectConfigurationController.IControllerContext context) {
        ICConfigurationDescription sel = this.getProjectConfiguration().resolveSelectedConfiguration();
        if (sel != null) {
            context.setChecked(sel, true);
        }
        context.setGrayed(this.getProjectConfiguration(), true);
    }

    public ITreeContentProvider getContentProvider() {
        return new ContentProvider(this.getProjectConfiguration());
    }

    public ILabelProvider getLabelProvider(Viewer viewer) {
        return new LabelProvider(viewer, this.getProjectConfiguration());
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_OBJECTS = new Object[0];
        private IWorkingSetProjectConfiguration project;
        private Set<ICConfigurationDescription> configs;

        ContentProvider(IWorkingSetProjectConfiguration project) {
            this.project = project;
            this.configs = new HashSet<ICConfigurationDescription>(project.resolveConfigurations());
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement == this.project ? this.project.resolveConfigurations().toArray() : NO_OBJECTS;
        }

        public Object getParent(Object element) {
            return element == this.project ? null : (this.configs.contains(element) ? this.project : null);
        }

        public boolean hasChildren(Object element) {
            return element == this.project;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{this.project};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements IFontProvider {
        private IWorkingSetProjectConfiguration.ISnapshot projectConfig;
        private WorkbenchLabelProvider wbLabels = new WorkbenchLabelProvider();
        private Image configImage = CPluginImages.get("org.eclipse.cdt.ui.config.gif");
        private Font defaultFont;
        private ResourceManager fonts = new LocalResourceManager(JFaceResources.getResources());

        LabelProvider(Viewer viewer, IWorkingSetProjectConfiguration.ISnapshot projectConfig) {
            this.projectConfig = projectConfig;
            this.defaultFont = viewer.getControl().getFont();
        }

        public String getText(Object element) {
            if (element instanceof ICConfigurationDescription) {
                ICConfigurationDescription config = (ICConfigurationDescription)element;
                return this.isActiveInWorkspace(config) ? NLS.bind((String)WorkingSetMessages.ProjConfigController_activeConfig, (Object)config.getName()) : config.getName();
            }
            if (element instanceof IWorkingSetProjectConfiguration) {
                return this.wbLabels.getText((Object)((IWorkingSetProjectConfiguration)element).resolveProject());
            }
            return this.wbLabels.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ICConfigurationDescription) {
                return this.configImage;
            }
            if (element instanceof IWorkingSetProjectConfiguration) {
                return this.wbLabels.getImage((Object)((IWorkingSetProjectConfiguration)element).resolveProject());
            }
            return this.wbLabels.getImage(element);
        }

        public Font getFont(Object element) {
            ICConfigurationDescription config;
            if (element instanceof ICConfigurationDescription && this.isActiveInWorkspace(config = (ICConfigurationDescription)element)) {
                FontDescriptor desc = FontDescriptor.createFrom((Font)this.defaultFont);
                return (Font)this.fonts.get((DeviceResourceDescriptor)desc.withStyle(1));
            }
            return this.wbLabels.getFont(element);
        }

        private boolean isActiveInWorkspace(ICConfigurationDescription config) {
            WorkspaceSnapshot workspace = this.projectConfig.getWorkspaceSnapshot();
            return workspace.getState(this.projectConfig.resolveProject()).isActive(config.getId());
        }

        public void dispose() {
            this.wbLabels.dispose();
            this.fonts.dispose();
            super.dispose();
        }
    }
}

