/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildJob
extends Job {
    private Collection<IProject> projects;
    private IWorkingSetConfiguration workingSetConfig;

    public BuildJob(Collection<IProject> projects) {
        super(UIMessages.getString("WorkingSetConfigAction.21"));
        this.projects = new ArrayList<IProject>(projects);
    }

    public BuildJob(IWorkingSetConfiguration workingSetConfig) {
        super(UIMessages.getString("WorkingSetConfigAction.21"));
        this.workingSetConfig = workingSetConfig;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.projects != null) {
            return this.buildProjects(monitor);
        }
        return this.buildWorkingSetConfig(monitor);
    }

    private IStatus buildProjects(IProgressMonitor monitor) {
        try {
            for (IProject p : this.projects) {
                try {
                    this.setName(String.valueOf(UIMessages.getString("WorkingSetConfigAction.21")) + p.getName());
                    p.build(10, monitor);
                }
                catch (CoreException e) {
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.cdt.ui", 0, new IStatus[]{e.getStatus()}, UIMessages.getString("WorkingSetConfigAction.22"), null);
                    monitor.done();
                    return multiStatus;
                }
                if (!monitor.isCanceled()) continue;
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus buildWorkingSetConfig(IProgressMonitor monitor) {
        try {
            IStatus iStatus = this.workingSetConfig.build(monitor);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public boolean belongsTo(Object family) {
        return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
    }
}

