/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.settingswizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IProjectSettingsWizardPage;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IProjectSettingsWizardPageStrategy;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.ISettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IncludePathsSettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.MacroSettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.Messages;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.ProjectSettingsExportStrategy;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.ProjectSettingsImportStrategy;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectSettingsWizardPage
extends WizardPage
implements IProjectSettingsWizardPage {
    public static final String FILENAME_EXTENSION = "xml";
    private final IProjectSettingsWizardPageStrategy strategy;
    private final List<ISettingsProcessor> processors;
    private ICProject selectedProject;
    private ICConfigurationDescription selectedConfiguration;
    private Text filePathText;
    private CheckboxTableViewer settingsViewer;
    private IProject initialProject;

    private ProjectSettingsWizardPage(IProjectSettingsWizardPageStrategy strategy) {
        super("");
        this.strategy = strategy;
        this.processors = Arrays.asList(new IncludePathsSettingsProcessor(), new MacroSettingsProcessor());
    }

    protected abstract void layoutPage(Composite var1);

    public static ProjectSettingsWizardPage createExportWizardPage() {
        return new ProjectSettingsWizardPage(new ProjectSettingsExportStrategy()){

            public void layoutPage(Composite parent) {
                this.createProjectSelectionGroup(parent);
                this.createSettingsSelectionGroup(parent);
                this.createFileSelectionGroup(parent);
            }
        };
    }

    public static ProjectSettingsWizardPage createImportWizardPage() {
        return new ProjectSettingsWizardPage(new ProjectSettingsImportStrategy()){

            public void layoutPage(Composite parent) {
                this.createFileSelectionGroup(parent);
                this.createProjectSelectionGroup(parent);
                this.createSettingsSelectionGroup(parent);
            }
        };
    }

    public boolean finish() {
        return this.strategy.finish(this);
    }

    public void setInitialProject(IProject project) {
        this.initialProject = project;
    }

    @Override
    public List<ISettingsProcessor> getSettingsProcessors() {
        return Collections.unmodifiableList(this.processors);
    }

    @Override
    public List<ISettingsProcessor> getSelectedSettingsProcessors() {
        ArrayList<ISettingsProcessor> selected = new ArrayList<ISettingsProcessor>();
        Object[] objectArray = this.settingsViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            selected.add((ISettingsProcessor)element);
            ++n2;
        }
        return selected;
    }

    @Override
    public String getDestinationFilePath() {
        return this.filePathText.getText();
    }

    public ICProject getSelectedProject() {
        return this.selectedProject;
    }

    @Override
    public ICConfigurationDescription getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    @Override
    public void setDisplayedSettingsProcessors(List<ISettingsProcessor> processors) {
        this.settingsViewer.setInput(processors);
        this.settingsViewer.refresh();
    }

    @Override
    public void showErrorDialog(String dialogTitle, String message) {
        Shell shell = Display.getCurrent().getActiveShell();
        Status status = new Status(4, "org.eclipse.cdt.ui", 0, message, null);
        ErrorDialog.openError((Shell)shell, (String)dialogTitle, null, (IStatus)status);
    }

    public void createControl(Composite parent) {
        this.setTitle(this.strategy.getMessage(IProjectSettingsWizardPageStrategy.MessageType.TITLE));
        this.setMessage(this.strategy.getMessage(IProjectSettingsWizardPageStrategy.MessageType.MESSAGE));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.layoutPage(composite);
        this.setControl((Control)composite);
        this.strategy.pageCreated(this);
        this.updateWidgetEnablements();
    }

    private void updateWidgetEnablements() {
        boolean enableFinishButton = this.selectedProject != null && this.selectedConfiguration != null && this.settingsViewer.getCheckedElements().length > 0 && this.filePathText.getText().length() > 0;
        this.setPageComplete(enableFinishButton);
    }

    protected void createProjectSelectionGroup(Composite parent) {
        Composite projectSelectionGroup = new Composite(parent, 0);
        projectSelectionGroup.setLayout((Layout)new GridLayout(2, true));
        projectSelectionGroup.setLayoutData((Object)new GridData(1808));
        projectSelectionGroup.setFont(parent.getFont());
        Label projectLabel = new Label(projectSelectionGroup, 0);
        projectLabel.setText(Messages.ProjectSettingsWizardPage_selectProject);
        projectLabel.setLayoutData((Object)new GridData());
        Label configLabel = new Label(projectSelectionGroup, 0);
        configLabel.setText(Messages.ProjectSettingsWizardPage_selectConfiguration);
        configLabel.setLayoutData((Object)new GridData());
        final Table projectTable = new Table(projectSelectionGroup, 2052);
        projectTable.setLayoutData((Object)new GridData(1808));
        TableViewer projectViewer = new TableViewer(projectTable);
        projectViewer.setContentProvider((IContentProvider)new ListContentProvider());
        projectViewer.setLabelProvider((IBaseLabelProvider)new CElementLabelProvider());
        List<ICProject> openProjects = ProjectSettingsWizardPage.getAllOpenCProjects();
        projectViewer.setInput(openProjects);
        final Table configTable = new Table(projectSelectionGroup, 2052);
        configTable.setLayoutData((Object)new GridData(1808));
        final TableViewer configViewer = new TableViewer(configTable);
        configViewer.setContentProvider((IContentProvider)new ListContentProvider());
        configViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ICConfigurationDescription)element).getName();
            }
        });
        projectTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = projectTable.getSelection();
                ProjectSettingsWizardPage.this.selectedProject = (ICProject)items[0].getData();
                ProjectSettingsWizardPage.this.selectedConfiguration = null;
                configViewer.setInput((Object)ProjectSettingsWizardPage.getConfigurations(ProjectSettingsWizardPage.this.selectedProject));
                configViewer.refresh();
                ProjectSettingsWizardPage.this.updateWidgetEnablements();
            }
        });
        configTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = configTable.getSelection();
                ProjectSettingsWizardPage.this.selectedConfiguration = (ICConfigurationDescription)items[0].getData();
                ProjectSettingsWizardPage.this.updateWidgetEnablements();
            }
        });
        if (this.initialProject != null) {
            String initialProjectName = this.initialProject.getName();
            int i = 0;
            while (i < openProjects.size()) {
                ICProject tableProject = openProjects.get(i);
                if (tableProject.getElementName().equals(initialProjectName)) {
                    projectTable.select(i);
                    configViewer.setInput(ProjectSettingsWizardPage.getConfigurations(tableProject));
                    configViewer.refresh();
                    this.selectedProject = tableProject;
                    break;
                }
                ++i;
            }
        }
    }

    private static List<ICConfigurationDescription> getConfigurations(ICProject project) {
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(project.getProject(), false);
        return Arrays.asList(description.getConfigurations());
    }

    private static List<ICProject> getAllOpenCProjects() {
        ArrayList<ICProject> projects = new ArrayList<ICProject>();
        try {
            ICProject[] iCProjectArray = CoreModel.getDefault().getCModel().getCProjects();
            int n = iCProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICProject project = iCProjectArray[n2];
                if (project.getProject().isOpen()) {
                    projects.add(project);
                }
                ++n2;
            }
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
        return projects;
    }

    protected void createSettingsSelectionGroup(Composite parent) {
        Composite settingsSelectionGroup = new Composite(parent, 0);
        settingsSelectionGroup.setLayout((Layout)new GridLayout());
        settingsSelectionGroup.setLayoutData((Object)new GridData(1808));
        settingsSelectionGroup.setFont(parent.getFont());
        Label label = new Label(settingsSelectionGroup, 0);
        label.setText(this.strategy.getMessage(IProjectSettingsWizardPageStrategy.MessageType.SETTINGS));
        Table table = new Table(settingsSelectionGroup, 2080);
        table.setLayoutData((Object)new GridData(1808));
        this.settingsViewer = new CheckboxTableViewer(table);
        this.settingsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.settingsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSettingsWizardPage.this.updateWidgetEnablements();
            }
        });
        LabelProvider settingsProcessorLabelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return ((ISettingsProcessor)element).getIcon();
            }

            public String getText(Object element) {
                return ((ISettingsProcessor)element).getDisplayName();
            }
        };
        this.settingsViewer.setLabelProvider((IBaseLabelProvider)settingsProcessorLabelProvider);
        this.settingsViewer.setInput(this.processors);
        Composite buttonComposite = new Composite(settingsSelectionGroup, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData());
        Button selectButton = new Button(buttonComposite, 8);
        selectButton.setLayoutData((Object)new GridData(768));
        selectButton.setText(Messages.ProjectSettingsWizardPage_selectAll);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSettingsWizardPage.this.settingsViewer.setAllChecked(true);
                ProjectSettingsWizardPage.this.updateWidgetEnablements();
            }
        });
        Button deselectButton = new Button(buttonComposite, 8);
        deselectButton.setLayoutData((Object)new GridData(768));
        deselectButton.setText(Messages.ProjectSettingsWizardPage_deselectAll);
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSettingsWizardPage.this.settingsViewer.setAllChecked(false);
                ProjectSettingsWizardPage.this.updateWidgetEnablements();
            }
        });
    }

    protected void createFileSelectionGroup(Composite parent) {
        Composite fileSelectionGroup = new Composite(parent, 0);
        fileSelectionGroup.setLayout((Layout)new GridLayout(2, false));
        fileSelectionGroup.setLayoutData((Object)new GridData(768));
        fileSelectionGroup.setFont(parent.getFont());
        Label label = new Label(fileSelectionGroup, 0);
        label.setText(this.strategy.getMessage(IProjectSettingsWizardPageStrategy.MessageType.FILE));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.filePathText = new Text(fileSelectionGroup, 2052);
        this.filePathText.setLayoutData((Object)new GridData(768));
        this.filePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectSettingsWizardPage.this.updateWidgetEnablements();
                ProjectSettingsWizardPage.this.strategy.fileSelected(ProjectSettingsWizardPage.this);
            }
        });
        Button browseButton = new Button(fileSelectionGroup, 8);
        browseButton.setText(Messages.ProjectSettingsWizardPage_browse);
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ProjectSettingsWizardPage.this.getShell(), 8192);
                fileDialog.setFilterExtensions(new String[]{"*.xml"});
                String filePath = fileDialog.open();
                if (filePath != null) {
                    ProjectSettingsWizardPage.this.filePathText.setText(filePath);
                }
            }
        });
    }

    /* synthetic */ ProjectSettingsWizardPage(IProjectSettingsWizardPageStrategy iProjectSettingsWizardPageStrategy, ProjectSettingsWizardPage projectSettingsWizardPage) {
        this(iProjectSettingsWizardPageStrategy);
    }
}

