/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexChangeEvent;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.IIndexerStateEvent;
import org.eclipse.cdt.core.index.IIndexerStateListener;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.viewsupport.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

class IndexedFilesCache
implements IIndexChangeListener,
IIndexerStateListener,
ILabelProviderListener {
    private static final String DECORATOR_ID = "org.eclipse.cdt.ui.indexedFiles";
    private static final IndexedFilesCache INSTANCE = new IndexedFilesCache();
    private static final ISchedulingRule RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final HashMap<String, Set<Integer>> fIndexedFiles = new HashMap();
    private boolean fIsDirty = false;
    private boolean fActive = false;

    IndexedFilesCache() {
    }

    public static IndexedFilesCache getInstance() {
        return INSTANCE;
    }

    private void scheduleInitialize() {
        Job j = new Job(Messages.IndexedFilesCache_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ICProject[] prj;
                    ICProject[] iCProjectArray = prj = CoreModel.getDefault().getCModel().getCProjects();
                    int n = prj.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICProject project = iCProjectArray[n2];
                        IndexedFilesCache.this.initialize(project);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return Status.CANCEL_STATUS;
                }
                IndexedFilesCache.this.checkTriggerDecorator(1);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == IndexedFilesCache.this;
            }
        };
        j.setSystem(true);
        j.setRule(RULE);
        j.schedule();
    }

    private void scheduleInitialize(final ICProject project) {
        Job j = new Job(Messages.IndexedFilesCache_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IndexedFilesCache.this.initialize(project);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return Status.CANCEL_STATUS;
                }
                IndexedFilesCache.this.checkTriggerDecorator(1);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == IndexedFilesCache.this;
            }
        };
        j.setSystem(true);
        j.setRule(RULE);
        j.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialize(ICProject prj) throws CoreException, InterruptedException {
        block12: {
            IIndex index = CCorePlugin.getIndexManager().getIndex(prj, 0);
            ArrayList<IIndexFileLocation> list = new ArrayList<IIndexFileLocation>();
            index.acquireReadLock();
            try {
                IIndexFile[] files;
                IIndexFile[] iIndexFileArray = files = index.getAllFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFile ifile = iIndexFileArray[n2];
                    if (ifile.getTimestamp() >= 0L) {
                        list.add(ifile.getLocation());
                    }
                    ++n2;
                }
                if (list.isEmpty()) break block12;
                String prjName = prj.getElementName();
                HashMap<String, Set<Integer>> hashMap = this.fIndexedFiles;
                synchronized (hashMap) {
                    Set<Integer> cache = this.fIndexedFiles.get(prjName);
                    if (cache == null) {
                        cache = new HashSet<Integer>();
                        this.fIndexedFiles.put(prjName, cache);
                    } else if (!cache.isEmpty()) {
                        cache.clear();
                        this.fIsDirty = true;
                    }
                    for (IIndexFileLocation ifl : list) {
                        int h = this.computeHash(ifl);
                        if (!cache.add(h)) continue;
                        this.fIsDirty = true;
                    }
                }
            }
            finally {
                index.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexChanged(IIndexChangeEvent e) {
        ICProject cproject = e.getAffectedProject();
        if (cproject == null) {
            return;
        }
        HashMap<String, Set<Integer>> hashMap = this.fIndexedFiles;
        synchronized (hashMap) {
            if (!this.fActive) {
                return;
            }
            if (e.isReloaded()) {
                this.scheduleInitialize(cproject);
            } else {
                String prjName = cproject.getElementName();
                if (e.isCleared() && this.fIndexedFiles.remove(prjName) != null) {
                    this.fIsDirty = true;
                }
                Set filesCleared = e.getFilesCleared();
                Set filesWritten = e.getFilesWritten();
                if (!filesCleared.isEmpty() || !filesWritten.isEmpty()) {
                    int h;
                    Set<Integer> cache = this.fIndexedFiles.get(prjName);
                    if (cache == null) {
                        cache = new HashSet<Integer>();
                        this.fIndexedFiles.put(prjName, cache);
                    }
                    for (IIndexFileLocation ifl : filesCleared) {
                        h = this.computeHash(ifl);
                        if (!cache.remove(h)) continue;
                        this.fIsDirty = true;
                    }
                    for (IIndexFileLocation ifl : filesWritten) {
                        h = this.computeHash(ifl);
                        if (!cache.add(h)) continue;
                        this.fIsDirty = true;
                    }
                }
            }
        }
    }

    public void indexChanged(IIndexerStateEvent event) {
        if (event.indexerIsIdle()) {
            this.checkTriggerDecorator(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate() {
        HashMap<String, Set<Integer>> hashMap = this.fIndexedFiles;
        synchronized (hashMap) {
            this.fActive = true;
            PlatformUI.getWorkbench().getDecoratorManager().addListener((ILabelProviderListener)this);
            IIndexManager indexManager = CCorePlugin.getIndexManager();
            indexManager.addIndexChangeListener((IIndexChangeListener)this);
            indexManager.addIndexerStateListener((IIndexerStateListener)this);
            this.scheduleInitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate() {
        HashMap<String, Set<Integer>> hashMap = this.fIndexedFiles;
        synchronized (hashMap) {
            this.fActive = false;
            this.fIndexedFiles.clear();
            IIndexManager indexManager = CCorePlugin.getIndexManager();
            indexManager.removeIndexChangeListener((IIndexChangeListener)this);
            indexManager.removeIndexerStateListener((IIndexerStateListener)this);
            PlatformUI.getWorkbench().getDecoratorManager().removeListener((ILabelProviderListener)this);
        }
    }

    protected final void checkTriggerDecorator(int jobCount) {
        if (this.fIsDirty && CCorePlugin.getIndexManager().isIndexerIdle() && Job.getJobManager().find((Object)this).length == jobCount) {
            this.fIsDirty = false;
            final IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        workbench.getDecoratorManager().update(IndexedFilesCache.DECORATOR_ID);
                    }
                });
            }
            catch (SWTException sWTException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexed(IProject project, IIndexFileLocation ifl) {
        HashMap<String, Set<Integer>> hashMap = this.fIndexedFiles;
        synchronized (hashMap) {
            if (!this.fActive) {
                this.activate();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
            Set<Integer> cache = this.fIndexedFiles.get(project.getName());
            return cache != null && cache.contains(this.computeHash(ifl));
        }
    }

    private int computeHash(IIndexFileLocation ifl) {
        String fp = ifl.getFullPath();
        int h1 = fp == null ? 0 : fp.hashCode() * 43;
        return h1 + ifl.getURI().hashCode();
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        IDecoratorManager mng;
        Object src = event.getSource();
        if (src instanceof IDecoratorManager && !(mng = (IDecoratorManager)src).getEnabled(DECORATOR_ID)) {
            this.deactivate();
        }
    }
}

