/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.CReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.CompositeReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.cdt.internal.ui.text.spelling.CSpellingReconcileStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CCompositeReconcilingStrategy
extends CompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private CReconcilingStrategy fCStrategy;

    public CCompositeReconcilingStrategy(ISourceViewer viewer, ITextEditor editor, String documentPartitioning) {
        this.fEditor = editor;
        this.fCStrategy = new CReconcilingStrategy(editor);
        this.setReconcilingStrategies(new IReconcilingStrategy[]{this.fCStrategy, new CSpellingReconcileStrategy(viewer, editor)});
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            return null;
        }
        IAnnotationModel m = p.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (m instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)m;
        }
        return null;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(dirtyRegion, subRegion);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(partition);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(partition);
        }
    }

    public void initialReconcile() {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.initialReconcile();
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.initialReconcile();
        }
    }

    public void aboutToBeReconciled() {
        this.fCStrategy.aboutToBeReconciled();
    }
}

