/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUWorkingSets {
    ArrayList<IWorkingSet[]> workingSetsCache = null;
    int size = 0;

    public LRUWorkingSets(int size) {
        this.workingSetsCache = new ArrayList(size);
        this.size = size;
    }

    public void add(IWorkingSet[] workingSet) {
        this.cleanUpCache();
        IWorkingSet[] existingWorkingSets = this.find(this.workingSetsCache, workingSet);
        if (existingWorkingSets != null) {
            this.workingSetsCache.remove(existingWorkingSets);
        } else if (this.workingSetsCache.size() == this.size) {
            this.workingSetsCache.remove(this.size - 1);
        }
        this.workingSetsCache.add(0, workingSet);
    }

    private IWorkingSet[] find(ArrayList<IWorkingSet[]> list, IWorkingSet[] workingSet) {
        HashSet<IWorkingSet> workingSetList = new HashSet<IWorkingSet>(Arrays.asList(workingSet));
        for (IWorkingSet[] lruWorkingSets : list) {
            HashSet<IWorkingSet> lruWorkingSetList = new HashSet<IWorkingSet>(Arrays.asList(lruWorkingSets));
            if (!lruWorkingSetList.equals(workingSetList)) continue;
            return lruWorkingSets;
        }
        return null;
    }

    private void cleanUpCache() {
        block0: for (IWorkingSet[] workingSet : this.workingSetsCache) {
            int i = 0;
            while (i < workingSet.length) {
                if (PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSet[i].getName()) == null) {
                    this.workingSetsCache.remove(workingSet);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public Iterator<IWorkingSet[]> iterator() {
        return this.workingSetsCache.iterator();
    }
}

