/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.internal.ui.preferences.formatter.CPreview;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.cdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.cdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.cdt.internal.ui.preferences.formatter.TranslationUnitPreview;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentationTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private static final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "#include <math.h>\n\n" + "class Point {" + "public:" + "Point(double xc, double yc) : x(xc), y(yc) {}" + "\n\n" + "double distance(const Point& other) const;" + "int compareX(const Point& other) const;" + "double x;" + "double y;" + "};" + "\n\n" + "double Point::distance(const Point& other) const {" + "double dx = x - other.x;" + "double dy = y - other.y;" + "\n\n" + "return sqrt(dx * dx + dy * dy);" + "}" + "\n\n" + "int Point::compareX(const Point& other) const {" + "if(x < other.x) {" + "return -1;" + "} else if(x > other.x){" + "return 1;" + "} else {" + "return 0;" + "}" + "}" + "\n\n" + "namespace FOO {" + "int foo(int bar) const {" + "switch(bar) {" + "case 0:" + "++bar;" + "break;" + "case 1:" + "--bar;" + "default: {" + "bar += bar;" + "break;" + "}" + "}" + "}" + "} // end namespace FOO";
    private TranslationUnitPreview fPreview;
    private String fOldTabChar = null;

    public IndentationTabPage(ModifyDialog modifyDialog, Map<String, String> workingValues) {
        super(modifyDialog, workingValues);
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference tabPolicy = this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "org.eclipse.cdt.core.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.CheckboxPreference onlyForLeading = this.createCheckboxPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "org.eclipse.cdt.core.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "org.eclipse.cdt.core.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "org.eclipse.cdt.core.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("org.eclipse.cdt.core.formatter.tabulation.char");
        this.updateTabPreferences(tabchar, tabSize, indentSize, onlyForLeading);
        tabPolicy.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                IndentationTabPage.this.updateTabPreferences((String)arg, tabSize, indentSize, onlyForLeading);
            }
        });
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
        Group classGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_access_specifiers_within_class_body, "org.eclipse.cdt.core.formatter.indent_access_specifier_compare_to_type_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_class_group_option_indent_declarations_compare_to_access_specifiers, "org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_access_specifier", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_body, "org.eclipse.cdt.core.formatter.indent_statements_compare_to_body", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_block, "org.eclipse.cdt.core.formatter.indent_statements_compare_to_block", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_switch_body, "org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_switch", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body, "org.eclipse.cdt.core.formatter.indent_switchstatements_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_break_statements, "org.eclipse.cdt.core.formatter.indent_breaks_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_namespace_group_option_indent_declarations_within_namespace, "org.eclipse.cdt.core.formatter.indent_body_declarations_compare_to_namespace_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_indent_empty_lines, "org.eclipse.cdt.core.formatter.indent_empty_lines", FALSE_TRUE);
    }

    @Override
    public void initializePage() {
        this.fPreview.setPreviewText(PREVIEW);
    }

    @Override
    protected CPreview doCreateCPreview(Composite parent) {
        this.fPreview = new TranslationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    @Override
    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if ("space".equals(this.fOldTabChar) || "tab".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.cdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.eclipse.cdt.core.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if ("space".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.cdt.core.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.eclipse.cdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("tab".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.cdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("org.eclipse.cdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        String tabSize = (String)this.fWorkingValues.get("org.eclipse.cdt.core.formatter.tabulation.size");
        String indentSize = (String)this.fWorkingValues.get("org.eclipse.cdt.core.formatter.indentation.size");
        this.fWorkingValues.put("org.eclipse.cdt.core.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("org.eclipse.cdt.core.formatter.indentation.size", tabSize);
    }
}

