/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.ArrayList;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.ui.includebrowser.IBDropTargetListener;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.ui.part.ResourceTransfer;

public class IBDragSourceListener
implements DragSourceListener {
    private TreeViewer fTreeViewer;
    private ArrayList<IBNode> fSelectedNodes = new ArrayList();
    private IBDropTargetListener fDropTargetListener;

    public IBDragSourceListener(TreeViewer viewer) {
        this.fTreeViewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        if (this.fDropTargetListener != null) {
            this.fDropTargetListener.setEnabled(false);
        }
        this.fSelectedNodes.clear();
        if (event.doit) {
            IStructuredSelection sel = (IStructuredSelection)this.fTreeViewer.getSelection();
            for (Object element : sel) {
                if (!(element instanceof IBNode)) continue;
                this.fSelectedNodes.add((IBNode)element);
            }
            event.doit = !this.fSelectedNodes.isEmpty();
        }
    }

    public void setDependentDropTargetListener(IBDropTargetListener dl) {
        this.fDropTargetListener = dl;
    }

    public void dragSetData(DragSourceEvent event) {
        if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getResources();
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getFiles();
        }
    }

    private String[] getFiles() {
        ArrayList<String> files = new ArrayList<String>(this.fSelectedNodes.size());
        for (IBNode node : this.fSelectedNodes) {
            IPath location;
            IIndexFileLocation ifl = (IIndexFileLocation)node.getAdapter(IIndexFileLocation.class);
            if (ifl == null || (location = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)ifl)) == null) continue;
            files.add(location.toOSString());
        }
        return files.toArray(new String[files.size()]);
    }

    private IFile[] getResources() {
        ArrayList<IFile> files = new ArrayList<IFile>(this.fSelectedNodes.size());
        for (IBNode node : this.fSelectedNodes) {
            IFile file = (IFile)node.getAdapter(IFile.class);
            if (file == null) continue;
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.fDropTargetListener != null) {
            this.fDropTargetListener.setEnabled(true);
        }
        this.fSelectedNodes.clear();
    }
}

