/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathTabBlock;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class CPathPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private static final String PAGE_SETTINGS = "CPathsPropertyPage";
    private static final String INDEX = "pageIndex";
    CPathTabBlock fCPathsBlock;
    IPathEntryStore fStore;

    protected Control createContents(Composite parent) {
        IProject project = this.getProject();
        this.noDefaultAndApplyButton();
        Control result = project == null || !this.isCProject(project) ? this.createWithoutCProject(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWithCProject(parent, project));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private IDialogSettings getSettings() {
        IDialogSettings cSettings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = cSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = cSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 3);
        }
        return pageSettings;
    }

    private Control createWithCProject(Composite parent, IProject project) {
        this.fCPathsBlock = new CPathTabBlock(this, this.getSettings().getInt(INDEX));
        this.fCPathsBlock.init((ICElement)CoreModel.getDefault().create(project), null);
        return this.fCPathsBlock.createContents(parent);
    }

    private Control createWithoutCProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(CPathEntryMessages.CPathsPropertyPage_no_C_project_message);
        this.fCPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(CPathEntryMessages.CPathsPropertyPage_closed_project_message);
        this.fCPathsBlock = null;
        this.setValid(true);
        return label;
    }

    public void setVisible(boolean visible) {
        if (this.fCPathsBlock != null) {
            if (!visible) {
                if (this.fCPathsBlock.hasChangesInDialog()) {
                    String title = CPathEntryMessages.CPathsPropertyPage_unsavedchanges_title;
                    String message = CPathEntryMessages.CPathsPropertyPage_unsavedchanges_message;
                    String[] buttonLabels = new String[]{CPathEntryMessages.CPathsPropertyPage_unsavedchanges_button_save, CPathEntryMessages.CPathsPropertyPage_unsavedchanges_button_discard};
                    MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
                    int res = dialog.open();
                    if (res == 0) {
                        this.performOk();
                    } else if (res == 1) {
                        this.fCPathsBlock.init((ICElement)CoreModel.getDefault().create(this.getProject()), null);
                    }
                }
            } else if (!this.fCPathsBlock.hasChangesInDialog() && this.fCPathsBlock.hasChangesInCPathFile()) {
                this.fCPathsBlock.init((ICElement)CoreModel.getDefault().create(this.getProject()), null);
            }
        }
        super.setVisible(visible);
    }

    private IProject getProject() {
        ICElement elem;
        IAdaptable adaptable = this.getElement();
        if (adaptable != null && (elem = (ICElement)adaptable.getAdapter(ICElement.class)) instanceof ICProject) {
            return ((ICProject)elem).getProject();
        }
        return null;
    }

    private boolean isCProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fCPathsBlock != null) {
            this.getSettings().put(INDEX, this.fCPathsBlock.getPageIndex());
            Shell shell = this.getControl().getShell();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CPathPropertyPage.this.fCPathsBlock.configureCProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
            try {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                String title = CPathEntryMessages.CPathsPropertyPage_error_title;
                String message = CPathEntryMessages.CPathsPropertyPage_error_message;
                ExceptionHandler.handle(e, shell, title, message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public boolean performCancel() {
        if (this.fCPathsBlock != null) {
            this.getSettings().put(INDEX, this.fCPathsBlock.getPageIndex());
        }
        return super.performCancel();
    }
}

