/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.model.ICDIEventBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class EventBreakpoint
extends Breakpoint
implements ICDIEventBreakpoint {
    public static final String CATCH = "org.eclipse.cdt.debug.gdb.catch";
    public static final String THROW = "org.eclipse.cdt.debug.gdb.throw";
    public static final String SIGNAL_CATCH = "org.eclipse.cdt.debug.gdb.signal";
    public static final String STOP_ON_FORK = "org.eclipse.cdt.debug.gdb.catch_fork";
    public static final String STOP_ON_VFORK = "org.eclipse.cdt.debug.gdb.catch_vfork";
    public static final String STOP_ON_EXEC = "org.eclipse.cdt.debug.gdb.catch_exec";
    public static final String CATCH_EXIT = "org.eclipse.cdt.debug.gdb.catch_exit";
    public static final String CATCH_START = "org.eclipse.cdt.debug.gdb.catch_start";
    public static final String CATCH_STOP = "org.eclipse.cdt.debug.gdb.catch_stop";
    public static final String CATCH_THREAD_START = "org.eclipse.cdt.debug.gdb.catch_thread_start";
    public static final String CATCH_THREAD_EXIT = "org.eclipse.cdt.debug.gdb.catch_thread_exit";
    public static final String CATCH_THREAD_JOIN = "org.eclipse.cdt.debug.gdb.catch_thread_join";
    public static final String CATCH_LOAD = "org.eclipse.cdt.debug.gdb.catch_load";
    public static final String CATCH_UNLOAD = "org.eclipse.cdt.debug.gdb.catch_unload";
    private String eventType;
    private String arg;
    private static final HashMap<String, String> idToKeyword = new HashMap();

    static {
        idToKeyword.put(CATCH, "catch");
        idToKeyword.put(THROW, "throw");
        idToKeyword.put(SIGNAL_CATCH, "signal");
        idToKeyword.put(STOP_ON_EXEC, "exec");
        idToKeyword.put(STOP_ON_FORK, "fork");
        idToKeyword.put(STOP_ON_VFORK, "vfork");
        idToKeyword.put(CATCH_EXIT, "exit");
        idToKeyword.put(CATCH_START, "start");
        idToKeyword.put(CATCH_STOP, "stop");
        idToKeyword.put(CATCH_THREAD_START, "thread_start");
        idToKeyword.put(CATCH_THREAD_EXIT, "thread_exit");
        idToKeyword.put(CATCH_THREAD_JOIN, "thread_join");
        idToKeyword.put(CATCH_LOAD, "load");
        idToKeyword.put(CATCH_UNLOAD, "unload");
    }

    public EventBreakpoint(Target target, String event, String arg, ICDICondition cond, boolean enabled) {
        super(target, 0, cond, enabled);
        this.eventType = event;
        this.arg = arg == null ? "" : arg;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getExtraArgument() {
        return this.arg;
    }

    public String getGdbEvent() {
        String etype = this.getEventType();
        String key = idToKeyword.get(etype);
        if (key != null) {
            return key;
        }
        return "unknown";
    }

    public String getGdbArg() {
        return this.getExtraArgument();
    }

    public int hashCode() {
        return this.eventType.hashCode();
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof EventBreakpoint)) {
            return false;
        }
        Object[] breakpoints = this.getMIBreakpoints();
        if (breakpoints == null || breakpoints.length == 0) {
            return super.equals(arg0);
        }
        return Arrays.equals(breakpoints, ((EventBreakpoint)arg0).getMIBreakpoints());
    }

    public static String getEventTypeFromMI(MIBreakpoint miBreakpoint) {
        String prefix;
        if (miBreakpoint.getWhat().equals("exception catch")) {
            return CATCH;
        }
        if (miBreakpoint.getWhat().equals("exception throw")) {
            return THROW;
        }
        if (miBreakpoint.getType().equals("catch signal")) {
            return SIGNAL_CATCH;
        }
        String miType = miBreakpoint.getType();
        if (miType.startsWith(prefix = "catch ")) {
            String key = miType.substring(prefix.length());
            for (String id : idToKeyword.keySet()) {
                String etype = idToKeyword.get(id);
                if (!key.equals(etype)) continue;
                return id;
            }
        }
        return null;
    }

    public static String getEventArgumentFromMI(MIBreakpoint miBreakpoint) {
        return "";
    }
}

