
# line 2 "grammar.y"
/*
** This is a bare-bones prototype for an ANSI C parser.
**
** It is based on _The C Programming Language,
** Second Edition_, Kernighan and Ritchie, Printice Hall, 1988.
*/
#include <sys/types.h>
#include "ansi.h"
#include "host.h"
#include "hash.h"
#include "files.h"
#include "il.h"
#include "nodeop.h"
#include "types.h"
#include "type_util.h"
#define NO_LNINFO

static symbol_t *cur_func;

# line 22 "grammar.y"
typedef union  {
    int val;
	node_t *nod;
	symbol_t *sym;
	typeinfo_t *typ;
} YYSTYPE;
# define BAD_TOKEN 257
# define INTEGER_CONSTANT 258
# define CHARACTER_CONSTANT 259
# define FLOATING_CONSTANT 260
# define ENUMERATION_CONSTANT 261
# define IDENTIFIER 262
# define STRING 263
# define TYPEDEF_NAME 264
# define SIZEOF 265
# define PTR_OP 266
# define INC_OP 267
# define DEC_OP 268
# define LEFT_OP 269
# define RIGHT_OP 270
# define LE_OP 271
# define GE_OP 272
# define EQ_OP 273
# define NE_OP 274
# define AND_OP 275
# define OR_OP 276
# define MUL_ASSIGN 277
# define DIV_ASSIGN 278
# define MOD_ASSIGN 279
# define ADD_ASSIGN 280
# define SUB_ASSIGN 281
# define LEFT_ASSIGN 282
# define RIGHT_ASSIGN 283
# define AND_ASSIGN 284
# define XOR_ASSIGN 285
# define OR_ASSIGN 286
# define TYPEDEF 287
# define EXTERN 288
# define STATIC 289
# define AUTO 290
# define REGISTER 291
# define CHAR 292
# define SHORT 293
# define INT 294
# define LONG 295
# define SIGNED 296
# define UNSIGNED 297
# define FLOAT 298
# define DOUBLE 299
# define CONST 300
# define VOLATILE 301
# define VOID 302
# define STRUCT 303
# define UNION 304
# define ENUM 305
# define ELIPSIS 306
# define DOTDOT 307
# define CASE 308
# define DEFAULT 309
# define IF 310
# define SWITCH 311
# define WHILE 312
# define DO 313
# define FOR 314
# define GOTO 315
# define CONTINUE 316
# define BREAK 317
# define RETURN 318
# define THEN 319
# define ELSE 320
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 705 "grammar.y"

yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 7,
-1, 3,
	287, 9,
	-2, 1,
-1, 7,
	287, 9,
	123, 3,
	-2, 1,
-1, 11,
	262, 31,
	287, 9,
	59, 31,
	44, 31,
	40, 31,
	41, 31,
	91, 31,
	42, 31,
	-2, 1,
-1, 12,
	262, 33,
	287, 9,
	59, 33,
	44, 33,
	40, 33,
	41, 33,
	91, 33,
	42, 33,
	-2, 1,
-1, 13,
	262, 35,
	287, 9,
	59, 35,
	44, 35,
	40, 35,
	41, 35,
	91, 35,
	42, 35,
	-2, 1,
-1, 26,
	61, 2,
	-2, 67,
-1, 27,
	40, 3,
	-2, 10,
-1, 36,
	287, 9,
	123, 21,
	-2, 1,
-1, 51,
	40, 3,
	-2, 11,
-1, 63,
	123, 5,
	-2, 1,
-1, 75,
	40, 3,
	-2, 10,
-1, 80,
	287, 9,
	123, 3,
	125, 4,
	-2, 1,
-1, 88,
	123, 5,
	-2, 60,
-1, 135,
	40, 3,
	-2, 11,
-1, 138,
	123, 3,
	125, 4,
	-2, 1,
-1, 139,
	287, 9,
	123, 3,
	125, 4,
	-2, 1,
-1, 155,
	123, 3,
	-2, 1,
-1, 162,
	58, 13,
	-2, 237,
-1, 163,
	58, 14,
	-2, 246,
-1, 201,
	262, 70,
	58, 70,
	40, 70,
	41, 70,
	91, 70,
	42, 70,
	-2, 1,
-1, 202,
	262, 72,
	58, 72,
	40, 72,
	41, 72,
	91, 72,
	42, 72,
	-2, 1,
-1, 216,
	59, 4,
	44, 4,
	61, 4,
	40, 4,
	91, 4,
	-2, 98,
-1, 221,
	287, 9,
	-2, 1,
-1, 227,
	123, 3,
	125, 4,
	-2, 1,
-1, 228,
	123, 3,
	-2, 1,
-1, 230,
	123, 3,
	-2, 1,
-1, 243,
	58, 2,
	-2, 49,
-1, 256,
	125, 6,
	-2, 1,
-1, 299,
	59, 4,
	44, 4,
	61, 4,
	40, 4,
	91, 4,
	-2, 97,
-1, 301,
	59, 4,
	44, 4,
	61, 4,
	40, 4,
	91, 4,
	-2, 99,
-1, 312,
	123, 3,
	-2, 1,
-1, 330,
	125, 6,
	-2, 1,
-1, 361,
	123, 3,
	-2, 1,
-1, 362,
	123, 3,
	-2, 1,
-1, 363,
	123, 3,
	-2, 1,
-1, 392,
	123, 3,
	-2, 1,
-1, 408,
	123, 3,
	-2, 1,
-1, 411,
	123, 3,
	-2, 1,
-1, 412,
	123, 3,
	-2, 1,
-1, 414,
	123, 3,
	-2, 1,
-1, 423,
	123, 3,
	-2, 1,
-1, 425,
	123, 3,
	-2, 1,
-1, 426,
	123, 3,
	-2, 1,
-1, 431,
	123, 3,
	-2, 1,
	};
# define YYNPROD 247
# define YYLAST 1205
yytabelem yyact[]={

   140,   151,   166,   165,    96,   257,   327,   382,   408,   340,
   324,   318,    75,    26,    76,   350,    27,    28,    16,   380,
   300,    27,   220,    16,    53,   175,   181,   243,   179,    51,
   185,   186,   187,    42,   188,   170,    34,    92,    28,   191,
   192,   349,   306,    72,    46,    91,    90,    34,    74,   164,
   216,   172,   173,    60,   108,    56,   256,    57,    79,   356,
    67,    58,    59,   198,   103,    55,    65,    66,    64,   104,
   107,   100,   109,    97,   204,    81,    34,    83,    28,    99,
   205,    56,   217,    57,   171,   138,   131,    58,    59,   135,
   102,    55,    65,    66,    64,    18,    19,    20,    21,   400,
    29,   137,    30,    31,    32,   101,    39,    24,    25,   368,
   342,   359,   199,   309,   308,   209,   211,   109,   213,    29,
   223,    30,    31,    32,   182,   203,    24,    25,   356,   381,
    28,    34,   183,    28,    70,   259,   335,   262,   215,   225,
   105,   262,   417,    38,   176,   147,   174,     5,   168,   329,
    80,   109,    97,   229,   407,   178,   236,    69,    70,   224,
   226,   263,   242,    94,   232,   106,    36,    35,   420,   212,
   397,   321,    87,   240,   239,    91,    90,   167,    82,   342,
    78,   268,   134,   109,   109,   109,   109,   109,   109,   109,
   109,   109,   109,   109,   109,   109,   109,   109,   109,   109,
   109,   258,   371,   267,   260,   292,   356,   312,    28,    88,
    93,   230,   199,   343,   122,   228,   199,   334,   333,   117,
    85,   110,   261,   118,   119,   227,   120,   176,   225,   311,
   305,   313,   232,    14,   289,   315,   316,   317,   370,   320,
   150,   180,   134,   189,   190,   136,   336,   139,   310,   273,
   284,   285,   286,   270,   295,   274,   275,   342,    33,   264,
   269,   169,   325,   219,   282,   283,   109,    97,   332,    33,
   303,   219,   328,    86,   272,    24,    25,   260,   298,    84,
   232,    33,   314,    78,    18,    19,    20,    21,   271,    29,
   109,    30,    31,    32,   323,   416,    24,    25,    33,    12,
   206,   207,   208,   238,   339,   307,    45,   121,   341,   338,
    28,   418,   200,   360,   331,   193,   330,   194,   352,   355,
   347,   366,   348,   406,   354,   405,   351,   403,   276,   277,
   278,   279,   109,    97,   372,   364,   325,   357,   353,   109,
   376,   373,   337,   346,   299,   109,    97,   384,   287,   377,
    33,   296,   297,    33,   379,   245,   339,   280,   281,   342,
   369,   375,   388,   389,   390,   377,   391,   393,   135,   396,
    74,   355,   341,   237,   109,    97,   399,   398,   347,   348,
   133,   109,    97,   402,   328,   176,   386,   404,   387,   235,
   234,   233,    13,   410,    89,   385,   413,   415,    22,   341,
   381,    28,    22,   290,   291,   378,    22,    22,    22,   419,
   201,   222,   421,   422,   232,   424,   200,   130,   427,   232,
   232,    73,   142,   342,   428,   184,   429,   430,    33,   394,
    37,    22,   432,   146,   367,   322,   232,    45,    15,   126,
   127,   128,   163,   162,   125,   145,   115,   144,   112,   113,
   342,   231,    44,   122,   431,    52,   197,   232,   117,   143,
   110,   195,   118,   119,   132,   120,   196,   141,   201,    18,
    19,    20,    21,    77,    29,   161,    30,    31,    32,   150,
   425,    24,    25,   232,   423,   411,     6,   232,   232,   148,
   149,   152,   153,   154,   155,   156,   157,   158,   159,   160,
    37,   201,   201,   202,   409,    22,   363,   232,   362,   232,
   361,   232,     2,   232,   201,   122,   358,    40,    17,   302,
   117,     8,   110,    10,   118,   119,   221,   120,   122,    47,
    48,    49,    41,   117,   161,   110,    68,   118,   119,   344,
   120,   301,   345,    43,   302,   288,   121,     9,   232,     3,
     1,   326,    50,   266,   294,    98,   201,   111,   116,   201,
   124,   202,     7,    22,     4,   218,    61,    62,    54,    63,
   265,   246,   247,   248,   249,   250,   251,   252,   253,   254,
   255,   122,   244,   114,    11,    71,   117,    23,   110,   426,
   118,   119,     0,   120,   202,   202,    22,    22,     0,     0,
     0,     0,     0,     0,     0,   122,     0,   202,   121,    22,
   117,     0,   110,   414,   118,   119,    22,   120,   177,   122,
   374,   121,     0,     0,   117,     0,   110,   412,   118,   119,
   201,   120,     0,   122,     0,     0,     0,     0,   117,     0,
   110,     0,   118,   119,     0,   120,     0,     0,     0,   202,
     0,    22,   202,     0,    22,     0,     0,     0,   122,     0,
     0,     0,     0,   117,     0,   110,     0,   118,   119,     0,
   120,     0,     0,     0,   121,     0,     0,     0,   126,   127,
   128,   163,   162,   125,   395,   115,     0,   112,   113,     0,
     0,     0,   122,   401,     0,     0,     0,   117,   121,   110,
   392,   118,   119,     0,   120,     0,   122,     0,     0,     0,
     0,   117,   121,   110,     0,   118,   119,     0,   120,     0,
     0,     0,     0,   202,     0,    22,   121,     0,   148,   149,
   152,   153,   154,   155,   156,   157,   158,   159,   160,   304,
   126,   127,   128,   129,   123,   125,     0,   115,     0,   112,
   113,   121,     0,   126,   127,   128,   129,   123,   125,     0,
   115,     0,   112,   113,   122,     0,   383,     0,     0,   117,
     0,   110,     0,   118,   119,    29,   120,    30,    31,    32,
     0,     0,    24,    25,     0,   121,   122,     0,     0,     0,
   365,   117,     0,   110,     0,   118,   119,     0,   120,   121,
     0,     0,     0,     0,     0,     0,   126,   127,   128,   129,
   123,   125,   319,   115,   122,   112,   113,     0,     0,   117,
     0,   110,   293,   118,   119,     0,   120,     0,     0,     0,
   126,   127,   128,   129,   123,   125,     0,   115,     0,   112,
   113,     0,     0,     0,   126,   127,   128,   129,   123,   125,
     0,   115,     0,   112,   113,     0,     0,   121,   126,   127,
   128,   129,   123,   125,   122,   115,     0,   112,   113,   117,
     0,   110,     0,   118,   119,     0,   120,     0,     0,   121,
     0,     0,     0,   126,   127,   128,   129,   123,   125,   122,
   115,     0,   112,   113,   117,     0,   110,     0,   118,   119,
     0,   120,     0,     0,   122,     0,     0,   121,     0,   117,
     0,   110,     0,   118,   119,   241,   120,   126,   127,   128,
   129,   123,   125,     0,   115,     0,   112,   113,     0,     0,
     0,   126,   127,   128,   129,   123,   125,   122,   115,     0,
   112,   113,   117,     0,   110,     0,   118,   119,     0,   120,
     0,     0,     0,     0,   177,     0,     0,   121,   122,     0,
     0,     0,     0,   117,    95,   214,     0,   118,   119,   122,
   120,     0,     0,     0,   117,     0,   210,     0,   118,   119,
     0,   120,   121,     0,     0,     0,     0,     0,     0,   126,
   127,   128,   129,   123,   125,     0,   115,   121,   112,   113,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   126,   127,   128,   129,   123,   125,     0,   115,     0,
   112,   113,     0,     0,     0,     0,     0,     0,     0,     0,
   121,     0,     0,     0,     0,     0,     0,     0,     0,   126,
   127,   128,   129,   123,   125,     0,   115,     0,   112,   113,
     0,   121,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   121,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   126,
   127,   128,   129,   123,   125,     0,   115,     0,   112,   113,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   126,   127,   128,   129,   123,   125,
     0,   115,     0,   112,   113,     0,     0,     0,     0,   126,
   127,   128,   129,   123,   125,     0,   115,     0,   112,   113,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   126,   127,   128,   129,   123,   125,     0,   115,
     0,   112,   113,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   126,   127,   128,   129,   123,   125,     0,
   115,     0,   112,   113,   126,   127,   128,   129,   123,   125,
     0,   115,     0,   112,   113 };
yytabelem yypact[]={

 -1000, -1000, -1000,    -4, -1000, -1000, -1000,  -193,    36,   393,
 -1000,  -193,  -193,  -193, -1000, -1000,     7,  -263, -1000, -1000,
 -1000, -1000,  -211, -1000, -1000, -1000, -1000,    66,   -25, -1000,
 -1000, -1000, -1000, -1000,    36, -1000,  -193, -1000, -1000,    27,
    36, -1000,   119,   262, -1000,    36, -1000, -1000, -1000, -1000,
 -1000,    66, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,  -216,   -86, -1000, -1000,   102, -1000,   871,
   377,   -25, -1000, -1000,   339,    66,     7, -1000, -1000, -1000,
   181, -1000, -1000,   118, -1000, -1000, -1000,    25, -1000,  -229,
 -1000, -1000,  -210,    23,   831, -1000,    62, -1000,   -35,  -249,
     0,    38,   387,  -243,   -28,  -230,   272,   419, -1000, -1000,
   482,    34,   936,   936,   904,   925, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
     9, -1000, -1000, -1000,   371,    66, -1000,    -5,   420,   181,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,   157,   904,   153,
 -1000,   392,   351,   350,   349,   420,   333,  -216,   115,   114,
   856,  -237, -1000, -1000, -1000, -1000,   294, -1000,  -174,    12,
 -1000,    97, -1000,   100,  -210, -1000, -1000,   831, -1000,   904,
   904,   904,   904,   904,   904,   904,   904,   904,   904,   904,
   904,   904,   904,   904,   904,   904,   904,   904,   307,   504,
 -1000,  -174,  -174,   904,   781,  -216,  -216, -1000, -1000, -1000,
   904, -1000, -1000, -1000,   482,   303, -1000,   500,   226, -1000,
 -1000,  -193,     1, -1000,   -11, -1000,   -12,   420,   420,   149,
   420, -1000,   904,   904,   904,   904,  -301,   753,   112, -1000,
 -1000, -1000,   376, -1000,   904, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,  -174, -1000,    91,  -174,
 -1000, -1000,  -210,   904,    93, -1000,    92, -1000,   188,  -249,
     0,    38,   387,  -243,   -28,   -28,  -230,  -230,  -230,  -230,
   272,   272,   419,   419, -1000, -1000, -1000,   904, -1000,   268,
 -1000, -1000,   120, -1000,   498, -1000, -1000, -1000,   302, -1000,
 -1000, -1000,  -221,  -291,   166,   296, -1000,   475, -1000, -1000,
   -14, -1000,   420, -1000, -1000,   469,   467,   465,   295,   731,
   375, -1000, -1000, -1000,   -16, -1000,   194, -1000,   144,   904,
  -174, -1000, -1000, -1000, -1000,   495,   904, -1000, -1000,   332,
   314,   359,   673, -1000, -1000,   904, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,    19,    88, -1000, -1000, -1000,
 -1000,   420,   420,   420,   904,   659,   370,   625, -1000,   111,
    91,   904, -1000,   -26, -1000, -1000, -1000,   314,   600,   286,
   284, -1000,   282, -1000,    61, -1000, -1000, -1000,  -312, -1000,
 -1000,   463,   420,   444,   586,   572,   236, -1000, -1000, -1000,
 -1000, -1000,    49, -1000,   270, -1000, -1000, -1000,   420,   109,
 -1000,   420,   420,   443,   420,   439,   548, -1000, -1000, -1000,
 -1000, -1000, -1000,   420, -1000,   420,   420,   413, -1000, -1000,
 -1000,   420, -1000 };
yytabelem yypgo[]={

     0,   587,   392,   585,   584,   583,   582,   569,   299,    63,
   568,   201,   517,   143,   166,    51,    84,   567,   566,    56,
     5,    22,   565,     7,   564,   562,   560,   145,    82,     4,
   558,    49,     1,   557,     2,    54,    70,   165,   140,    69,
    64,    90,   105,    71,    79,   555,     3,   554,    25,   553,
    13,    12,   233,   543,     6,   551,    14,    19,     9,   523,
   438,   550,   394,    33,   106,    20,   172,    10,   549,   526,
   518,   536,   220,   512,   486,   167,   473,   422,     0,   467,
   459,   447,   445,   433,    85 };
yytabelem yyr1[]={

     0,    62,    63,    64,    65,    66,    67,    68,    69,    70,
    71,    72,    27,    27,    27,    61,    61,    73,    73,    73,
    24,    76,    24,    25,    25,    75,    13,    13,    74,    14,
    14,    12,    12,    12,    12,    12,    12,     4,     4,     4,
     4,     4,     8,     8,    10,    10,    10,    10,    10,    10,
    10,    10,     1,     1,     1,     1,     2,     2,    18,    18,
    18,     7,     7,    19,    19,    53,    53,    52,    52,    20,
    11,    11,    11,    11,    55,    55,    54,    54,    54,    17,
    17,    17,    16,    16,    15,    15,    50,    50,    51,    51,
    51,    51,    51,    51,    51,    59,    59,    60,    60,    60,
    56,    56,    56,    56,     3,     3,    23,    23,    22,    22,
    21,    21,    21,    28,    28,    48,    48,    48,    49,    49,
     9,     9,    57,    57,    57,    58,    58,    58,    58,    58,
    58,    58,    58,    58,    78,    78,    78,    78,    78,    78,
    79,    79,    79,    80,    80,    77,    77,    77,    77,    84,
    84,    81,    81,    81,    82,    82,    82,    82,    82,    82,
    82,    82,    82,    82,    83,    83,    83,    83,    83,    32,
    32,    31,    31,     6,     6,     6,     6,     6,     6,     6,
     6,     6,     6,     6,    46,    46,    29,    45,    45,    44,
    44,    43,    43,    42,    42,    41,    41,    40,    40,    40,
    39,    39,    39,    39,    39,    38,    38,    38,    37,    37,
    37,    36,    36,    36,    36,    35,    35,    34,    34,    34,
    34,    34,    34,     5,     5,     5,     5,     5,     5,    33,
    33,    33,    33,    33,    33,    33,    33,    30,    30,    30,
    30,    47,    47,    26,    26,    26,    26 };
yytabelem yyr2[]={

     0,     0,     0,     1,     1,     0,     0,     0,     0,     0,
     0,     0,     7,     2,     2,     0,     4,     5,     5,     4,
     4,     1,     8,     5,     7,     4,     7,     9,     4,     2,
     5,     3,     5,     2,     5,     3,     5,     5,     3,     3,
     3,     3,     5,     3,     3,     3,     3,     3,     3,     2,
     3,     3,     3,     3,     3,     3,     3,     3,    13,    15,
     5,     3,     3,     2,     5,     2,     7,     2,    11,     9,
     3,     5,     3,     5,     2,     7,     2,     5,     7,     9,
    11,     5,     2,     7,     3,     7,     4,     7,     2,     7,
     7,     9,    13,    11,    13,     4,     7,    11,     9,    11,
     3,     5,     5,     7,     2,     5,     2,     7,     2,     7,
     9,     7,     9,     2,     7,     2,     7,     9,     2,     7,
     4,     7,     2,     2,     5,     7,     5,     7,     7,     9,
     5,     7,     7,     9,     2,     2,     2,     2,     2,     2,
     6,     8,     6,     2,     4,     8,    10,    10,    12,     2,
     4,    10,    14,    10,    10,    14,    12,    14,    14,    16,
    14,    16,    16,    18,     6,     4,     4,     4,     7,     2,
     7,     2,     7,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     2,    11,     2,     2,     7,     2,
     7,     2,     7,     2,     7,     2,     7,     2,     7,     7,
     2,     7,     7,     7,     7,     2,     7,     7,     2,     7,
     7,     2,     7,     7,     7,     2,     9,     2,     5,     5,
     5,     5,     9,     3,     3,     3,     3,     3,     3,     2,
     9,     7,     9,     7,     7,     5,     5,     2,     2,     2,
     7,     2,     7,     2,     2,     2,     2 };
yytabelem yychk[]={

 -1000,   -61,   -73,   -68,   -24,   -13,   -74,   -25,   -12,   -53,
   -59,    -4,    -8,    -2,   -52,   -60,   -56,   -70,   288,   289,
   290,   291,   -62,    -1,   300,   301,   -50,   -51,    42,   293,
   295,   296,   297,   262,    40,   -75,   -14,   -77,   -13,   -64,
   -12,   -59,   -63,   -53,    59,    44,   -63,   -12,   -12,   -12,
   -71,   -51,   -60,   287,   -10,   302,   292,   294,   298,   299,
   264,   -18,   -17,    -7,   305,   303,   304,   -63,   -71,    91,
   -64,    -3,   -56,    -2,   -50,   -51,   -56,   -76,   -13,   -65,
   123,   -63,    59,   -63,   -52,   -72,   -72,   -66,   -27,   -62,
   262,   261,   123,   -27,    61,    93,   -29,   -46,   -45,   -44,
   -43,   -42,   -41,   -40,   -39,   -38,   -37,   -36,   -35,   -34,
    40,   -33,   267,   268,    -5,   265,   -30,    38,    42,    43,
    45,   126,    33,   262,   -26,   263,   258,   259,   260,   261,
    40,   -56,    -2,    41,   -64,   -51,   -75,   -65,   -84,   -14,
   -78,   -79,   -77,   -80,   -81,   -82,   -83,   -27,   308,   309,
    59,   -32,   310,   311,   312,   313,   314,   315,   316,   317,
   318,   -62,   262,   261,   -31,   -46,   -34,    59,   123,   -66,
   264,   -16,   -15,   262,   123,   -48,   -31,   123,    93,    63,
   276,   275,   124,    94,    38,   273,   274,    60,    62,   271,
   272,   269,   270,    43,    45,    42,    47,    37,    -9,   -32,
   -11,    -8,    -2,    91,    40,    46,   266,   267,   268,   -34,
    40,   -34,   -35,   -34,    40,   -23,    41,   -28,   -22,   262,
   -21,   -69,    40,   125,   -65,   -78,   -65,   -84,    58,   -29,
    58,    59,    44,    40,    40,    40,   -78,    40,   -27,    59,
    59,    59,   -32,   264,    -6,    61,   277,   278,   279,   280,
   281,   282,   283,   284,   285,   286,   -19,   -20,   -11,   123,
   -63,   125,    44,    61,   -16,   -62,   -49,   -48,   -32,   -44,
   -43,   -42,   -41,   -40,   -39,   -39,   -38,   -38,   -38,   -38,
   -37,   -37,   -36,   -36,   -35,   -35,   -35,    41,    41,   -63,
   -11,   -11,   -32,    41,   -47,   -31,   -27,   -27,    -9,    41,
   -65,    41,    44,    44,   -12,   -23,    41,   -28,   125,   125,
   -65,   -78,    58,   -78,   -31,   -32,   -32,   -32,   312,    59,
   -32,    59,    59,   -31,   -67,   -20,   -55,   -54,   -50,    58,
   -19,   -15,   -29,   125,   125,    44,    58,   -35,   -57,   -56,
   -58,    40,    91,    93,    41,    44,    41,   -65,   -65,   262,
   306,   -21,   -50,   -63,   -57,   -56,    40,    41,    41,   125,
   -78,    41,    41,    41,    40,    59,   -32,    59,   125,   -63,
    44,    58,   -29,   -67,   125,   -48,   -46,   -58,    91,    40,
   -57,    41,   -23,    93,   -29,   -31,   -63,   -63,   -78,   -78,
   -78,   -32,    41,   -32,    59,    59,   -32,    59,   -54,   -29,
   125,    93,   -29,    41,   -23,    41,    41,    93,   320,    41,
   -78,    41,    41,   -32,    41,   -32,    59,    93,    41,   -78,
    59,   -78,   -78,    41,   -78,    41,    41,   -32,   -78,   -78,
   -78,    41,   -78 };
yytabelem yydef[]={

    15,    -2,    16,    -2,    17,    18,    19,    -2,     2,     0,
     2,    -2,    -2,    -2,    65,    10,     0,     0,    38,    39,
    40,    41,     0,    43,    56,    57,    -2,    -2,   100,    52,
    53,    54,    55,    88,     0,    20,    -2,     4,    29,     0,
     2,     2,     0,     2,    28,     0,    23,    32,    34,    36,
    95,    -2,    11,    37,    42,    44,    45,    46,    47,    48,
    49,    50,    51,    -2,     1,    61,    62,     0,    86,     0,
     0,   101,   102,   104,     0,    -2,     0,     3,    30,    25,
    -2,    24,    26,     0,    66,    87,    96,     0,    -2,     0,
    13,    14,     0,    81,     0,    90,     0,   186,   184,   187,
   189,   191,   193,   195,   197,   200,   205,   208,   211,   215,
     1,   217,     0,     0,     0,     0,   229,   223,   224,   225,
   226,   227,   228,   237,   238,   239,   243,   244,   245,   246,
     8,   103,   105,    89,     0,    -2,    22,     0,    -2,    -2,
   149,   134,   135,   136,   137,   138,   139,     0,     0,     0,
   143,     0,     0,     0,     0,    -2,     0,     1,     0,     0,
     0,     0,    -2,    -2,   169,   171,   215,    27,     1,     0,
     2,     0,    82,    84,     0,     1,   115,     0,    91,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     2,    -2,    -2,     0,     0,     1,     1,   235,   236,   218,
     0,   219,   220,   221,     1,     0,    -2,     0,   106,   113,
   108,    -2,     8,   145,     0,   150,     0,    -2,    -2,     0,
    -2,   144,     0,     0,     0,     0,     0,     0,     0,   165,
   166,   167,     0,    -2,     0,   173,   174,   175,   176,   177,
   178,   179,   180,   181,   182,   183,    -2,    63,     0,     1,
    12,    79,     0,     0,     0,    68,     0,   118,     0,   188,
   190,   192,   194,   196,   198,   199,   201,   202,   203,   204,
   206,   207,   209,   210,   212,   213,   214,     0,   240,   120,
    71,    73,     0,   231,     0,   241,   233,   234,     0,    -2,
    93,    -2,     0,     8,     2,     0,     4,     0,   146,   147,
     0,   140,    -2,   142,   170,     0,     0,     0,     0,     0,
     0,   164,   168,   172,     0,    64,     2,    74,    76,     0,
    -2,    83,    85,    80,   116,     0,     0,   216,   121,   122,
   123,     8,     0,   230,   232,     0,   222,    92,    94,   114,
   107,   109,     2,   111,     2,   122,     8,     4,     4,   148,
   141,    -2,    -2,    -2,     0,     0,     0,     0,    58,     0,
     0,     0,    77,     0,   117,   119,   185,   124,     0,     8,
     0,   130,     0,   126,     0,   242,   110,   112,   151,   153,
   154,     0,    -2,     0,     0,     0,     0,    69,    75,    78,
    59,   128,     0,   132,     0,   125,   131,   127,    -2,     0,
   156,    -2,    -2,     0,    -2,     0,     0,   129,   133,   152,
   155,   157,   158,    -2,   160,    -2,    -2,     0,   159,   161,
   162,    -2,   163 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"BAD_TOKEN",	257,
	"INTEGER_CONSTANT",	258,
	"CHARACTER_CONSTANT",	259,
	"FLOATING_CONSTANT",	260,
	"ENUMERATION_CONSTANT",	261,
	"IDENTIFIER",	262,
	"STRING",	263,
	"TYPEDEF_NAME",	264,
	"SIZEOF",	265,
	"PTR_OP",	266,
	"INC_OP",	267,
	"DEC_OP",	268,
	"LEFT_OP",	269,
	"RIGHT_OP",	270,
	"LE_OP",	271,
	"GE_OP",	272,
	"EQ_OP",	273,
	"NE_OP",	274,
	"AND_OP",	275,
	"OR_OP",	276,
	"MUL_ASSIGN",	277,
	"DIV_ASSIGN",	278,
	"MOD_ASSIGN",	279,
	"ADD_ASSIGN",	280,
	"SUB_ASSIGN",	281,
	"LEFT_ASSIGN",	282,
	"RIGHT_ASSIGN",	283,
	"AND_ASSIGN",	284,
	"XOR_ASSIGN",	285,
	"OR_ASSIGN",	286,
	"TYPEDEF",	287,
	"EXTERN",	288,
	"STATIC",	289,
	"AUTO",	290,
	"REGISTER",	291,
	"CHAR",	292,
	"SHORT",	293,
	"INT",	294,
	"LONG",	295,
	"SIGNED",	296,
	"UNSIGNED",	297,
	"FLOAT",	298,
	"DOUBLE",	299,
	"CONST",	300,
	"VOLATILE",	301,
	"VOID",	302,
	"STRUCT",	303,
	"UNION",	304,
	"ENUM",	305,
	"ELIPSIS",	306,
	"DOTDOT",	307,
	"CASE",	308,
	"DEFAULT",	309,
	"IF",	310,
	"SWITCH",	311,
	"WHILE",	312,
	"DO",	313,
	"FOR",	314,
	"GOTO",	315,
	"CONTINUE",	316,
	"BREAK",	317,
	"RETURN",	318,
	"THEN",	319,
	"ELSE",	320,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"NS_ntd : /* empty */",
	"NS_td : /* empty */",
	"NS_scope_push : /* empty */",
	"NS_scope_pop : /* empty */",
	"NS_struct_push : /* empty */",
	"NS_struct_pop : /* empty */",
	"NS_id : /* empty */",
	"NS_new_parm : /* empty */",
	"NS_is_typedef : /* empty */",
	"NS_direct_decl : /* empty */",
	"NS_ptr_decl : /* empty */",
	"identifier : NS_ntd TYPEDEF_NAME NS_td",
	"identifier : IDENTIFIER",
	"identifier : ENUMERATION_CONSTANT",
	"translation_unit : /* empty */",
	"translation_unit : translation_unit external_declaration",
	"external_declaration : NS_id function_definition",
	"external_declaration : NS_id declaration",
	"external_declaration : NS_id untyped_declaration",
	"function_definition : function_head function_body",
	"function_definition : function_head declaration_list",
	"function_definition : function_head declaration_list function_body",
	"function_head : function_declarator NS_td",
	"function_head : declaration_specifiers function_declarator NS_td",
	"function_body : compound_statement NS_scope_pop",
	"declaration : declaration_specifiers NS_td ';'",
	"declaration : declaration_specifiers init_declarator_list NS_td ';'",
	"untyped_declaration : init_declarator_list ';'",
	"declaration_list : declaration",
	"declaration_list : declaration_list declaration",
	"declaration_specifiers : storage_class_specifier",
	"declaration_specifiers : storage_class_specifier declaration_specifiers",
	"declaration_specifiers : type_specifier",
	"declaration_specifiers : type_specifier declaration_specifiers",
	"declaration_specifiers : type_qualifier",
	"declaration_specifiers : type_qualifier declaration_specifiers",
	"storage_class_specifier : NS_is_typedef TYPEDEF",
	"storage_class_specifier : EXTERN",
	"storage_class_specifier : STATIC",
	"storage_class_specifier : AUTO",
	"storage_class_specifier : REGISTER",
	"type_specifier : NS_ntd actual_type_specifier",
	"type_specifier : type_adjective",
	"actual_type_specifier : VOID",
	"actual_type_specifier : CHAR",
	"actual_type_specifier : INT",
	"actual_type_specifier : FLOAT",
	"actual_type_specifier : DOUBLE",
	"actual_type_specifier : TYPEDEF_NAME",
	"actual_type_specifier : struct_or_union_specifier",
	"actual_type_specifier : enum_specifier",
	"type_adjective : SHORT",
	"type_adjective : LONG",
	"type_adjective : SIGNED",
	"type_adjective : UNSIGNED",
	"type_qualifier : CONST",
	"type_qualifier : VOLATILE",
	"struct_or_union_specifier : struct_or_union NS_struct_push '{' struct_declaration_list NS_struct_pop '}'",
	"struct_or_union_specifier : struct_or_union identifier NS_struct_push '{' struct_declaration_list NS_struct_pop '}'",
	"struct_or_union_specifier : struct_or_union identifier",
	"struct_or_union : STRUCT",
	"struct_or_union : UNION",
	"struct_declaration_list : struct_declaration",
	"struct_declaration_list : struct_declaration_list struct_declaration",
	"init_declarator_list : init_declarator",
	"init_declarator_list : init_declarator_list ',' init_declarator",
	"init_declarator : declarator",
	"init_declarator : declarator NS_td '=' initializer NS_ntd",
	"struct_declaration : specifier_qualifier_list struct_declarator_list NS_td ';'",
	"specifier_qualifier_list : type_specifier",
	"specifier_qualifier_list : type_specifier specifier_qualifier_list",
	"specifier_qualifier_list : type_qualifier",
	"specifier_qualifier_list : type_qualifier specifier_qualifier_list",
	"struct_declarator_list : struct_declarator",
	"struct_declarator_list : struct_declarator_list ',' struct_declarator",
	"struct_declarator : declarator",
	"struct_declarator : ':' constant_expression",
	"struct_declarator : declarator ':' constant_expression",
	"enum_specifier : ENUM '{' enumerator_list '}'",
	"enum_specifier : ENUM identifier '{' enumerator_list '}'",
	"enum_specifier : ENUM identifier",
	"enumerator_list : enumerator",
	"enumerator_list : enumerator_list ',' enumerator",
	"enumerator : IDENTIFIER",
	"enumerator : IDENTIFIER '=' constant_expression",
	"declarator : direct_declarator NS_direct_decl",
	"declarator : pointer direct_declarator NS_ptr_decl",
	"direct_declarator : IDENTIFIER",
	"direct_declarator : '(' declarator ')'",
	"direct_declarator : direct_declarator '[' ']'",
	"direct_declarator : direct_declarator '[' constant_expression ']'",
	"direct_declarator : direct_declarator NS_scope_push '(' parameter_type_list ')' NS_scope_pop",
	"direct_declarator : direct_declarator NS_scope_push '(' ')' NS_scope_pop",
	"direct_declarator : direct_declarator NS_scope_push '(' identifier_list ')' NS_scope_pop",
	"function_declarator : direct_function_declarator NS_direct_decl",
	"function_declarator : pointer direct_function_declarator NS_ptr_decl",
	"direct_function_declarator : direct_declarator NS_scope_push '(' parameter_type_list ')'",
	"direct_function_declarator : direct_declarator NS_scope_push '(' ')'",
	"direct_function_declarator : direct_declarator NS_scope_push '(' identifier_list ')'",
	"pointer : '*'",
	"pointer : '*' type_qualifier_list",
	"pointer : '*' pointer",
	"pointer : '*' type_qualifier_list pointer",
	"type_qualifier_list : type_qualifier",
	"type_qualifier_list : type_qualifier_list type_qualifier",
	"parameter_type_list : parameter_list",
	"parameter_type_list : parameter_list ',' ELIPSIS",
	"parameter_list : parameter_declaration",
	"parameter_list : parameter_list ',' parameter_declaration",
	"parameter_declaration : NS_new_parm declaration_specifiers declarator NS_td",
	"parameter_declaration : NS_new_parm declaration_specifiers NS_td",
	"parameter_declaration : NS_new_parm declaration_specifiers abstract_declarator NS_td",
	"identifier_list : IDENTIFIER",
	"identifier_list : identifier_list ',' IDENTIFIER",
	"initializer : assignment_expression",
	"initializer : '{' initializer_list '}'",
	"initializer : '{' initializer_list ',' '}'",
	"initializer_list : initializer",
	"initializer_list : initializer_list ',' initializer",
	"type_name : specifier_qualifier_list NS_td",
	"type_name : specifier_qualifier_list NS_td abstract_declarator",
	"abstract_declarator : pointer",
	"abstract_declarator : direct_abstract_declarator",
	"abstract_declarator : pointer direct_abstract_declarator",
	"direct_abstract_declarator : '(' abstract_declarator ')'",
	"direct_abstract_declarator : '[' ']'",
	"direct_abstract_declarator : '[' constant_expression ']'",
	"direct_abstract_declarator : direct_abstract_declarator '[' ']'",
	"direct_abstract_declarator : direct_abstract_declarator '[' constant_expression ']'",
	"direct_abstract_declarator : '(' ')'",
	"direct_abstract_declarator : '(' parameter_type_list ')'",
	"direct_abstract_declarator : direct_abstract_declarator '(' ')'",
	"direct_abstract_declarator : direct_abstract_declarator '(' parameter_type_list ')'",
	"statement : labeled_statement",
	"statement : compound_statement",
	"statement : expression_statement",
	"statement : selection_statement",
	"statement : iteration_statement",
	"statement : jump_statement",
	"labeled_statement : identifier ':' statement",
	"labeled_statement : CASE constant_expression ':' statement",
	"labeled_statement : DEFAULT ':' statement",
	"expression_statement : ';'",
	"expression_statement : expression ';'",
	"compound_statement : NS_scope_push '{' NS_scope_pop '}'",
	"compound_statement : NS_scope_push '{' statement_list NS_scope_pop '}'",
	"compound_statement : NS_scope_push '{' declaration_list NS_scope_pop '}'",
	"compound_statement : NS_scope_push '{' declaration_list statement_list NS_scope_pop '}'",
	"statement_list : statement",
	"statement_list : statement_list statement",
	"selection_statement : IF '(' expression ')' statement",
	"selection_statement : IF '(' expression ')' statement ELSE statement",
	"selection_statement : SWITCH '(' expression ')' statement",
	"iteration_statement : WHILE '(' expression ')' statement",
	"iteration_statement : DO statement WHILE '(' expression ')' ';'",
	"iteration_statement : FOR '(' ';' ';' ')' statement",
	"iteration_statement : FOR '(' ';' ';' expression ')' statement",
	"iteration_statement : FOR '(' ';' expression ';' ')' statement",
	"iteration_statement : FOR '(' ';' expression ';' expression ')' statement",
	"iteration_statement : FOR '(' expression ';' ';' ')' statement",
	"iteration_statement : FOR '(' expression ';' ';' expression ')' statement",
	"iteration_statement : FOR '(' expression ';' expression ';' ')' statement",
	"iteration_statement : FOR '(' expression ';' expression ';' expression ')' statement",
	"jump_statement : GOTO identifier ';'",
	"jump_statement : CONTINUE ';'",
	"jump_statement : BREAK ';'",
	"jump_statement : RETURN ';'",
	"jump_statement : RETURN expression ';'",
	"expression : assignment_expression",
	"expression : expression ',' assignment_expression",
	"assignment_expression : conditional_expression",
	"assignment_expression : unary_expression assignment_operator assignment_expression",
	"assignment_operator : '='",
	"assignment_operator : MUL_ASSIGN",
	"assignment_operator : DIV_ASSIGN",
	"assignment_operator : MOD_ASSIGN",
	"assignment_operator : ADD_ASSIGN",
	"assignment_operator : SUB_ASSIGN",
	"assignment_operator : LEFT_ASSIGN",
	"assignment_operator : RIGHT_ASSIGN",
	"assignment_operator : AND_ASSIGN",
	"assignment_operator : XOR_ASSIGN",
	"assignment_operator : OR_ASSIGN",
	"conditional_expression : logical_or_expression",
	"conditional_expression : logical_or_expression '?' expression ':' conditional_expression",
	"constant_expression : conditional_expression",
	"logical_or_expression : logical_and_expression",
	"logical_or_expression : logical_or_expression OR_OP logical_and_expression",
	"logical_and_expression : inclusive_or_expression",
	"logical_and_expression : logical_and_expression AND_OP inclusive_or_expression",
	"inclusive_or_expression : exclusive_or_expression",
	"inclusive_or_expression : inclusive_or_expression '|' exclusive_or_expression",
	"exclusive_or_expression : and_expression",
	"exclusive_or_expression : exclusive_or_expression '^' and_expression",
	"and_expression : equality_expression",
	"and_expression : and_expression '&' equality_expression",
	"equality_expression : relational_expression",
	"equality_expression : equality_expression EQ_OP relational_expression",
	"equality_expression : equality_expression NE_OP relational_expression",
	"relational_expression : shift_expression",
	"relational_expression : relational_expression '<' shift_expression",
	"relational_expression : relational_expression '>' shift_expression",
	"relational_expression : relational_expression LE_OP shift_expression",
	"relational_expression : relational_expression GE_OP shift_expression",
	"shift_expression : additive_expression",
	"shift_expression : shift_expression LEFT_OP additive_expression",
	"shift_expression : shift_expression RIGHT_OP additive_expression",
	"additive_expression : multiplicative_expression",
	"additive_expression : additive_expression '+' multiplicative_expression",
	"additive_expression : additive_expression '-' multiplicative_expression",
	"multiplicative_expression : cast_expression",
	"multiplicative_expression : multiplicative_expression '*' cast_expression",
	"multiplicative_expression : multiplicative_expression '/' cast_expression",
	"multiplicative_expression : multiplicative_expression '%' cast_expression",
	"cast_expression : unary_expression",
	"cast_expression : '(' type_name ')' cast_expression",
	"unary_expression : postfix_expression",
	"unary_expression : INC_OP unary_expression",
	"unary_expression : DEC_OP unary_expression",
	"unary_expression : unary_operator cast_expression",
	"unary_expression : SIZEOF unary_expression",
	"unary_expression : SIZEOF '(' type_name ')'",
	"unary_operator : '&'",
	"unary_operator : '*'",
	"unary_operator : '+'",
	"unary_operator : '-'",
	"unary_operator : '~'",
	"unary_operator : '!'",
	"postfix_expression : primary_expression",
	"postfix_expression : postfix_expression '[' expression ']'",
	"postfix_expression : postfix_expression '(' ')'",
	"postfix_expression : postfix_expression '(' argument_expression_list ')'",
	"postfix_expression : postfix_expression '.' identifier",
	"postfix_expression : postfix_expression PTR_OP identifier",
	"postfix_expression : postfix_expression INC_OP",
	"postfix_expression : postfix_expression DEC_OP",
	"primary_expression : IDENTIFIER",
	"primary_expression : constant",
	"primary_expression : STRING",
	"primary_expression : '(' expression ')'",
	"argument_expression_list : assignment_expression",
	"argument_expression_list : argument_expression_list ',' assignment_expression",
	"constant : INTEGER_CONSTANT",
	"constant : CHARACTER_CONSTANT",
	"constant : FLOATING_CONSTANT",
	"constant : ENUMERATION_CONSTANT",
};
#endif /* YYDEBUG */
/* 
 *	Copyright 1987 Silicon Graphics, Inc. - All Rights Reserved
 */

/* #ident	"@(#)yacc:yaccpar	1.10" */
#ident	"$Revision: 1.5 $"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:
# line 147 "grammar.y"
{ scope_push(); td(); } break;
case 4:
# line 149 "grammar.y"
{ scope_pop(); } break;
case 12:
# line 191 "grammar.y"
{yyval.nod = id_from_typedef(yypvt[-1].typ);} break;
case 17:
# line 211 "grammar.y"
{function_def(yypvt[-0].sym);} break;
case 18:
# line 212 "grammar.y"
{typed_external_decl(yypvt[-0].sym);} break;
case 21:
# line 218 "grammar.y"
{KnR_params(yypvt[-1].sym, yypvt[-0].sym);} break;
case 23:
# line 224 "grammar.y"
{
			yyval.sym = function_spec(0, yypvt[-1].nod);
			cur_func = yyval.sym;
			cur_func->_assume_int = 1;
		} break;
case 24:
# line 230 "grammar.y"
{
			yyval.sym = function_spec(yypvt[-2].typ, yypvt[-1].nod);
			cur_func = yyval.sym;
		} break;
case 26:
# line 241 "grammar.y"
{yyval.sym = novar_declaration(yypvt[-2].typ);} break;
case 27:
# line 243 "grammar.y"
{yyval.sym = var_declaration(yypvt[-3].typ, yypvt[-2].nod);} break;
case 30:
# line 252 "grammar.y"
{yyval.sym = concat_symbols(yypvt[-1].sym,yypvt[-0].sym);} break;
case 31:
# line 256 "grammar.y"
{yyval.typ = typeof_typemod(yypvt[-0].val);} break;
case 32:
# line 257 "grammar.y"
{yyval.typ = concat_types(typeof_typemod(yypvt[-1].val), yypvt[-0].typ);} break;
case 34:
# line 259 "grammar.y"
{yyval.typ = concat_types(yypvt[-1].typ, yypvt[-0].typ);} break;
case 35:
# line 260 "grammar.y"
{yyval.typ = typeof_typemod(yypvt[-0].val);} break;
case 36:
# line 261 "grammar.y"
{yyval.typ = concat_types(typeof_typemod(yypvt[-1].val), yypvt[-0].typ);} break;
case 37:
# line 265 "grammar.y"
{yyval.val = TYPEMOD_TYPEDEF;} break;
case 38:
# line 266 "grammar.y"
{yyval.val = TYPEMOD_EXTERN;} break;
case 39:
# line 267 "grammar.y"
{yyval.val = TYPEMOD_STATIC;} break;
case 40:
# line 268 "grammar.y"
{yyval.val = TYPEMOD_AUTO;} break;
case 41:
# line 269 "grammar.y"
{yyval.val = TYPEMOD_REGISTER;} break;
case 42:
# line 276 "grammar.y"
{yyval.typ = yypvt[-0].typ;} break;
case 43:
# line 277 "grammar.y"
{yyval.typ = typeof_typemod(yypvt[-0].val);} break;
case 44:
# line 281 "grammar.y"
{yyval.typ = typeof_void();} break;
case 45:
# line 282 "grammar.y"
{yyval.typ = typeof_char();} break;
case 46:
# line 283 "grammar.y"
{yyval.typ = typeof_int(0);} break;
case 47:
# line 284 "grammar.y"
{yyval.typ = typeof_float();} break;
case 48:
# line 285 "grammar.y"
{yyval.typ = typeof_double();} break;
case 50:
# line 287 "grammar.y"
{yyval.typ = typeof_specifier(yypvt[-0].sym);} break;
case 51:
# line 288 "grammar.y"
{yyval.typ = typeof_specifier(yypvt[-0].sym);} break;
case 52:
# line 292 "grammar.y"
{yyval.val = TYPEMOD_SHORT;} break;
case 53:
# line 293 "grammar.y"
{yyval.val = TYPEMOD_LONG;} break;
case 54:
# line 294 "grammar.y"
{yyval.val = TYPEMOD_SIGNED;} break;
case 55:
# line 295 "grammar.y"
{yyval.val = TYPEMOD_UNSIGNED;} break;
case 56:
# line 299 "grammar.y"
{yyval.val = TYPEMOD_CONST;} break;
case 57:
# line 300 "grammar.y"
{yyval.val = TYPEMOD_VOLATILE;} break;
case 58:
# line 305 "grammar.y"
{ yyval.sym = anonymous_rec(yypvt[-5].val, yypvt[-2].sym);} break;
case 59:
# line 307 "grammar.y"
{ yyval.sym = named_rec(yypvt[-6].val, yypvt[-5].nod, yypvt[-2].sym);} break;
case 60:
# line 308 "grammar.y"
{ yyval.sym = rec_reference(yypvt[-1].val, yypvt[-0].nod);} break;
case 61:
# line 312 "grammar.y"
{yyval.val = 0;} break;
case 62:
# line 313 "grammar.y"
{yyval.val = 1;} break;
case 64:
# line 318 "grammar.y"
{yyval.sym = concat_symbols(yypvt[-1].sym,yypvt[-0].sym);} break;
case 66:
# line 323 "grammar.y"
{yyval.nod = new_node(_List, yypvt[-2].nod, yypvt[-0].nod);} break;
case 68:
# line 328 "grammar.y"
{yyval.nod = new_node(_Assign, yypvt[-4].nod, yypvt[-1].nod);} break;
case 69:
# line 334 "grammar.y"
{yyval.sym = field_declaration(yypvt[-3].typ, yypvt[-2].nod);} break;
case 70:
# line 338 "grammar.y"
{yyval.typ = typeof_typespec(yypvt[-0].typ);} break;
case 71:
# line 339 "grammar.y"
{yyval.typ = typeof_typespec(concat_types(yypvt[-1].typ, yypvt[-0].typ));} break;
case 72:
# line 340 "grammar.y"
{yyval.typ = typeof_typespec(typeof_typemod(yypvt[-0].val));} break;
case 73:
# line 341 "grammar.y"
{yyval.typ = typeof_typespec(concat_types(typeof_typemod(yypvt[-1].val),yypvt[-0].typ));} break;
case 75:
# line 346 "grammar.y"
{yyval.nod = new_node(_List, yypvt[-2].nod, yypvt[-0].nod);} break;
case 77:
# line 351 "grammar.y"
{yyval.nod = new_node(_Bit_Field, 0, yypvt[-0].nod);} break;
case 78:
# line 352 "grammar.y"
{yyval.nod = new_node(_Bit_Field, yypvt[-2].nod, yypvt[-0].nod);} break;
case 79:
# line 356 "grammar.y"
{yyval.sym = anonymous_enum(yypvt[-1].sym);} break;
case 80:
# line 357 "grammar.y"
{yyval.sym = named_enum(yypvt[-3].nod, yypvt[-1].sym);} break;
case 81:
# line 358 "grammar.y"
{yyval.sym = enum_reference(yypvt[-0].nod);} break;
case 83:
# line 363 "grammar.y"
{yyval.sym = concat_symbols(yypvt[-2].sym,yypvt[-0].sym);} break;
case 84:
# line 367 "grammar.y"
{yyval.sym = grok_enumerator(yypvt[-0].nod,0);} break;
case 85:
# line 368 "grammar.y"
{yyval.sym = grok_enumerator(yypvt[-2].nod,yypvt[-0].nod);} break;
case 87:
# line 373 "grammar.y"
{yyval.nod = access_to(yypvt[-2].nod, yypvt[-1].nod);} break;
case 89:
# line 378 "grammar.y"
{yyval.nod = yypvt[-1].nod;} break;
case 90:
# line 379 "grammar.y"
{yyval.nod = new_node(_Array_Index, yypvt[-2].nod, 0);} break;
case 91:
# line 380 "grammar.y"
{yyval.nod = new_node(_Array_Index, yypvt[-3].nod, yypvt[-1].nod);} break;
case 92:
# line 383 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-5].nod, new_node(_Sym,yypvt[-2].sym));} break;
case 93:
# line 385 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-4].nod, 0);} break;
case 94:
# line 387 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-5].nod, yypvt[-2].nod);} break;
case 96:
# line 393 "grammar.y"
{yyval.nod = access_to(yypvt[-2].nod, yypvt[-1].nod);} break;
case 97:
# line 398 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-4].nod, new_node(_Sym,yypvt[-1].sym));} break;
case 98:
# line 400 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-3].nod, 0);} break;
case 99:
# line 402 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-4].nod, yypvt[-1].nod);} break;
case 100:
# line 406 "grammar.y"
{yyval.nod = new_node(_Indirect, 0);} break;
case 101:
# line 407 "grammar.y"
{yyval.nod = new_node(_Indirect, 0);} break;
case 102:
# line 408 "grammar.y"
{yyval.nod = new_node(_Indirect, yypvt[-0].nod);} break;
case 103:
# line 409 "grammar.y"
{yyval.nod = new_node(_Indirect, yypvt[-0].nod);} break;
case 105:
# line 414 "grammar.y"
{yyval.val = yypvt[-1].val | yypvt[-0].val;} break;
case 107:
# line 420 "grammar.y"
{
			yyval.sym = concat_symbols(yypvt[-2].sym, elipsis_arg());
		} break;
case 109:
# line 427 "grammar.y"
{yyval.sym = concat_symbols(yypvt[-2].sym,yypvt[-0].sym);} break;
case 110:
# line 432 "grammar.y"
{yyval.sym = named_abstract_param(yypvt[-2].typ, yypvt[-1].nod);} break;
case 111:
# line 434 "grammar.y"
{yyval.sym = noname_simple_param(yypvt[-1].typ);} break;
case 112:
# line 436 "grammar.y"
{yyval.sym = noname_abstract_param(yypvt[-2].typ, yypvt[-1].nod);} break;
case 114:
# line 441 "grammar.y"
{yyval.nod = new_node(_List, yypvt[-2].nod, yypvt[-0].nod);} break;
case 116:
# line 446 "grammar.y"
{yyval.nod = new_node(_Aggregate, yypvt[-1].nod);} break;
case 117:
# line 447 "grammar.y"
{yyval.nod = new_node(_Aggregate, new_node(_List, yypvt[-2].nod, 0));} break;
case 119:
# line 452 "grammar.y"
{yyval.nod = new_node(_List, yypvt[-2].nod, yypvt[-0].nod);} break;
case 121:
# line 458 "grammar.y"
{
			yyval.typ = noname_type(yypvt[-2].typ,yypvt[-0].nod);
		} break;
case 124:
# line 466 "grammar.y"
{yyval.nod = access_to(yypvt[-1].nod, yypvt[-0].nod);} break;
case 125:
# line 470 "grammar.y"
{yyval.nod = yypvt[-1].nod;} break;
case 126:
# line 471 "grammar.y"
{yyval.nod = new_node(_Array_Index, 0, 0);} break;
case 127:
# line 472 "grammar.y"
{yyval.nod = new_node(_Array_Index, 0, yypvt[-1].nod);} break;
case 128:
# line 473 "grammar.y"
{yyval.nod = new_node(_Array_Index, yypvt[-2].nod, 0);} break;
case 129:
# line 474 "grammar.y"
{yyval.nod = new_node(_Array_Index, yypvt[-3].nod, yypvt[-1].nod);} break;
case 130:
# line 475 "grammar.y"
{yyval.nod = new_node(_Func_Call, 0, 0);} break;
case 131:
# line 476 "grammar.y"
{yyval.nod = new_node(_Func_Call, 0, new_node(_Sym,yypvt[-1].sym));} break;
case 132:
# line 477 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-2].nod, 0);} break;
case 133:
# line 478 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-3].nod, new_node(_Sym,yypvt[-1].sym));} break;
case 168:
# line 545 "grammar.y"
{
			if (cur_func) cur_func->_eret = 1;
		} break;
case 170:
# line 553 "grammar.y"
{yyval.nod = new_node(_List, yypvt[-2].nod, yypvt[-0].nod);} break;
case 172:
# line 560 "grammar.y"
{yyval.nod = new_node(yypvt[-1].val, yypvt[-2].nod, yypvt[-0].nod);} break;
case 173:
# line 564 "grammar.y"
{yyval.val = _Assign;} break;
case 174:
# line 565 "grammar.y"
{yyval.val = _Mul_Assign;} break;
case 175:
# line 566 "grammar.y"
{yyval.val = _Div_Assign;} break;
case 176:
# line 567 "grammar.y"
{yyval.val = _Mod_Assign;} break;
case 177:
# line 568 "grammar.y"
{yyval.val = _Add_Assign;} break;
case 178:
# line 569 "grammar.y"
{yyval.val = _Sub_Assign;} break;
case 179:
# line 570 "grammar.y"
{yyval.val = _Shl_Assign;} break;
case 180:
# line 571 "grammar.y"
{yyval.val = _Shr_Assign;} break;
case 181:
# line 572 "grammar.y"
{yyval.val = _Band_Assign;} break;
case 182:
# line 573 "grammar.y"
{yyval.val = _Xor_Assign;} break;
case 183:
# line 574 "grammar.y"
{yyval.val = _Bor_Assign;} break;
case 185:
# line 581 "grammar.y"
{yyval.nod = new_node(_Cond, yypvt[-4].nod, yypvt[-2].nod, yypvt[-0].nod);} break;
case 188:
# line 592 "grammar.y"
{yyval.nod = new_node(_Lor, yypvt[-2].nod, yypvt[-0].nod);} break;
case 190:
# line 597 "grammar.y"
{yyval.nod = new_node(_Land, yypvt[-2].nod, yypvt[-0].nod);} break;
case 192:
# line 602 "grammar.y"
{yyval.nod = new_node(_Bor, yypvt[-2].nod, yypvt[-0].nod);} break;
case 194:
# line 607 "grammar.y"
{yyval.nod = new_node(_Xor, yypvt[-2].nod, yypvt[-0].nod);} break;
case 196:
# line 612 "grammar.y"
{yyval.nod = new_node(_Band, yypvt[-2].nod, yypvt[-0].nod);} break;
case 198:
# line 617 "grammar.y"
{yyval.nod = new_node(_Eq, yypvt[-2].nod, yypvt[-0].nod);} break;
case 199:
# line 618 "grammar.y"
{yyval.nod = new_node(_Ne, yypvt[-2].nod, yypvt[-0].nod);} break;
case 201:
# line 623 "grammar.y"
{yyval.nod = new_node(_Lt, yypvt[-2].nod, yypvt[-0].nod);} break;
case 202:
# line 624 "grammar.y"
{yyval.nod = new_node(_Gt, yypvt[-2].nod, yypvt[-0].nod);} break;
case 203:
# line 625 "grammar.y"
{yyval.nod = new_node(_Le, yypvt[-2].nod, yypvt[-0].nod);} break;
case 204:
# line 626 "grammar.y"
{yyval.nod = new_node(_Ge, yypvt[-2].nod, yypvt[-0].nod);} break;
case 206:
# line 631 "grammar.y"
{yyval.nod = new_node(_Shl, yypvt[-2].nod, yypvt[-0].nod);} break;
case 207:
# line 632 "grammar.y"
{yyval.nod = new_node(_Shr, yypvt[-2].nod, yypvt[-0].nod);} break;
case 209:
# line 637 "grammar.y"
{yyval.nod = new_node(_Add, yypvt[-2].nod, yypvt[-0].nod);} break;
case 210:
# line 638 "grammar.y"
{yyval.nod = new_node(_Sub, yypvt[-2].nod, yypvt[-0].nod);} break;
case 212:
# line 643 "grammar.y"
{yyval.nod = new_node(_Mul, yypvt[-2].nod, yypvt[-0].nod);} break;
case 213:
# line 644 "grammar.y"
{yyval.nod = new_node(_Div, yypvt[-2].nod, yypvt[-0].nod);} break;
case 214:
# line 645 "grammar.y"
{yyval.nod = new_node(_Rem, yypvt[-2].nod, yypvt[-0].nod);} break;
case 216:
# line 650 "grammar.y"
{yyval.nod = new_node(_Type_Cast, new_node(_Type, yypvt[-2].typ), yypvt[-0].nod);} break;
case 218:
# line 656 "grammar.y"
{yyval.nod = new_node(_Pre_Inc, yypvt[-0].nod);} break;
case 219:
# line 657 "grammar.y"
{yyval.nod = new_node(_Pre_Dec, yypvt[-0].nod);} break;
case 220:
# line 658 "grammar.y"
{yyval.nod = new_node(yypvt[-1].val, yypvt[-0].nod);} break;
case 221:
# line 659 "grammar.y"
{yyval.nod = new_node(_Sizeof, yypvt[-0].nod);} break;
case 222:
# line 660 "grammar.y"
{yyval.nod = new_node(_Sizeof, new_node(_Type, yypvt[-1].typ));} break;
case 223:
# line 665 "grammar.y"
{yyval.val = _Addrof;} break;
case 224:
# line 666 "grammar.y"
{yyval.val = _Indirect;} break;
case 225:
# line 667 "grammar.y"
{yyval.val = _Unary_Plus;} break;
case 226:
# line 668 "grammar.y"
{yyval.val = _Unary_Minus;} break;
case 227:
# line 669 "grammar.y"
{yyval.val = _Ones_Complement;} break;
case 228:
# line 670 "grammar.y"
{yyval.val = _Not;} break;
case 230:
# line 676 "grammar.y"
{yyval.nod = new_node(_Array_Index, yypvt[-3].nod, yypvt[-1].nod);} break;
case 231:
# line 677 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-2].nod, 0);} break;
case 232:
# line 678 "grammar.y"
{yyval.nod = new_node(_Func_Call, yypvt[-3].nod, yypvt[-1].nod);} break;
case 233:
# line 679 "grammar.y"
{yyval.nod = new_node(_Dot_Selected, yypvt[-2].nod, yypvt[-0].nod);} break;
case 234:
# line 680 "grammar.y"
{yyval.nod = new_node(_Arrow_Selected, yypvt[-2].nod, yypvt[-0].nod);} break;
case 235:
# line 681 "grammar.y"
{yyval.nod = new_node(_Post_Inc, yypvt[-1].nod);} break;
case 236:
# line 682 "grammar.y"
{yyval.nod = new_node(_Post_Dec, yypvt[-1].nod);} break;
case 240:
# line 689 "grammar.y"
{yyval.nod = yypvt[-1].nod;} break;
case 242:
# line 694 "grammar.y"
{yyval.nod = new_node(_List, yypvt[-2].nod, yypvt[-0].nod);} break;
	}
	goto yystack;		/* reset registers in driver code */
}
