/*
 * Place your configurations here
 */

#ifndef _H_CONFIGURE_
#define _H_CONFIGURE_

#undef assert

extern void assert_failed _ANSI_PROTO_((char*,int,char*));

#ifdef NDEBUG
#define assert(EX)
#else
# ifdef __ANSI_CPP__
#define assert(EX)	((EX)?((void)0):assert_failed(__FILE__,__LINE__, # EX))
# else
#define assert(EX)	((EX)?((void)0):assert_failed(__FILE__,__LINE__, "EX"))
# endif
#endif

/*
 * Type names expected from package C
 */
#ifdef SIZEOF_LONG_LONG
#define TYPE_NAMEOF_SIGNED_LONG_LONG			"c.signed_long_long"
#define TYPE_NAMEOF_SIGNED_LONG_LONG_POINTER	"c.a_signed_long_long_t"
#define TYPE_NAMEOF_UNSIGNED_LONG_LONG			"c.unsigned_long_long"
#define TYPE_NAMEOF_UNSIGNED_LONG_LONG_POINTER	"c.a_unsigned_long_long_t"
#endif
#define TYPE_NAMEOF_SIGNED_LONG					"c.signed_long"
#define TYPE_NAMEOF_SIGNED_LONG_POINTER			"c.a_signed_long_t"
#define TYPE_NAMEOF_UNSIGNED_LONG				"c.unsigned_long"
#define TYPE_NAMEOF_UNSIGNED_LONG_POINTER		"c.a_unsigned_long_t"
#define TYPE_NAMEOF_SIGNED_INT					"c.signed_int"
#define TYPE_NAMEOF_SIGNED_INT_POINTER			"c.a_signed_int_t"
#define TYPE_NAMEOF_UNSIGNED_INT				"c.unsigned_int"
#define TYPE_NAMEOF_UNSIGNED_INT_POINTER		"c.a_unsigned_int_t"
#define TYPE_NAMEOF_SIGNED_SHORT				"c.signed_short"
#define TYPE_NAMEOF_SIGNED_SHORT_POINTER		"c.a_signed_short_t"
#define TYPE_NAMEOF_UNSIGNED_SHORT				"c.unsigned_short"
#define TYPE_NAMEOF_UNSIGNED_SHORT_POINTER		"c.a_unsigned_short_t"
#define TYPE_NAMEOF_SIGNED_CHAR					"c.signed_char"
#define TYPE_NAMEOF_UNSIGNED_CHAR				"c.unsigned_char"
#define TYPE_NAMEOF_VOID						"c.void"
#define TYPE_NAMEOF_FLOAT						"c.float"
#define TYPE_NAMEOF_FLOAT_POINTER				"c.a_float_t"
#define TYPE_NAMEOF_DOUBLE						"c.double"
#define TYPE_NAMEOF_DOUBLE_POINTER				"c.a_double_t"
#define TYPE_NAMEOF_LONG_DOUBLE					"c.long_double"
#define TYPE_NAMEOF_CHAR_POINTER				"c.charp"
#define TYPE_NAMEOF_UCHAR_POINTER				"c.ucharp"
#define TYPE_NAMEOF_VOID_POINTER				"system.address"
#define TYPE_NAMEOF_FUNCTION_POINTER			"c.function_pointer"
#define TYPE_NAMEOF_STRING						"c.string"
#define TYPE_NAMEOF_USTRING						"c.ustring"

/*
 * At what column do comments begin at
 */
#define ADA_COMMENT_COLUMN				64

/*
 * Number of spaces per tab
 */
#define ADA_TAB_STOP					4


/*
 * Anonymous type naming configurations
 */
#define ADA_RESERVED_PREFIX		"c_"
#define ENUM_TYPE_PREFIX		"enum_"
#define STRUCT_TYPE_PREFIX		"struct_"
#define UNION_TYPE_PREFIX		"union_"
#define ACCESS_TYPE_PREFIX		"a_"
#define VECTOR_TYPE_PREFIX		"vector_of_"
#define MATRIX_TYPE_PREFIX		"matrix_of_"
#define OTHER_TYPE_PREFIX		"anonymous"
#define TYPE_POSTFIX			"_t"
#define HEADER_POSTFIX			""

/*
 * Functions created for macros
 */
#define MACRO_FUNC_PREFIX		"c_macro_"

#endif /* _H_CONFIGURE_ */
