//-----------------------------------------------------------------------------
// Timer
//-----------------------------------------------------------------------------

#ifndef __TIMER_H__
#define __TIMER_H__

#ifdef WIN32
  #include <wtypes.h>
#else
  #include "types.h"
#endif

#ifndef WIN32
  typedef struct
  {
    DWORD LowPart;
    LONG HighPart;
  } LARGE_INTEGER;
#endif

/**
 * Timer class.
 * The timer is used in every operations which has connections with time.
 * It is used for animations, fps, etc.
 */
class Timer
{
  public:
    /**
     * Timer initialization. The timer must be initialized manually by
     * calling this function.
     */
    static void Init(void);

    /**
     * Refresh the timer. When this function is called, the timer gets
     * the current time and store new values into public class variables.
     * @return the number of calls of the function since the timer has
     *         been created (if the engine calls this function each frames,
     *         the returned value is the number of frames since the
     *         beginning of the main loop)
     */
    static int Refresh(void);

    static double     fTime;      /**< time since window started */
    static double     flastTime;    /**< last recorded time */
    static double     frametime;    /**< time elapsed in the last frame */
    static int        frames;     /**< number of frames */

    static LARGE_INTEGER  tFrequency;
    static double     tResolution;
};

#endif
