//-----------------------------------------------------------------------------
// Parser
//-----------------------------------------------------------------------------

#ifndef __PARSER_H__
#define __PARSER_H__

#include "files.h"

#define MAXTOKEN      1024

/**
 * Parser class.
 * The parser class provides methods to parse files. This is specially used
 * for shaders parsing.
 */
class Parser
{
  public:
    static void StartParseFile(const char *name);
    static void StartParseBuffer(const BYTE *buffer, const INT size);
    static void StartParseString(const char *string);

    static void StopParseFile(void);

    static bool GetToken(bool crossline);
    static int GetOffset(void);
    static void GoTo(const INT offset);

    static char token[MAXTOKEN];        /**< buffer for tokens */
    static int scriptline;

  protected:
    static VFile *file;

    static const BYTE *buffer;
    static const BYTE *buf_start;
    static const BYTE *buf_end;
};

#endif  /* __PARSER_H__ */
