//-----------------------------------------------------------------------------
// LogFile
//-----------------------------------------------------------------------------

#include "logfile.h"
#include "cake.h"
#include "overlay.h"        // for colors
#include "system.h"

#ifdef WIN32
  #include <direct.h>         // for _getcwd
  #include <tchar.h>          // for _vsntprintf
  #include <stdarg.h>         // for va_start, va_end
#else
  #include <stdio.h>          // for vsnprintf
  #include <stdlib.h>
  #include <stdarg.h>         // for va_start, va_end
  #include <unistd.h>         // for getcwd
  #define _getcwd getcwd
  #define _vsntprintf vsnprintf
#endif

#define LOG_LINELENGTH  32768     // Max line length for a line in logfile (FIXME: is that too long ??)

LogFile::LogFile(void)
{
  // Get output filename
  _getcwd(outputfile, PATH_LENGTH);
  strcat(outputfile, "/");
  strcat(outputfile, OUTPUT_FILENAME);
  
  // Initialize logile
  if ((logfile = fopen(outputfile, "w")))
  {
    fprintf(logfile, "<html>\n<head>\n");
    fprintf(logfile, "\t<title>cake logfile</title>\n");
    fprintf(logfile, "</head>\n<body text=\"#FFFFFF\" bgcolor=\"#000000\">\n");
    fprintf(logfile, "\t<tt><font size=\"3\">\n");
    fclose(logfile);
  }
  // FIXME: Should I throw an exception ? The problem is that cake won't start
  // directly from CD or readonly media.
  else printf("ERROR: couldn't create logfile !");

  logfile = NULL;
  startNewLine = true;
}

LogFile::~LogFile(void)
{
  if ((logfile = fopen(outputfile, "at")))
  {
    fprintf(logfile, "\t</font></tt>\n");
    fprintf(logfile, "\t<hr><a href=\"http://www.calodox.org/morbac/cake\">cake homepage</a>\n");
    fprintf(logfile, "</body>\n");
    fclose(logfile);
  }
  logfile = NULL;
}

void LogFile::Insert(const char* s, ...)
{
  bool alreadyOpened = logfile?true:false;
  if (!logfile) logfile = fopen(outputfile, "at");
  if (!logfile) return;

  va_list msg;
  char buffer[LOG_LINELENGTH] = { '\0' };
  char output[LOG_LINELENGTH] = { '\0' };

  va_start(msg, s);
  _vsntprintf(buffer, LOG_LINELENGTH - 1, s, msg);  
  va_end(msg);

  int l = (int) strlen(buffer);
  for (int i = 0, j = (int) strlen(output); i < l; ++i)
  {
    if (startNewLine)
    {
      strcat(output, "\t<font color=\"#FFFFFF\">");
      j = (int) strlen(output);
      startNewLine = false;
    }

    if (buffer[i] == '\n')
    {
      strcat(output, " </font><br>\n");
      startNewLine = true;
      j = (int) strlen(output);
    }
    else if (buffer[i] == '^')
    {
      ++i;
      if (i >= l) break;
      char str_color[8] = { '\0' };
      if (buffer[i] <= '0' || buffer[i] >= '7') sprintf(str_color, "#FFFFFF");
      else sprintf(str_color, "#%2x%2x%2x", text_colors[buffer[i]-'0'][0], text_colors[buffer[i]-'0'][1], text_colors[buffer[i]-'0'][2]);
      strcat(output, "</font><font color=\"");
      strcat(output, str_color);
      strcat(output, "\">");
      j = (int) strlen(output);
    }
    else if (buffer[i] == '\t')
    {
      for (int k = 0; k < TAB_LEN; ++k) strcat(output, "&nbsp;");
      j = (int) strlen(output);
    }
    else output[j++] = buffer[i];
  }

  // Adding the line to logfile
  fprintf(logfile, "%s", output);
  if (!alreadyOpened)
  {
    fclose(logfile);
    logfile = NULL;
  }
}

FILE* LogFile::OpenFile(void)
{
  if (logfile) return logfile;
  logfile = fopen(outputfile, "at");
  if (!logfile) ThrowException(ERROR_OPENING_FILE, "LogFile::OpenFile.logfile");
  return logfile;
}

int LogFile::CloseFile(void)
{
  if (!logfile) return 0;
  int ret = fclose(logfile);
  logfile = NULL;
  return ret;
}
