#include "framework.h"
#include "console.h"
#include "overlay.h"
#include "render.h"

FrameWork::FrameWork()
{
  chars_shader = propfont1_shader = propfont1_glow_shader = propfont2_shader = -1;
}

FrameWork::~FrameWork()
{
}

void FrameWork::Init(void)
{
  Update();
}

void FrameWork::Shut(void)
{
  gConsole->Insertln("Shuting framework...");
  shaders.ResetAll();
  shaders.Update();
}

void FrameWork::Update(void)
{
  // load shader that have been referenced, and load also his textures
  // (shaders must be loaded before any other object)
  gConsole->Insertln("Updating framework shaders...");
  shaders.Update(true);
}

void FrameWork::Render(void)
{
  gRender->InitializeViewPort();        // set up 2d viewport
  gOver->Render(&shaders);          // render overlay
  gRender->ForceFlush();
}

void FrameWork::SetFont(int num, int chartype)
{
  switch (chartype)
  {
    case NORMAL_CHAR:
      chars_shader = num;
      break;
    case PROPFONT1_CHAR:
      propfont1_shader = num;
      break;
    case PROPFONT1_GLOW_CHAR:
      propfont1_glow_shader = num;
      break;
    case PROPFONT2_CHAR:
      propfont2_shader = num;
      break;
    default:
      break;
  }
}

int FrameWork::GetFont(int chartype)
{
  switch (chartype)
  {
    case NORMAL_CHAR:
      return chars_shader;
      break;
    case PROPFONT1_CHAR:
      return propfont1_shader;
      break;
    case PROPFONT1_GLOW_CHAR:
      return propfont1_glow_shader;
      break;
    case PROPFONT2_CHAR:
      return propfont2_shader;
      break;
    default:
      return -1;
      break;
  }
}